/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.servlet.filter;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.DetailedUser;
import de.accxia.apps.bitbucket.ium.servlet.filter.UserKeySession;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class UserSessionTracker {
    private final ConcurrentMap<String, UserKeySession> sessionMap = new ConcurrentHashMap<String, UserKeySession>();
    public static final Comparator<UserKeySession> BY_LAST_ACCESS_TIME = new Comparator<UserKeySession>(){

        @Override
        public int compare(UserKeySession userKeySession1, UserKeySession userKeySession2) {
            long lat1 = userKeySession1.getLastAccessedTime();
            long lat2 = userKeySession2.getLastAccessedTime();
            return Long.compare(lat1, lat2);
        }
    };
    private static UserSessionTracker instance;

    private UserSessionTracker() {
    }

    public static UserSessionTracker getInstance() {
        if (instance == null) {
            instance = new UserSessionTracker();
        }
        return instance;
    }

    public static void createOrUpdate(ApplicationUser user, HttpServletRequest httpServletRequest) {
        UserSessionTracker tracker = UserSessionTracker.getInstance();
        if (tracker != null) {
            tracker.recordHttpInteraction(user, httpServletRequest);
        }
    }

    public static void safeRemove(HttpServletRequest httpRequest) {
        UserSessionTracker tracker = UserSessionTracker.getInstance();
        if (tracker != null) {
            tracker.sessionMap.remove(httpRequest.getSession().getId());
        }
    }

    public static void safeRemove(ApplicationUser user) {
        UserSessionTracker tracker = UserSessionTracker.getInstance();
        if (tracker != null) {
            tracker.removeExpiredSessionForUser(user);
        }
    }

    public static Map<Integer, Long> createLastAccessedTimeMap(List<DetailedUser> users) {
        HashMap<Integer, Long> retVal = new HashMap<Integer, Long>();
        UserSessionTracker tracker = UserSessionTracker.getInstance();
        if (tracker != null) {
            for (DetailedUser user : users) {
                retVal.put(user.getId(), 0L);
            }
            for (UserKeySession entry : tracker.sessionMap.values()) {
                Long olderVal = (Long)retVal.get(entry.getUserId());
                if (olderVal == null) continue;
                retVal.put(entry.getUserId(), Math.max(olderVal, entry.getLastAccessedTime()));
            }
        }
        return retVal;
    }

    private synchronized void removeExpiredSessionForUser(ApplicationUser user) {
        Iterator iterator = this.sessionMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            UserKeySession userKeySession = (UserKeySession)entry.getValue();
            if (userKeySession.getUserId() != user.getId()) continue;
            iterator.remove();
        }
    }

    private synchronized void removeExpiredSession() {
        Iterator iterator = this.sessionMap.entrySet().iterator();
        long refTimeMillis = System.currentTimeMillis();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            UserKeySession userKeySession = (UserKeySession)entry.getValue();
            if (userKeySession.getLastAccessedTime() + userKeySession.getMaxInactiveInterval() >= refTimeMillis) continue;
            iterator.remove();
        }
    }

    private void recordHttpInteraction(ApplicationUser user, HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            String httpSessionId = httpSession.getId();
            if (this.sessionMap.containsKey(httpSessionId)) {
                this.updateUserKeySession((UserKeySession)this.sessionMap.get(httpSessionId), httpSession);
            } else {
                this.sessionMap.put(httpSessionId, this.createUserKeySession(user.getId(), httpSession));
            }
        }
    }

    private UserKeySession createUserKeySession(int id, HttpSession httpSession) {
        UserKeySession userKeySession = new UserKeySession(id, httpSession.getLastAccessedTime(), httpSession.getMaxInactiveInterval() * 1000, httpSession.getId());
        return userKeySession;
    }

    private void updateUserKeySession(UserKeySession userKeySession, HttpSession httpSession) {
        userKeySession.setLastAccessedTime(httpSession.getLastAccessedTime());
    }

    public List<UserKeySession> getSnapshot() {
        this.removeExpiredSession();
        List<UserKeySession> userSessions = this.sessionMap.values().stream().collect(Collectors.toList());
        Collections.sort(userSessions, Collections.reverseOrder(BY_LAST_ACCESS_TIME));
        return userSessions;
    }
}

