/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.servlet.filter;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.auth.AuthenticationService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import de.accxia.apps.bitbucket.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.bitbucket.ium.config.DAO;
import de.accxia.apps.bitbucket.ium.impl.CurrentUser;
import de.accxia.apps.bitbucket.ium.rest.RestRoute;
import de.accxia.apps.bitbucket.ium.servlet.filter.IntelligentUserManagerServletFilter;
import de.accxia.apps.bitbucket.ium.servlet.filter.UserSessionTracker;
import de.accxia.apps.bitbucket.ium.util.IUMHelperService;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class IntelligentUserManagerCerberosFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(IntelligentUserManagerServletFilter.class);
    public static final String ORIGIN = "origin";
    public static final String URI_RESTORE = "secure/restore";
    public static final String URI_DISABLE = "secure/disable";
    @ComponentImport
    private final UserService userService;
    @ComponentImport
    private final AuthenticationService authenticationService;
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private final AuthenticationContext authenticationContext;
    @ComponentImport
    private final NavBuilder navBuilder;
    private final IUMHelperService helperService;

    @Inject
    public IntelligentUserManagerCerberosFilter(UserService userService, IUMHelperService helperService, TemplateRenderer renderer, NavBuilder navBuilder, AuthenticationContext authenticationContext, AuthenticationService authenticationService) {
        this.userService = userService;
        this.helperService = helperService;
        this.renderer = renderer;
        this.navBuilder = navBuilder;
        this.authenticationContext = authenticationContext;
        this.authenticationService = authenticationService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        CurrentUser currentUser;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("IntelligentUserManagerCerberosFilter doFilter requestURI =" + (httpServletRequest.getRequestURI() != null ? httpServletRequest.getRequestURI() : "N/A") + ", servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "N/A") + ", pathInfo=" + (httpServletRequest.getPathInfo() != null ? httpServletRequest.getPathInfo() : "N/A") + ", user=" + (httpServletRequest.getRemoteUser() != null ? httpServletRequest.getRemoteUser() : "N/A"));
        }
        if (!this.authenticationContext.isAuthenticated()) {
            if (httpServletRequest.getRequestURI() != null && httpServletRequest.getRequestURI().contains(URI_DISABLE)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Received disable url=secure/disable for unAuthenticated" + httpServletRequest.getRequestURI() + " ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
                }
                ((HttpServletResponse)response).sendRedirect(httpServletRequest.getContextPath() + "/");
                return;
            }
            chain.doFilter(request, response);
            return;
        }
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (user == null || !user.isActive()) {
            chain.doFilter(request, response);
            return;
        }
        if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
            chain.doFilter(request, response);
            return;
        }
        if (httpServletRequest.getRequestURI() != null && httpServletRequest.getRequestURI().contains("j_atl_security_logout")) {
            UserSessionTracker.safeRemove(httpServletRequest);
            chain.doFilter(request, response);
            return;
        }
        if (!this.helperService.isUserInGroups(user, DAO.getIUMGroupsDisabled())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("IntelligentUserManagerCerberosFilter user " + user.getName() + " is not belong to IUM Disable :" + DAO.getIUMGroupsDisabled() + "  ==> forward doFilter ");
            }
            chain.doFilter(request, response);
            return;
        }
        if (httpServletRequest.getRequestURI() != null && httpServletRequest.getRequestURI().contains(URI_DISABLE)) {
            String username;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received disable url=secure/disable " + httpServletRequest.getRequestURI() + " ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
            }
            if ((username = request.getParameter("username")) == null || username.length() == 0) {
                ((HttpServletResponse)response).sendRedirect(httpServletRequest.getContextPath() + "/");
                return;
            }
            if (this.helperService.isUserInGroups(this.authenticationContext.getCurrentUser(), DAO.getIUMGroups())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Redirect to base url " + httpServletRequest.getContextPath() + "/");
                }
                ((HttpServletResponse)response).sendRedirect(httpServletRequest.getContextPath() + "/");
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Redirect user " + username + " to the queue ");
            }
            this.renderQueueVM(this.helperService.getQuotaForGroupOfUsername(username), httpServletRequest, (HttpServletResponse)response);
            return;
        }
        if (httpServletRequest.getRequestURI() != null && (httpServletRequest.getContentType() != null && !httpServletRequest.getContentType().contains("application/json") || !httpServletRequest.getRequestURI().contains("/rest/"))) {
            UserSessionTracker.createOrUpdate(this.authenticationContext.getCurrentUser(), httpServletRequest);
        }
        if (this.helperService.isUserInGroups(user, DAO.getIUMGroups())) {
            chain.doFilter(request, response);
            return;
        }
        if (this.shouldInterceptRestRequest(httpServletRequest)) {
            chain.doFilter((ServletRequest)httpServletRequest, response);
            this.authenticationService.clear();
            return;
        }
        if (httpServletRequest.getRequestURI() != null && (httpServletRequest.getRequestURI().contains("/rest/IUM/latest/apps") || httpServletRequest.getRequestURI().contains("/rest/IUM/latest/check") || httpServletRequest.getRequestURI().contains("/rest/IUM/latest/retry") || httpServletRequest.getRequestURI().contains("/rest/projects") || httpServletRequest.getRequestURI().contains("/rest/plugins/") || httpServletRequest.getRequestURI().contains("/rest/api") || httpServletRequest.getRequestURI().contains("/rest/ui") || httpServletRequest.getRequestURI().contains("/rest/jira-integration") || httpServletRequest.getRequestURI().contains("/rest/analytics") || httpServletRequest.getRequestURI().contains("/rest/gadget/1.0/login"))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("WatchedRestRequest=" + httpServletRequest.getRequestURI() + " ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
            }
            chain.doFilter(request, response);
            return;
        }
        if (httpServletRequest.getRequestURI() != null && httpServletRequest.getRequestURI().contains("/scm")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Clone Request " + httpServletRequest.getRequestURI() + " ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
            }
            try {
                CurrentUser cloneUser = this.helperService.enableUserFromGroup(user, httpServletRequest, true);
                httpServletRequest.getSession().setAttribute("IUMUSER", (Object)user.getName());
                chain.doFilter(request, response);
            }
            catch (Exception ex) {
                LOG.error("Exception: " + ex.getMessage(), (Throwable)ex);
            }
            finally {
                this.helperService.waitForUserFromGroup(user, httpServletRequest);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("For user[" + user.getName() + "] try to enable route=" + httpServletRequest.getRequestURI());
        }
        if ((currentUser = this.helperService.enableUserFromGroup(user, httpServletRequest, false)) != null && currentUser.user != null) {
            httpServletRequest.getSession().setAttribute("IUMUSER", (Object)user.getName());
            chain.doFilter((ServletRequest)httpServletRequest, response);
            return;
        }
        if (httpServletRequest.getContentType() != null && httpServletRequest.getContentType().contains("application/json")) {
            chain.doFilter(request, response);
        } else {
            this.renderQueueVM(currentUser.noOfUsers, httpServletRequest, (HttpServletResponse)response);
        }
    }

    private void renderQueueVM(int noOfUsers, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("redirUrl", "/");
        context.put("duration", DAO.getDuration());
        context.put("queueSize", noOfUsers);
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/queue_IUM.vm", context, (Writer)response.getWriter());
    }

    private boolean shouldInterceptRestRequest(HttpServletRequest request) {
        if (RestRoute.getInstance().isEmpty()) {
            return false;
        }
        String referrer = request.getHeader("referer");
        String path = request.getRequestURI();
        boolean contain = Arrays.stream(RestRoute.getInstance().getAllRestRoutes()).anyMatch(s -> path.indexOf((String)s) != -1);
        return contain;
    }
}

