/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.servlet.filter;

import com.atlassian.bitbucket.auth.Authentication;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionCheck;
import com.atlassian.bitbucket.permission.PermissionVote;
import com.atlassian.bitbucket.permission.PermissionVoter;
import com.atlassian.bitbucket.permission.PermissionVoterProvider;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.apps.bitbucket.ium.util.IUMHelperService;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BitbucketComponent(value="permissionVoterProviderIUM")
public class PermissionVoterProviderIUM
implements PermissionVoterProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PermissionVoterProviderIUM.class);
    @ComponentImport
    private final AuthenticationContext authenticationContext;
    private final IUMHelperService helperService;

    public PermissionVoterProviderIUM(AuthenticationContext authenticationContext, IUMHelperService helperService) {
        this.authenticationContext = authenticationContext;
        this.helperService = helperService;
    }

    @Nullable
    public PermissionVoter create(@Nonnull Authentication authentication) {
        final Optional applicationUser = authentication.getUser();
        if (applicationUser.isPresent() && ((ApplicationUser)applicationUser.get()).isActive() && this.helperService.isUserInDisabledGroups((ApplicationUser)applicationUser.get())) {
            return new PermissionVoter(){

                @Nonnull
                public PermissionVote vote(@Nonnull PermissionCheck permissionCheck) {
                    try {
                        if (permissionCheck != null && permissionCheck.getPermission() == Permission.LICENSED_USER && permissionCheck.getResult() == PermissionVote.ABSTAIN && (!PermissionVoterProviderIUM.this.authenticationContext.isAuthenticated() || PermissionVoterProviderIUM.this.helperService.isUserInEnabledGroups((ApplicationUser)applicationUser.get()) || PermissionVoterProviderIUM.this.helperService.isUserInPullGroup((ApplicationUser)applicationUser.get()))) {
                            if (LOG.isDebugEnabled()) {
                                boolean isAuth = PermissionVoterProviderIUM.this.authenticationContext.isAuthenticated();
                                boolean isEnabledGroups = PermissionVoterProviderIUM.this.helperService.isUserInEnabledGroups((ApplicationUser)applicationUser.get());
                                LOG.debug("PermissionVote applicationUser=" + ((ApplicationUser)applicationUser.get()).getName() + ", PermissionVote isAuthenticated=" + (isAuth ? "TRUE" : "FALSE") + ", PermissionVote isEnabledGroups=" + (isEnabledGroups ? "TRUE" : "FALSE") + ", PermissionVote Permission=" + permissionCheck.getPermission() + ", PermissionVote Resource=" + permissionCheck.getResource() + ", PermissionVote Result=" + permissionCheck.getResult());
                            }
                            return PermissionVote.GRANT;
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Exception " + e.getMessage(), (Throwable)e);
                    }
                    return PermissionVote.ABSTAIN;
                }
            };
        }
        return new PermissionVoter(){

            @Nonnull
            public PermissionVote vote(@Nonnull PermissionCheck permissionCheck) {
                return PermissionVote.ABSTAIN;
            }
        };
    }
}

