/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.config;

import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import de.accxia.apps.bitbucket.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.bitbucket.ium.config.DAO;
import de.accxia.apps.bitbucket.ium.side.LicenseData;
import de.accxia.apps.bitbucket.ium.side.VerifyMessage;
import de.accxia.apps.bitbucket.ium.util.IUMHelperService;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/")
@Named
public class ConfigResource {
    @ComponentImport
    private final UserManager userManager;
    private final IUMHelperService helperService;
    @ComponentImport
    private final LicenseService licenseService;

    @Inject
    public ConfigResource(UserManager userManager, IUMHelperService helperService, LicenseService licenseService) {
        this.userManager = userManager;
        this.helperService = helperService;
        this.licenseService = licenseService;
    }

    @Path(value="/sidelicense")
    @GET
    @Produces(value={"application/json"})
    public Response getSideLicenseDetails() {
        LicenseData ourSideLicense = ConditionEvaluatorIUMImpl.getSideLicense();
        VerifyMessage.License_Result licenseStatus = VerifyMessage.getLicenseStatus(ourSideLicense, ConditionEvaluatorIUMImpl.getOurServerID(), this.licenseService);
        LicenseDetails licenseDetails = null;
        licenseDetails = ourSideLicense != null ? new LicenseDetails(licenseStatus, ourSideLicense.getDueDate().toString(), ourSideLicense.getUsers(), ourSideLicense.getSSN(), ourSideLicense.getCustomer(), DAO.getSideLicense()) : new LicenseDetails(licenseStatus, null, 0, "", "", "");
        return Response.ok((Object)licenseDetails).build();
    }

    @Path(value="/check")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response checkCanGetFreeSlots(@Context HttpServletRequest request) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        String username = request.getRemoteUser();
        boolean retVal = this.helperService.isUserInEnabledGroups(username);
        map.put("valid", retVal);
        return Response.ok(map).build();
    }

    public class LicenseDetails {
        public VerifyMessage.License_Result licenseStatus;
        public String expires;
        public int users;
        public String SSN;
        public String customer;
        public String licenseKey;

        public LicenseDetails(VerifyMessage.License_Result licenseStatus, String expires, int users, String SSN, String customer, String licenseKey) {
            this.licenseStatus = licenseStatus;
            this.expires = expires;
            this.users = users;
            this.SSN = SSN;
            this.customer = customer;
            this.licenseKey = licenseKey;
        }
    }
}

