/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.servlet.filter;

import com.atlassian.bitbucket.auth.Authentication;
import com.atlassian.bitbucket.auth.AuthenticationService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import de.accxia.apps.bitbucket.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.bitbucket.ium.config.DAO;
import de.accxia.apps.bitbucket.ium.impl.CurrentUser;
import de.accxia.apps.bitbucket.ium.util.IUMHelperService;
import java.io.IOException;
import java.io.Writer;
import java.util.Base64;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Named
public class IntelligentUserManagerServletFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(IntelligentUserManagerServletFilter.class);
    @ComponentImport
    private final UserService userService;
    @ComponentImport
    private final AuthenticationService authenticationService;
    @ComponentImport
    private final TemplateRenderer renderer;
    private final IUMHelperService helperService;

    @Inject
    public IntelligentUserManagerServletFilter(UserService userService, IUMHelperService helperService, TemplateRenderer renderer, AuthenticationService authenticationService) {
        this.userService = userService;
        this.helperService = helperService;
        this.renderer = renderer;
        this.authenticationService = authenticationService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String uname = null;
        String upass = null;
        if (httpRequest.getMethod().equalsIgnoreCase("POST") || httpRequest.getHeader("Authorization") != null) {
            CurrentUser currentUser;
            ApplicationUser user;
            String encUserPass = httpRequest.getHeader("Authorization");
            if (encUserPass != null) {
                byte[] decodedBytes = Base64.getDecoder().decode(encUserPass.replace("Basic ", ""));
                String decodedString = new String(decodedBytes);
                uname = decodedString.split(":")[0];
                upass = decodedString.split(":")[1];
            } else {
                uname = request.getParameter("j_username");
                upass = request.getParameter("j_password");
            }
            if (uname == null || "".equals(uname)) {
                chain.doFilter(request, response);
            }
            if (this.helperService.isUserInGroups(user = this.userService.getUserByName(uname), DAO.getIUMGroups())) {
                chain.doFilter(request, response);
                return;
            }
            if (!this.helperService.isUserInGroups(user, DAO.getIUMGroupsDisabled())) {
                chain.doFilter(request, response);
                return;
            }
            Authentication auth = this.authenticationService.authenticate(uname, upass);
            if (auth != null && (currentUser = this.helperService.enableUserFromGroup(uname, httpRequest)) != null) {
                ApplicationUser theUser = currentUser.user;
                if (theUser != null) {
                    resp.setStatus(307);
                    resp.setHeader("Location", httpRequest.getRequestURI());
                    resp.getWriter().write("");
                    return;
                }
                this.renderQueueVM(currentUser.noOfUsers, httpRequest, (HttpServletResponse)response);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    private void renderQueueVM(int noOfUsers, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String user = request.getParameter("j_username");
        String pass = request.getParameter("j_password");
        String dest = request.getParameter("os_destination");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("user", user);
        context.put("pass", pass);
        context.put("dest", dest);
        context.put("duration", DAO.getDuration());
        context.put("queueSize", noOfUsers);
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/queue_IUM.vm", context, (Writer)response.getWriter());
    }
}

