/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.side;

import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.google.gson.Gson;
import de.accxia.apps.bitbucket.ium.config.DAO;
import de.accxia.apps.bitbucket.ium.side.LicenseData;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyMessage {
    private static String publicKey = "MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBAIYrjQBEg6RPMYXJwS8FxE5E/s0I5XCpIlBP3yGi4zm3sGwiwyqck40MzMCBbb+3RoBZZkpfzNr99WYa3x+jme8CAwEAAQ==";
    private static final String OURAPPKEY = "de.accxia.apps.bitbucket.ium";
    private static Gson gson = new Gson();
    private static final Logger log = LoggerFactory.getLogger(VerifyMessage.class);

    public static LicenseData verifyMessageString(String theMessage) throws Exception {
        byte[] vmessage;
        String[] msg = theMessage.split("\\$\\$");
        byte[] dmessage = Base64.getDecoder().decode(msg[0].getBytes());
        if (VerifyMessage.verifySignatureString(dmessage, vmessage = Base64.getDecoder().decode(msg[1].getBytes()))) {
            return (LicenseData)gson.fromJson(new String(dmessage), LicenseData.class);
        }
        return null;
    }

    public static LicenseData checkSideLicenses(String sideLicense) {
        if (sideLicense == null || "".equals(sideLicense)) {
            return null;
        }
        try {
            LicenseData res = VerifyMessage.verifyMessageString(sideLicense);
            return res;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static LicenseData checkSideLicenses(PluginSettings settings) {
        String sideLicense = DAO.getSideLicense();
        if (sideLicense == null || "".equals(sideLicense)) {
            return null;
        }
        try {
            LicenseData res = VerifyMessage.verifyMessageString(sideLicense);
            return res;
        }
        catch (Exception e) {
            log.error("ERROR = " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static boolean verifySignatureString(byte[] data, byte[] signature) throws Exception {
        try {
            Signature sig = Signature.getInstance("SHA1withRSA");
            sig.initVerify(VerifyMessage.getPublicFromString(publicKey));
            sig.update(data);
            return sig.verify(signature);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static License_Result getLicenseStatus(LicenseData sideLicense, String ourServerID, LicenseService licenseService) {
        if (sideLicense == null) {
            return License_Result.LICENSE_MISSING;
        }
        if (sideLicense.getDueDate().compareTo(new Date()) < 0) {
            return License_Result.LICENSE_EXPIRED;
        }
        if (!OURAPPKEY.equals(sideLicense.getAppKey()) && !"".equals(sideLicense.getAppKey())) {
            return License_Result.LICENSE_WRONG_APPKEY;
        }
        if (ourServerID == null || !ourServerID.equals(sideLicense.getSid()) && !"".equals(sideLicense.getSid())) {
            return License_Result.LICENSE_WRONG_SERVERID;
        }
        if (licenseService.getLicensedUsersCount() > sideLicense.getUsers()) {
            return License_Result.LICESE_USERS_LIMIT;
        }
        return License_Result.LICENSE_OK;
    }

    public static boolean isSideLicenseValid(LicenseData sideLicense, String ourServerID, LicenseService licenseService) {
        return VerifyMessage.getLicenseStatus(sideLicense, ourServerID, licenseService) == License_Result.LICENSE_OK;
    }

    public static PublicKey getPublicFromString(String publicKey) throws Exception {
        byte[] keyBytes0 = publicKey.getBytes();
        byte[] keyBytes = Base64.getDecoder().decode(keyBytes0);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePublic(spec);
    }

    public static enum License_Result {
        LICENSE_MISSING,
        LICENSE_OK,
        LICENSE_EXPIRED,
        LICESE_USERS_LIMIT,
        LICENSE_WRONG_SERVERID,
        LICENSE_WRONG_APPKEY;

    }
}

