/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.cache;

import com.atlassian.cache.CacheEntryEvent;
import com.atlassian.cache.CacheEntryListener;
import de.accxia.apps.bitbucket.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.bitbucket.ium.config.DAO;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="PropertyCacheEntryAdapter")
public class PropertyCacheEntryAdapter
implements CacheEntryListener<String, String> {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyCacheEntryAdapter.class);

    @Inject
    public PropertyCacheEntryAdapter() {
    }

    public void onAdd(@Nonnull CacheEntryEvent<String, String> cacheEntryEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("CacheEntryEvent onAdd " + (String)cacheEntryEvent.getKey() + " old=" + (String)cacheEntryEvent.getOldValue() + " new=" + (String)cacheEntryEvent.getValue());
        }
        if (((String)cacheEntryEvent.getKey()).equalsIgnoreCase("sideLicense")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[PropertyCacheEntryAdapter] receive sideLicense= [" + (String)cacheEntryEvent.getKey() + "] value=" + (String)cacheEntryEvent.getValue());
            }
            String sideLicense = (String)cacheEntryEvent.getValue();
            try {
                DAO.updateSideLicense(sideLicense);
                ConditionEvaluatorIUMImpl.deleteSideLicense();
                ConditionEvaluatorIUMImpl.setSideLicense(sideLicense);
                LOG.warn("[PropertyCacheEntryAdapter] update sideLicense " + new Date());
            }
            catch (Exception ex) {
                LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void onEvict(@Nonnull CacheEntryEvent<String, String> cacheEntryEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("CacheEntryEvent onEvict " + (String)cacheEntryEvent.getKey() + " old=" + (String)cacheEntryEvent.getOldValue() + " new=" + (String)cacheEntryEvent.getValue());
        }
    }

    public void onRemove(@Nonnull CacheEntryEvent<String, String> cacheEntryEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("CacheEntryEvent onRemove " + (String)cacheEntryEvent.getKey() + " old=" + (String)cacheEntryEvent.getOldValue() + " new=" + (String)cacheEntryEvent.getValue());
        }
    }

    public void onUpdate(@Nonnull CacheEntryEvent<String, String> cacheEntryEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("CacheEntryEvent onUpdate " + (String)cacheEntryEvent.getKey() + " old=" + (String)cacheEntryEvent.getOldValue() + " new=" + (String)cacheEntryEvent.getValue());
        }
        if (((String)cacheEntryEvent.getKey()).equalsIgnoreCase("sideLicense")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[PropertyCacheEntryAdapter] receive sideLicense= [" + (String)cacheEntryEvent.getKey() + "] value=" + (String)cacheEntryEvent.getValue());
            }
            String sideLicense = (String)cacheEntryEvent.getValue();
            try {
                DAO.updateSideLicense(sideLicense);
                ConditionEvaluatorIUMImpl.deleteSideLicense();
                ConditionEvaluatorIUMImpl.setSideLicense(sideLicense);
                LOG.warn("[PropertyCacheEntryAdapter] update sideLicense " + new Date());
            }
            catch (Exception ex) {
                LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

