var IUMWrapper = new function() {
	var self=this;
	
	this.deleteResults=function(){
		AJS.$("#results").text("");
	}
	
	this.deleteSelection=function(ele){
		var selectEle="#"+ele+"-field";
		AJS.$("#"+ele).val("").trigger('change');
		AJS.$(selectEle).val("").trigger('change');
	}
	
	this.removeEntry=function(ele){
		AJS.$(ele).closest("tr").remove();
	}
	
	function removeEnabled(ele){
		AJS.$("#action").val("remove");
		AJS.$("#groupName").val(AJS.$("#"+ele).val());
		AJS.$("#IUM-config").submit();
	}
	
	this.doSubmitList=function(){
		AJS.$("#error").text("");
		return(true);
	}

	this.doSubmit=function(){
		if (AJS.$("#action").val()=="remove"){
			return(true);
		}
		var $eles=AJS.$("input.mandatory");

		var allFilled=true;
		for (var i = 0; i < $eles.length; i += 3) {
			if ($eles[i].value!=""){
				if (($eles[i+1].value=="")|| ($eles[i+2].value=="")){
					allFilled=false;
				} else if ($eles[i].value==$eles[i+1].value){
					allFilled=false;
				}
			} else {
				$eles[i].closest("tr").remove();
			}
		}				
	
		if (AJS.$("#runuser").val()==""){
			allFilled=false;
		}

		if (allFilled) {
			AJS.$("#error").text("");
			return(true);
		}

		AJS.$("#error").text(AJS.I18n.getText('IUM-error.empty'));
		return(false);
	}

	this.doGroupSubmit=function(){
		// if (AJS.$("#action").val()=="remove"){
		// 	return(true);
		// }
		var allFilled=true;
		var errorElem=null;
		var $rowsElem=AJS.$("div#pairs  div.field-group.accxia-row")
		for (var i = 0; i < $rowsElem.length; i++) {
			var $rowElem=$($rowsElem[i])
			errorElem= $rowElem.find(".error");

			//1. input
			var parsed= $rowElem.find("input.mandatory").val()
			if (isNaN(parsed) || isNaN(parseFloat(parsed))) {
				allFilled= false;
				break;
			}
			$rowElem.find("select.mandatory").val()

			var activeGroup=$rowElem.find("select.mandatory.active-group").val();
			if(!activeGroup){
				allFilled= false;
				break;
			}
			var disableGroup=$rowElem.find("select.mandatory.disable-group").val();
			if(!disableGroup){
				allFilled= false;
				break;
			}

			console.log(parsed)
		}

		if (allFilled) {
			AJS.$(".error").text("");
			return(true);
		}
		if(!errorElem){
			errorElem=AJS.$("#error");
		}
		errorElem.text(AJS.I18n.getText('IUM-error.empty'));
		return(false);
	}

	
	this.init_sel = function(ele) {
		var l=new Object();
		l.groups = AJS.$("#" + ele).val();	
		
		AJS.$("#" + ele).auiSelect2({
			placeholder : "...",
			multiple : false,
			width : '100%',
	 		cache : true,
	 		initSelection : function(element, callback) {
				var data = {
						id : l.groups,
						text : l.groups
					}
				
				callback(data);
			},
			ajax : {
				//url : AJS.contextPath() + "/rest/api/latest/group/",
				url : AJS.contextPath() + "/rest/api/1.0/groups",
				dataType : 'json',
				escapeMarkup : function(m) {
					return m;
				},
				data: function (params) {
					var queryParameters = {
						"filter": params,
						"limit": "100"
					}
				    return queryParameters;
				},
				results: function (data, page) {
					var ind=-1;
					var dataMap = AJS.$.map(data.values, function(item) {
						ind++;
						return {
							id : item,
							text : item
						}
					});

					return {
						results: dataMap
					};
				}
			}
		}).select2('val', l.groups);
		
		return true;
	}


	// added for User Management
	var moveUsers=function(){
		if (AJS.$("#togroup").val()==AJS.$("#fromgroup").val()){
			AJS.$("#error").text(AJS.I18n.getText('de.accxia.apps.bitbucket.IUM.user.errorDifferent'));
			return(false);
		}
		AJS.$("#action2").val("move");
		AJS.$("#IUM-results").submit();
	}
	
	this.copyUsers=function(){
		if (AJS.$("#togroup").val()==AJS.$("#fromgroup").val()){
			AJS.$("#error").text(AJS.I18n.getText('de.accxia.apps.bitbucket.IUM.user.errorDifferent'));
			return(false);
		}
		AJS.$("#action2").val("copy");
		AJS.$("#IUM-results").submit();
	}
		
	this.initMoveDialog=function(){
		if (AJS.$("#togroup").val()==AJS.$("#fromgroup").val()){
			AJS.$("#error").text(AJS.I18n.getText('de.accxia.apps.bitbucket.IUM.user.errorDifferent'));
			return(false);
		}
		AJS.$(".aui-dialog2-content").html(AJS.$(".aui-dialog2-content").html()
				.replace("{0}",AJS.$("#selUser:checked").size())
				.replace("{1}",AJS.$("#fromgroup").val())
				.replace("{2}",AJS.$("#togroup").val()));
			AJS.dialog2("#demo-dialog").show();
			AJS.$("#dialog-submit-button").click(function (e) {
		   		e.preventDefault();
		    	AJS.dialog2("#demo-dialog").hide();
		    	moveUsers();
		    	return(false);
			});
			AJS.$("#dialog-close-button").click(function (e) {
		   		e.preventDefault();
		    	AJS.dialog2("#demo-dialog").hide();
			});
			return(false);
	}
	
	this.selectAll=function(){
		AJS.$(".tosel").prop('checked', AJS.$("#selAll").prop("checked"));
	}
	//end user Management
	
	
	var initUserPicker=function(){
		AJS.$("#runuser").auiSelect2();
	}
	
	this.initGroupPickers=function(){
		
		var $groupFields=AJS.$(".agroup");
		  $groupFields.each(function( index ) {
			  self.init_sel($(this).get(0).id);
		  });
		  initUserPicker();
	}
	
	this.initDialog=function(ele){
		AJS.dialog2("#demo-dialog").show();
		AJS.$("#dialog-submit-button").click(function (e) {
	   		e.preventDefault();
	    	AJS.dialog2("#demo-dialog").hide();
	    	removeEnabled(ele);
		});
	}
}	