var IUMLogout = new function() {
    var self = this;
    var theTimer;
    const INTERVAL = 15000;
    const DELTA = 300;
    const MINUTE=60 * 1000;
    const DEBUG = false;
    const IUM_CHECK_ACCESS_PING = 'bb_ium_check_access_ping'
    const IUM_CHECK_ACCESS_LOGOUT = 'bb_ium_check_access_logout'

    var logout=function(force){
        if(!force && self.theLastUserName){
            //document.location.href=AJS.$(".logout-link").attr("href");
            document.location.href=AJS.contextPath() + "/secure/disable?username="+self.theLastUserName;
        }else {
            document.location.href=AJS.$(".logout-link").attr("href");
        }
    }

    var checkApplicationAccess=function(){
        var userName=AJS.$("#current-user").attr("data-username");


        if (!userName) {
            clearInterval(theTimer);
        } else {
            self.theLastUserName = userName;
            var dateNow = Date.now();
            var dateStr = window.localStorage.getItem(IUM_CHECK_ACCESS_PING);
            var dateRef =null;
            if(dateStr){
                try {
                    dateRef = JSON.parse(dateStr);
                    var dateDiff = dateNow - dateRef.timestamp;
                    if(DEBUG){
                        console.log("CHK:" + (new Date(dateNow).toISOString().slice(-13, -5)) + " / " + (new Date(dateRef.timestamp).toISOString().slice(-13, -5)) + " Access diff " + (dateNow - dateRef.timestamp));
                    }

                    if (((Math.abs(dateDiff - INTERVAL) > DELTA) && (dateDiff < INTERVAL + 2 * DELTA)) && (dateRef.username === userName)) {
                        if(DEBUG){
                            console.log("BKP:" + (new Date(dateNow).toISOString().slice(-13, -5)) + " / " + (new Date(dateRef.timestamp).toISOString().slice(-13, -5)) + " Access diff " + (dateNow - dateRef.timestamp));
                        }
                        doProcessData(dateRef, false);
                        return;
                    }
                } catch (error) {
                    console.error(error);
                    dateRef =null;
                }
            }

            if(DEBUG){
                if(dateRef && dateRef.timestamp){
                    console.log("NET:" +( new Date().toISOString().slice(-13, -5)) + " / " + ( new Date(dateRef.timestamp).toISOString().slice(-13, -5))  +  " Access diff " +(dateNow - dateRef.timestamp) );
                }else{
                    console.log("NET:" +( new Date().toISOString().slice(-13, -5)));
                }
            }

            self.ajaxGetCall(AJS.contextPath() + "/rest/IUM/latest/check");

        }
    }

    this.startLogoutWatcher=function(){
        theTimer=setInterval(checkApplicationAccess, INTERVAL);

        window.addEventListener('storage', function(event) {
            // Check the changed key and react accordingly
            if (event.key === IUM_CHECK_ACCESS_LOGOUT) {
                var datRef =JSON.parse(event.newValue);
                if(self.theLastUserName === datRef.username){
                    logout();
                }
            }
        });
    }

    var callLogout=function(force){
        clearInterval(theTimer);
        var dateRef={username:self.theLastUserName, timestamp:Date.now()};
        window.localStorage.setItem(IUM_CHECK_ACCESS_LOGOUT,JSON.stringify(dateRef));
        logout(force);
        console.log("ACCXIA IUM: User has been logged out");
    }

    var doProcessData=function(data,withSaving){
        try {
            if (!data || !data.valid){
                callLogout();
            }
        }finally {
            if(withSaving){
                data.timestamp = Date.now();
                data.username=self.theLastUserName;
                window.localStorage.setItem(IUM_CHECK_ACCESS_PING,JSON.stringify(data));
                if(DEBUG){
                    console.log("SAVE:" + ( new Date(data.timestamp).toISOString().slice(-13, -5))  +  " data=" +JSON.stringify(data) );
                }
            }
        }
    }

    this.ajaxGetCall = function(url) {
        jQuery.ajax({
            url : url,
            dataType : 'json',
            contentType: "application/json; charset=utf-8",
            async : true,
            success : function(data) {
                doProcessData(data,true)
            },
            error :function (xhr, textStatus, errorThrown ) {
                if (xhr.status >= 400 || errorThrown ) {
                    if(xhr.status==401){
                        callLogout(true);
                        return;
                    }

                callLogout();
                }
            }
        });
    };
};

AJS.$( document ).ready(function() {
    IUMLogout.startLogoutWatcher();
});