/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.cache;

import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheEntryListener;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.apps.bitbucket.ium.cache.AbstractCachedManager;
import de.accxia.apps.bitbucket.ium.config.DAO;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component(value="PropertyCachedManager")
public class PropertyCachedManager
extends AbstractCachedManager {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyCachedManager.class);
    private Cache<String, String> cache = null;
    private ClusterService clusterService;

    @Inject
    public PropertyCachedManager(@ComponentImport ApplicationContext applicationContext, @ComponentImport ClusterService clusterService) {
        super(applicationContext);
        this.clusterService = clusterService;
    }

    @Override
    protected void doInit() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Call PropertyCachedManager doInit ");
        }
        this.cache = this.getCacheManager().getCache(DAO.class.getName() + ".property.cache", null, new CacheSettingsBuilder().remote().maxEntries(1000).unflushable().replicateAsynchronously().replicateViaCopy().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.cache.addListener((CacheEntryListener)this.propertyCacheEntryAdapter, true);
    }

    public void cleanup() {
        this.cache.removeListener((CacheEntryListener)this.propertyCacheEntryAdapter);
    }

    public String getKeyValue(String key) {
        if (this.getCache() == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("GET GetKeyValue - Cache=NULL[" + this.getClusterName() + "] for key=" + key);
            }
            return null;
        }
        String value = (String)this.cache.get((Object)key);
        if (LOG.isTraceEnabled()) {
            LOG.trace("GET GetKeyValue - Cache[" + this.cache.getName() + "],Node[" + this.getClusterName() + "] key=" + key + " value=" + (value != null ? value : "N/A"));
        }
        return value;
    }

    public String setKeyValue(String key, String value) {
        if (this.getCache() == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("SET SetKeyValue - Cache=NULL[" + this.getClusterName() + "] for key=" + key);
            }
            return null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("PUT SetKeyValue - Cache[" + this.cache.getName() + "],Node[" + this.getClusterName() + "] key=" + key + " value=" + value);
        }
        this.cache.put((Object)key, (Object)value);
        return (String)this.cache.get((Object)key);
    }

    public void deleteKey(String key) {
        if (this.getCache() == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("DELETE Cache=NULL[" + this.getClusterName() + "] for key=" + key);
            }
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("DELETE Cache[" + this.cache.getName() + "][" + this.getClusterName() + "] key=" + key);
        }
        this.cache.remove((Object)key);
    }

    public Map<String, String> getValues() {
        HashMap<String, String> retVal = new HashMap<String, String>();
        if (this.getCache() == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("GET GetValues - Cache=NULL[" + this.getClusterName() + "]");
            }
            return retVal;
        }
        for (String key : this.cache.getKeys()) {
            String cacheValue = (String)this.cache.get((Object)key);
            if (LOG.isTraceEnabled()) {
                LOG.trace("GET GetValues - Cache[" + this.cache.getName() + "][" + this.getClusterName() + "]" + (cacheValue == null ? "" : cacheValue));
            }
            retVal.put(key, cacheValue);
        }
        return retVal;
    }

    private Cache<String, String> getCache() {
        if (this.cache == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("RECREATE Cache=NULL[" + this.getClusterName() + "]");
            }
            this.doInit();
        }
        return this.cache;
    }

    public boolean deleteValues() {
        if (this.getCache() == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("DELETE Cache=NULL[" + this.getClusterName() + "]");
            }
            return false;
        }
        this.cache.removeAll();
        return true;
    }

    public String getClusterName() {
        try {
            if (this.clusterService != null) {
                return this.clusterService.getNodeId();
            }
        }
        catch (Exception ex) {
            LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
        }
        return "Node";
    }
}

