/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.conditions;

import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import de.accxia.apps.bitbucket.ium.conditions.ConditionEvaluatorIUM;
import de.accxia.apps.bitbucket.ium.conditions.ConditionType;
import de.accxia.apps.bitbucket.ium.config.DAO;
import de.accxia.apps.bitbucket.ium.listener.IUMListener;
import de.accxia.apps.bitbucket.ium.side.LicenseData;
import de.accxia.apps.bitbucket.ium.side.VerifyMessage;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component(value="LoginIsPluginLicensedCondition")
@ExportAsService(value={ConditionEvaluatorIUMImpl.class})
public class ConditionEvaluatorIUMImpl
implements ConditionEvaluatorIUM {
    @ComponentImport
    private static PluginLicenseManager licenseManager;
    @ComponentImport
    private final PluginSettingsFactory pluginSettingsFactory;
    @ComponentImport
    private static LicenseService licenseService;
    private static LicenseData sideLicense;
    private static String ourServerID;
    static PluginSettings settings;

    public static String getOurServerID() {
        return ourServerID;
    }

    public static LicenseData getSideLicense() {
        return sideLicense;
    }

    public static void setSideLicense() {
        if (IUMListener.PLUGIN_ENABLED.booleanValue()) {
            sideLicense = VerifyMessage.checkSideLicenses(settings);
        }
    }

    public static void setSideLicense(String sideLicense) {
        ConditionEvaluatorIUMImpl.sideLicense = VerifyMessage.checkSideLicenses(sideLicense);
    }

    public static void deleteSideLicense() {
        sideLicense = null;
    }

    @Inject
    public ConditionEvaluatorIUMImpl(PluginLicenseManager licenseManager, PluginSettingsFactory pluginSettingsFactory, LicenseService licenseService) {
        ConditionEvaluatorIUMImpl.licenseManager = licenseManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        settings = pluginSettingsFactory.createGlobalSettings();
        ConditionEvaluatorIUMImpl.licenseService = licenseService;
        ourServerID = licenseService.get().getServerId();
        DAO.setSettings(settings);
        ConditionEvaluatorIUMImpl.setSideLicense();
    }

    @Override
    public boolean evaluate(ConditionType type) {
        switch (type) {
            case LICENSED: {
                return ConditionEvaluatorIUMImpl.isLicenseValid();
            }
            case SIDELICENSED: {
                return VerifyMessage.isSideLicenseValid(sideLicense, ourServerID, licenseService);
            }
            case WRONGSIDELICENSE: {
                return !"".equals(DAO.getSideLicense());
            }
        }
        return false;
    }

    public static boolean isLicenseValid() {
        boolean isLicensed = false;
        if (VerifyMessage.isSideLicenseValid(sideLicense, ourServerID, licenseService)) {
            return true;
        }
        return isLicensed;
    }

    static {
        licenseService = null;
        sideLicense = null;
        settings = null;
    }
}

