/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.config;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import de.accxia.apps.bitbucket.ium.cache.PropertyCachedManager;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DAO")
public class DAO {
    private static final Logger LOG = LoggerFactory.getLogger(DAO.class);
    private static final String MYUNIQUENAME = "IUM4Bitbucket";
    public static final String REST_ROUTE = "urlRest";
    public static final String REST_INIT = "initRest";
    private static PluginSettings settings = null;
    public static final String INACTIVITY_DURATION = "inactivityDuration";
    public static final String REPEAT_INTERVAL = "interval";
    public static final String STARTING_AT = "startingAt";
    public static final String STARTING_FROM = "startingFrom";
    public static final String SYNC_REPEAT_INTERVAL = "syncRepeatInterval";
    public static final String SYNC_STARTING_AT = "syncStartingAt";
    public static final String SYNC_STARTING_FROM = "syncStartingFrom";
    public static final String SYNC_ALL_SRC_GROUP = "syncAllSrcGroup";
    public static final String SYNC_ALL_TARGET_GROUP = "syncAllTargetGroup";
    public static final String WORKING_JOB = "workingJob";
    public static final String WORKING_SYNC_JOB = "workingSyncJob";
    public static final String WORKING_DAILY_JOB = "workingDailyJob";
    public static final String DAILY_STARTING_FROM = "dailyStartingFrom";
    public static final String DAILY_REPEAT_INTERVAL = "dailyRepeatInterval";
    public static final String LOGGER = "logger";
    public static final String LOGGER_KEY = "de.accxia.apps.bitbucket.ium";
    private static final String PLUGIN_STORAGE_KEY = "de.accxia.apps.bitbucket.ium";
    public static PropertyCachedManager propertyCachedManager;

    @Inject
    public DAO(PropertyCachedManager propertyCachedManager) {
        DAO.propertyCachedManager = propertyCachedManager;
    }

    public static void setSettings(PluginSettings settings) {
        DAO.settings = settings;
        DAO.getValueByKey("sideLicense");
        DAO.getValueByKey("IUMGroup");
        DAO.getValueByKey("IUMGroupDIS");
        DAO.getValueByKey("queueSize");
        DAO.getValueByKey("duration");
        DAO.getValueByKey("internLicense");
        DAO.getValueByKey("urlLogo");
        DAO.getValueByKey("queueMessage");
        DAO.getValueByKey("samlIdp");
        DAO.getValueByKey("samlMapping");
        DAO.getValueByKey("samlAzure");
        DAO.getValueByKey(REST_ROUTE);
        DAO.getValueByKey(INACTIVITY_DURATION);
        DAO.getValueByKey(REPEAT_INTERVAL);
        DAO.getValueByKey(STARTING_AT);
        DAO.getValueByKey(STARTING_FROM);
        DAO.getValueByKey(WORKING_JOB);
        DAO.getValueByKey(LOGGER);
        DAO.getValueByKey("de.accxia.apps.bitbucket.ium");
        DAO.getValueByKey("de.accxia.apps.bitbucket.ium");
    }

    public static PluginSettings getSettings() {
        return settings;
    }

    public static String getValueByKey(String field) {
        if (propertyCachedManager == null) {
            Object value;
            if (LOG.isDebugEnabled()) {
                LOG.debug("DAO.propertyCachedManager is NULL");
            }
            if ((value = settings.get("IUM4Bitbucket." + field)) == null) {
                value = "";
                settings.put("IUM4Bitbucket." + field, (Object)"");
            }
            if ("null".equals(value)) {
                return null;
            }
            String res = String.valueOf(value);
            if (LOG.isDebugEnabled()) {
                LOG.debug("DAO.propertyCachedManager is NULL field={} value={}", new Object[]{field, res});
            }
            return res;
        }
        String ourVal = propertyCachedManager.getKeyValue(field);
        if (ourVal == null) {
            Object value = settings.get("IUM4Bitbucket." + field);
            String res = String.valueOf(value);
            if (res == null || "null".equals(res)) {
                res = "";
                settings.put("IUM4Bitbucket." + field, (Object)res);
            }
            propertyCachedManager.setKeyValue(field, res);
            if (LOG.isDebugEnabled()) {
                LOG.debug("DAO.propertyCachedManager field={} value={}", new Object[]{field, res});
            }
            return res;
        }
        if (ourVal == null || !ourVal.equals(settings.get("IUM4Bitbucket." + field))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("DAO.propertyCachedManager update field={} value={}", new Object[]{field, ourVal});
            }
            settings.put("IUM4Bitbucket." + field, (Object)ourVal);
        }
        return ourVal;
    }

    public static String setValue(String field, String value) {
        if (value == null || !value.equals(DAO.getValueByKey(field))) {
            settings.put("IUM4Bitbucket." + field, (Object)value);
            if (propertyCachedManager != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("DAO.propertyCachedManager setValue field={} value={}", new Object[]{field, value});
                }
                propertyCachedManager.setKeyValue(field, value);
            }
        }
        return value;
    }

    public static void updateSideLicense(String value) {
        DAO.setValue("sideLicense", value);
    }

    public static String getSideLicense() {
        String sideLicense = DAO.getValueByKey("sideLicense");
        return sideLicense == null ? "" : sideLicense;
    }

    public static void updateIUMGroup(String value) {
        DAO.setValue("IUMGroup", value);
    }

    public static String getIUMGroups() {
        String IUMGroup2 = DAO.getValueByKey("IUMGroup");
        return IUMGroup2 == null ? "" : IUMGroup2;
    }

    public static void updateIUMGroupDisabled(String value) {
        DAO.setValue("IUMGroupDIS", value);
    }

    public static String getIUMGroupsDisabled() {
        String IUMGroupDIS = DAO.getValueByKey("IUMGroupDIS");
        return IUMGroupDIS == null ? "" : IUMGroupDIS;
    }

    public static void updateDuration(String value) {
        DAO.setValue("duration", value);
    }

    public static String getDuration() {
        String duration = DAO.getValueByKey("duration");
        return duration == null ? "" : duration;
    }

    public static void updateInternLicense(String value) {
        String internLicense = DAO.setValue("internLicense", value);
    }

    public static String getInternLicense() {
        String internLicense = DAO.getValueByKey("internLicense");
        return internLicense == null ? "" : internLicense;
    }

    public static void updateQueueSize(String value) {
        DAO.setValue("queueSize", value);
    }

    public static String getQueueSize() {
        String queueSize = DAO.getValueByKey("queueSize");
        return queueSize == null ? "" : queueSize;
    }

    public static void updateUrlLogo(String value) {
        DAO.setValue("urlLogo", value);
    }

    public static String getUrlLogo() {
        return DAO.getValueByKey("urlLogo");
    }

    public static void updateQueueMessage(String value) {
        DAO.setValue("queueMessage", value);
    }

    public static String getQueueMessage() {
        return DAO.getValueByKey("queueMessage");
    }

    public static void updateSamlIdp(String value) {
        DAO.setValue("samlIdp", value);
    }

    public static String getSamlIdp() {
        String samlIdp = DAO.getValueByKey("samlIdp");
        return samlIdp == null ? "" : samlIdp;
    }

    public static void updateSamlMapping(String value) {
        DAO.setValue("samlMapping", value);
    }

    public static String getSamlMapping() {
        String samlMapping = DAO.getValueByKey("samlMapping");
        return samlMapping == null ? "" : samlMapping;
    }

    public static void updateSamlAzure(String value) {
        DAO.setValue("samlAzure", value == null ? "off" : "on");
    }

    public static String getSamlAzure() {
        String samlAzure = DAO.getValueByKey("samlAzure");
        return samlAzure == null ? "off" : samlAzure;
    }

    public static String getRestRoute() {
        String urlRest = DAO.getValueByKey(REST_ROUTE);
        return urlRest == null ? "" : urlRest;
    }

    public static void updateRestRoute(String value) {
        if (value == null) {
            value = "";
        }
        DAO.setValue(REST_ROUTE, value);
    }

    public static String getInactivityDuration() {
        String inactivityDuration = DAO.getValueByKey(INACTIVITY_DURATION);
        if (inactivityDuration == null || "".equals(inactivityDuration)) {
            inactivityDuration = "5";
            DAO.updateInactivityDuration(inactivityDuration);
        }
        return inactivityDuration;
    }

    public static void updateInactivityDuration(String value) {
        DAO.setValue(INACTIVITY_DURATION, value);
    }

    public static String getRepeatInterval() {
        return DAO.getValueByKey(REPEAT_INTERVAL);
    }

    public static void updateRepeatInterval(String value) {
        DAO.setValue(REPEAT_INTERVAL, value);
    }

    public static void updateStartingAt(String value) {
        DAO.setValue(STARTING_AT, value);
    }

    public static String getStartingAt() {
        return DAO.getValueByKey(STARTING_AT);
    }

    public static void updateStartingFrom(String value) {
        DAO.setValue(STARTING_FROM, value);
    }

    public static String getStartingFrom() {
        return DAO.getValueByKey(STARTING_FROM);
    }

    public static void updateWorkingJob(String value) {
        DAO.setValue(WORKING_JOB, value);
    }

    public static String getWorkingJob() {
        return DAO.getValueByKey(WORKING_JOB);
    }

    public static void updateSyncAllSrcGoups(String value) {
        DAO.setValue(SYNC_ALL_SRC_GROUP, value);
    }

    public static String getSyncAllSrcGoups() {
        String IUMGroup2 = DAO.getValueByKey(SYNC_ALL_SRC_GROUP);
        return IUMGroup2;
    }

    public static void updateSyncAllTargetGoups(String value) {
        DAO.setValue(SYNC_ALL_TARGET_GROUP, value);
    }

    public static String getSyncAllTargetGoups() {
        String IUMGroupDIS = DAO.getValueByKey(SYNC_ALL_TARGET_GROUP);
        return IUMGroupDIS;
    }

    public static String getSyncRepeatInterval() {
        String repeatInterval = DAO.getValueByKey(SYNC_REPEAT_INTERVAL);
        return repeatInterval;
    }

    public static void updateSyncRepeatInterval(String value) {
        DAO.setValue(SYNC_REPEAT_INTERVAL, value);
    }

    public static void updateSyncStartingAt(String value) {
        DAO.setValue(SYNC_STARTING_AT, value);
    }

    public static String getSyncStartingAt() {
        return DAO.getValueByKey(SYNC_STARTING_AT);
    }

    public static void updateSyncStartingFrom(String value) {
        DAO.setValue(SYNC_STARTING_FROM, value);
    }

    public static String getSyncStartingFrom() {
        return DAO.getValueByKey(SYNC_STARTING_FROM);
    }

    public static void updateSyncWorkingJob(String value) {
        DAO.setValue(WORKING_SYNC_JOB, value);
    }

    public static String getSyncWorkingJob() {
        return DAO.getValueByKey(WORKING_SYNC_JOB);
    }

    public static String getDailyRepeatInterval() {
        String repeatInterval = DAO.getValueByKey(DAILY_REPEAT_INTERVAL);
        return repeatInterval;
    }

    public static void updateDailyRepeatInterval(String value) {
        DAO.setValue(DAILY_REPEAT_INTERVAL, value);
    }

    public static String getDailyStartingFrom() {
        String repeatInterval = DAO.getValueByKey(DAILY_STARTING_FROM);
        return repeatInterval;
    }

    public static void updateDailyStartingFrom(String value) {
        DAO.setValue(DAILY_STARTING_FROM, value);
    }

    public static void updateDailyWorkingJob(String value) {
        DAO.setValue(WORKING_DAILY_JOB, value);
    }

    public static Boolean getLoggerLevel() {
        String logger = DAO.getValueByKey(LOGGER);
        return logger != null ? Boolean.valueOf(logger) : Boolean.FALSE;
    }

    public static void updateLoggerLevel(boolean value) {
        DAO.setValue(LOGGER, String.valueOf(value));
    }

    public static Map<String, String> getValues() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("IUMGroups", DAO.getIUMGroups());
        map.put("IUMGroupsDisabled", DAO.getIUMGroupsDisabled());
        map.put("duration", DAO.getDuration());
        map.put("queueSize", DAO.getQueueSize());
        map.put("samlIdp", DAO.getSamlIdp());
        map.put("samlMapping", DAO.getSamlMapping());
        map.put("sideLicense", DAO.getSideLicense());
        map.put(INACTIVITY_DURATION, DAO.getInactivityDuration());
        map.put("repeatInterval", DAO.getRepeatInterval());
        map.put(STARTING_AT, DAO.getStartingAt());
        map.put(STARTING_FROM, DAO.getStartingFrom());
        map.put(WORKING_JOB, DAO.getWorkingJob());
        map.put("loggerLevel", String.valueOf(DAO.getLoggerLevel()));
        return map;
    }
}

