/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.job;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.status.JobDetails;
import de.accxia.apps.bitbucket.ium.config.DAO;
import de.accxia.apps.bitbucket.ium.job.IUMDailyJob;
import de.accxia.apps.bitbucket.ium.job.JobDataUtils;
import de.accxia.apps.bitbucket.ium.job.MonitorJobRunner;
import de.accxia.apps.bitbucket.ium.job.ProcessResult;
import de.accxia.apps.bitbucket.ium.model.JobResultDTO;
import de.accxia.apps.bitbucket.ium.repository.JobResultRepository;
import de.accxia.apps.bitbucket.ium.repository.PocketRepository;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/djob")
@Consumes(value={"text/html", "application/json"})
@Produces(value={"application/json"})
@Component
public class JobDailyRestController {
    private static final Logger LOG = LoggerFactory.getLogger(JobDailyRestController.class);
    @ComponentImport
    private final AuthenticationContext authenticationContext;
    @ComponentImport
    private SecurityService securityService;
    @ComponentImport
    private UserAdminService userAdminService;
    @ComponentImport
    private PermissionService permissionService;
    private final PocketRepository pocketRepository;
    private final JobResultRepository jobResultRepository;
    private final MonitorJobRunner monitorJobRunner;
    private static LocalThread localThread = null;

    @Inject
    public JobDailyRestController(MonitorJobRunner monitorJobRunner, PocketRepository pocketRepository, JobResultRepository jobResultRepository, SecurityService securityService, PermissionService permissionService, UserAdminService userAdminService, AuthenticationContext authenticationContext) {
        this.monitorJobRunner = monitorJobRunner;
        this.pocketRepository = pocketRepository;
        this.jobResultRepository = jobResultRepository;
        this.permissionService = permissionService;
        this.securityService = securityService;
        this.userAdminService = userAdminService;
        this.authenticationContext = authenticationContext;
    }

    @Path(value="/config")
    @GET
    @Produces(value={"application/json"})
    public Response getCurrentConfig() {
        List<JobDetails> details;
        HashMap<Object, String> map = new HashMap<Object, String>();
        map.put("daily_repeat_interval", DAO.getDailyRepeatInterval());
        map.put("daily_starting_from", DAO.getDailyStartingFrom());
        map.put("working", String.valueOf(this.monitorJobRunner.isWorking(IUMDailyJob.class)));
        if (this.monitorJobRunner.getJobDetails(IUMDailyJob.class) != null) {
            map.put("jobDetails", this.convert2String(this.monitorJobRunner.getJobDetails(IUMDailyJob.class)));
        }
        if ((details = this.monitorJobRunner.getJobsByJobRunnerKey(IUMDailyJob.class)) != null) {
            for (int i = 0; i < details.size(); ++i) {
                map.put("jobDetails" + i, details.get(i).toString());
            }
        }
        if (this.monitorJobRunner.isWorking(IUMDailyJob.class)) {
            map.put("lastRunForJob", this.convert2String(this.monitorJobRunner.getLastRunForJob(IUMDailyJob.class)));
            map.put("lastSuccessfulRunForJob", this.convert2String(this.monitorJobRunner.getLastSuccessfulRunForJob(IUMDailyJob.class)));
            map.put("nextRunDate", this.convert2String(this.monitorJobRunner.getNextRunDate(IUMDailyJob.class)));
        }
        return Response.ok(map).build();
    }

    @Path(value="/config")
    @POST
    @Produces(value={"application/json"})
    public Response setCurrentConfig(@QueryParam(value="repeat_interval") String repeatinterval, @QueryParam(value="starting_from") String startingFrom) {
        DAO.updateDailyRepeatInterval(repeatinterval);
        DAO.updateDailyStartingFrom(startingFrom);
        return this.getCurrentConfig();
    }

    @Path(value="/start")
    @GET
    @Produces(value={"application/json"})
    public Response startDebugJob() {
        try {
            this.monitorJobRunner.doUnSchedule(IUMDailyJob.class);
            IUMDailyJob.getInstance().injectService(this.pocketRepository, this.jobResultRepository, this.securityService, this.userAdminService);
            IUMDailyJob.getInstance().injectService(this.permissionService);
            String jobKey = this.monitorJobRunner.doSchedule(JobDataUtils.createFakeIUMDailyJobData(), IUMDailyJob.getInstance());
            if (LOG.isDebugEnabled()) {
                LOG.debug("jobKey= " + jobKey);
            }
            return Response.ok((Object)"success").build();
        }
        catch (SchedulerServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/stop")
    @GET
    @Produces(value={"application/json"})
    public Response stopDebugJob() {
        try {
            this.monitorJobRunner.doUnSchedule(IUMDailyJob.class);
            return Response.ok((Object)"success").build();
        }
        catch (SchedulerServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/runnow")
    @GET
    @Produces(value={"application/json"})
    public Response runNowsJob() {
        if (localThread != null && JobDailyRestController.localThread.isWorking) {
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        try {
            HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
            parameters.put("daily_repeat_interval", (Serializable)((Object)DAO.getDailyRepeatInterval()));
            parameters.put("daily_starting_from", (Serializable)((Object)DAO.getDailyStartingFrom()));
            String currentUser = this.authenticationContext.getCurrentUser() != null ? this.authenticationContext.getCurrentUser().getName() : "IUMPlugin";
            parameters.put("current_user", (Serializable)((Object)currentUser));
            IUMDailyJob.getInstance().injectService(this.pocketRepository, this.jobResultRepository, this.securityService, this.userAdminService);
            IUMDailyJob.getInstance().injectService(this.permissionService);
            localThread = new LocalThread(currentUser, parameters);
            localThread.start();
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        catch (Exception e) {
            String response = "{\"message\":\"" + e.getMessage() + "\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
    }

    @Path(value="/jobcheck")
    @GET
    @Produces(value={"application/json"})
    public Response runNowsCheckJob() {
        if (localThread == null) {
            String response = "{\"message\":\"not stating\"}";
            return Response.ok((Object)response).build();
        }
        if (JobDailyRestController.localThread.isWorking) {
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        try {
            if (JobDailyRestController.localThread.errorMessage != null) {
                String response = "{\"message\":\"" + JobDailyRestController.localThread.errorMessage + "\"}";
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
            }
            return Response.ok(JobDailyRestController.localThread.processResultList).build();
        }
        catch (Exception e) {
            String response = "{\"message\":\"" + e.getMessage() + "\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
    }

    @Path(value="/jobresults")
    @GET
    @Produces(value={"application/json"})
    public Response getLatestJobResults() {
        if (this.jobResultRepository == null) {
            String response = "{\"message\":\"not stating\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
        List jobResultDTOList = Arrays.stream(this.jobResultRepository.findAll(0, 10)).map(jobResult -> JobResultDTO.fromAO(jobResult)).collect(Collectors.toList());
        return Response.ok(jobResultDTOList).build();
    }

    private void doSaveProcessResultList(List<ProcessResult> processResultList, Map<String, Serializable> parameters, long elapsedTime) {
        String currentUser = (String)((Object)parameters.get("current_user"));
        for (ProcessResult processResult : processResultList) {
            this.jobResultRepository.save(JobResultDTO.createJobResult(processResult, currentUser, elapsedTime));
        }
    }

    private <T> String convert2String(T t2) {
        return t2 != null ? t2.toString() : "";
    }

    class LocalThread
    extends Thread {
        Map<String, Serializable> parameters;
        String currentUser;
        List<ProcessResult> processResultList = null;
        String errorMessage;
        boolean isWorking;

        public LocalThread(String currentUser, Map<String, Serializable> parameters) {
            this.parameters = parameters;
            this.currentUser = currentUser;
            this.isWorking = false;
            this.errorMessage = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long startTime = System.currentTimeMillis();
                JobDailyRestController.localThread.isWorking = true;
                IUMDailyJob.getInstance().injectService(JobDailyRestController.this.pocketRepository, JobDailyRestController.this.jobResultRepository, JobDailyRestController.this.securityService, JobDailyRestController.this.userAdminService);
                IUMDailyJob.getInstance().injectService(JobDailyRestController.this.permissionService);
                this.parameters.put("current_user", (Serializable)((Object)this.currentUser));
                List<ProcessResult> processResultList = IUMDailyJob.getInstance().doProcessingJob(this.parameters);
                long stopTime = System.currentTimeMillis();
                long elapsedTime = stopTime - startTime;
                JobDailyRestController.localThread.processResultList = processResultList;
                JobDailyRestController.this.doSaveProcessResultList(processResultList, this.parameters, elapsedTime);
            }
            catch (Exception e) {
                LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                try {
                    JobDailyRestController.localThread.errorMessage = e.getMessage();
                }
                catch (Exception ex) {
                    LOG.error("Exception: " + ex.getMessage(), (Throwable)ex);
                    throw new RuntimeException(ex);
                }
            }
            finally {
                JobDailyRestController.localThread.isWorking = false;
            }
        }
    }
}

