/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.repository;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.apps.bitbucket.ium.model.NavUser;
import de.accxia.apps.bitbucket.ium.model.NavUserDTO;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.stream.Collectors;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService(value={NavUserRepository.class})
@Component(value="NavUserRepository")
public class NavUserRepository {
    private static final Logger logger = LoggerFactory.getLogger(LoggerFactory.class);
    @ComponentImport
    private final ActiveObjects ao;

    @Autowired
    public NavUserRepository(ActiveObjects ao) {
        this.ao = ao;
    }

    public NavUser save(NavUserDTO navUserDTO) {
        logger.debug("Called save for user {}", (Object)navUserDTO.getUserName());
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("REQUEST_COUNT", navUserDTO.getRequestCount());
        values.put("USER_NAME", navUserDTO.getUserName());
        values.put("LAST_ACCESS_TIME", navUserDTO.getLastAccessTime());
        values.put("CREATION_TIME", navUserDTO.getCreationTime());
        NavUser response = (NavUser)this.ao.create(NavUser.class, values);
        logger.debug("Successfully save for user {}", (Object)navUserDTO.getUserName());
        return response;
    }

    public NavUser update(NavUser refNavUser, NavUserDTO navUserDTO) {
        if (refNavUser != null) {
            refNavUser.setRequestCount(navUserDTO.getRequestCount());
            refNavUser.setLastAccessTime(navUserDTO.getLastAccessTime());
            refNavUser.setUserName(navUserDTO.getUserName());
            refNavUser.save();
        } else {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("REQUEST_COUNT", navUserDTO.getRequestCount());
            values.put("USER_NAME", navUserDTO.getUserName());
            values.put("LAST_ACCESS_TIME", navUserDTO.getLastAccessTime());
            values.put("CREATION_TIME", navUserDTO.getLastAccessTime());
            refNavUser = (NavUser)this.ao.executeInTransaction(() -> (NavUser)this.ao.create(NavUser.class, values));
        }
        return refNavUser;
    }

    public NavUser update(Long id, String sessionId, Long requestCount, String userName) {
        NavUser navUser = (NavUser)this.ao.get(NavUser.class, (Object)new Integer(id.intValue()));
        if (navUser != null) {
            navUser.setRequestCount(requestCount);
            navUser.setLastAccessTime(new Date());
            navUser.setUserName(userName);
            navUser.save();
        } else {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("REQUEST_COUNT", requestCount);
            values.put("USER_NAME", userName);
            values.put("LAST_ACCESS_TIME", new Date());
            values.put("CREATION_TIME", new Date());
            values.put("ASESSION_ID", sessionId);
            values.put("SESSION_ID", sessionId);
            navUser = (NavUser)this.ao.create(NavUser.class, values);
        }
        return navUser;
    }

    public NavUser[] getBySession(String asessionId, String sessionId) {
        if (logger.isDebugEnabled()) {
            logger.debug("Called getAllByUsers for session {} asession {} ", (Object)asessionId, (Object)sessionId);
        }
        NavUser[] queryResult = (NavUser[])this.ao.find(NavUser.class, Query.select().where("ASESSION_ID = ? AND SESSION_ID = ? ", new Object[]{asessionId, sessionId}).order("LAST_ACCESS_TIME DESC"));
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully fetch result for session {} asession {} ", (Object)asessionId, (Object)sessionId);
        }
        return queryResult;
    }

    public NavUser[] getByUserName(String userName) {
        if (logger.isDebugEnabled()) {
            logger.debug("Called getByUserName for userName {} ", (Object)userName);
        }
        NavUser[] queryResult = (NavUser[])this.ao.find(NavUser.class, Query.select().where("USER_NAME = ? ", new Object[]{userName}).order("LAST_ACCESS_TIME DESC"));
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully fetch result for userName {} ", (Object)userName);
        }
        return queryResult;
    }

    public NavUser[] getAllByUsers(String[] userNames) {
        if (logger.isDebugEnabled()) {
            logger.debug("Called getAllByUsers for userNames {}", (Object)Arrays.stream(userNames).collect(Collectors.joining(",")));
        }
        NavUser[] queryResult = (NavUser[])this.ao.find(NavUser.class, Query.select().where("USER_NAME in ?", (Object[])userNames));
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully fetch result for userNames {}", (Object)Arrays.stream(userNames).collect(Collectors.joining(",")));
        }
        return queryResult;
    }

    public NavUser[] getOldestUsers(String[] userNames, int ctx) {
        if (logger.isDebugEnabled()) {
            logger.debug("Called getAllByUsers for userNames {}", (Object)Arrays.stream(userNames).collect(Collectors.joining(",")));
        }
        String placeholderCommaList = Arrays.stream(userNames).map(un -> "?").collect(Collectors.joining(","));
        NavUser[] queryResult = (NavUser[])this.ao.find(NavUser.class, Query.select().where("USER_NAME in  ( " + placeholderCommaList + " )", (Object[])userNames).order("LAST_ACCESS_TIME ASC").limit(ctx));
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully fetch result for userNames {}", (Object)Arrays.stream(userNames).collect(Collectors.joining(",")));
        }
        return queryResult;
    }

    public NavUser[] getAll() {
        if (logger.isDebugEnabled()) {
            logger.debug("Called getAll ");
        }
        NavUser[] queryResult = (NavUser[])this.ao.find(NavUser.class, Query.select());
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully fetch result for getAll");
        }
        return queryResult;
    }

    public int deleteBySession(String asessionId, String sessionId) {
        return this.ao.deleteWithSQL(NavUser.class, "ASESSION_ID = ? AND SESSION_ID = ? ", new Object[]{asessionId, sessionId});
    }

    public int deleteOldestExceptUsers(String userName, NavUser navUser) {
        if (logger.isDebugEnabled()) {
            logger.debug("Called deleteOldestExceptUsers for userName {} except {}", (Object)userName, (Object)navUser.getID());
        }
        int cnt = this.ao.deleteWithSQL(NavUser.class, "USER_NAME = ? AND ID != ? ", new Object[]{userName, navUser.getID()});
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully deleteOldestExceptUsers  for userName {} except {}", (Object)userName, (Object)navUser.getID());
        }
        return cnt;
    }

    public void delete(NavUser navUser) {
        this.ao.delete(new RawEntity[]{navUser});
    }
}

