/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.rest;

import de.accxia.apps.bitbucket.ium.config.DAO;
import java.util.Arrays;
import java.util.stream.Collectors;

public class RestRoute {
    private static RestRoute instance = null;
    private static final String REGEX = "[\r][\n]";
    public static final String[] REST_ROUTE_DEFAULT = new String[]{"/rest/api"};
    public static final String[] REST_ROUTE = new String[]{"/rest/greenhopper", "/rest/restresource", "/rest/capabilities"};
    private String[] restRoutes;

    private RestRoute() {
        String tmp = DAO.getRestRoute();
        String init = DAO.getValueByKey("initRest");
        if (!(init != null && init.length() != 0 || tmp != null && tmp.length() != 0)) {
            tmp = String.join((CharSequence)", ", REST_ROUTE);
            DAO.setValue("initRest", "true");
        }
        this.updateRestRoute(tmp);
    }

    public static String removeDefaultRoute(String urlRest) {
        if (!urlRest.isEmpty()) {
            urlRest = Arrays.stream(urlRest.split(REGEX)).filter(route -> !RestRoute.isDefaultRestRoute(route)).collect(Collectors.joining("\r\n"));
        }
        return urlRest;
    }

    private static boolean isDefaultRestRoute(String route) {
        boolean found = false;
        for (int i = 0; i < REST_ROUTE_DEFAULT.length; ++i) {
            if (!REST_ROUTE_DEFAULT[i].equalsIgnoreCase(route)) continue;
            found = true;
            break;
        }
        return found;
    }

    public void updateRestRoute(String tmpRestRoutes) {
        this.restRoutes = tmpRestRoutes == null || tmpRestRoutes.length() == 0 ? new String[]{} : tmpRestRoutes.split(REGEX);
    }

    public String[] getRestRoutes() {
        return this.restRoutes;
    }

    public String[] getAllRestRoutes() {
        if (this.isEmpty()) {
            return REST_ROUTE_DEFAULT;
        }
        return RestRoute.concatWithArrayCopy(REST_ROUTE_DEFAULT, this.restRoutes);
    }

    public boolean isEmpty() {
        return this.restRoutes == null || this.restRoutes.length == 0;
    }

    public static RestRoute getInstance() {
        if (instance == null) {
            instance = new RestRoute();
        }
        return instance;
    }

    private static <T> T[] concatWithArrayCopy(T[] array1, T[] array2) {
        T[] result = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }
}

