/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.servlet;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.bitbucket.log.LoggingService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import de.accxia.apps.bitbucket.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.bitbucket.ium.config.DAO;
import de.accxia.apps.bitbucket.ium.job.JobClusterService;
import de.accxia.apps.bitbucket.ium.listener.IUMListener;
import de.accxia.apps.bitbucket.ium.model.JobResultDTO;
import de.accxia.apps.bitbucket.ium.rest.RestRoute;
import de.accxia.apps.bitbucket.ium.util.IUMGroup;
import de.accxia.apps.bitbucket.ium.util.IUMHelperService;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class AdminServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(AdminServlet.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final long serialVersionUID = 1L;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserService userService;
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private final LoginUriProvider loginUriProvider;
    @ComponentImport
    private final ApplicationProperties applicationProperties;
    @ComponentImport
    private final I18nService i18nService;
    @ComponentImport
    private final WebSudoManager webSudoManager;
    @ComponentImport
    private final LicenseService licenseService;
    @ComponentImport
    private final LoggingService clusteredLoggingService;
    @ComponentImport
    private SecurityService securityService;
    private final IUMHelperService helperService;
    private final JobClusterService jobClusterService;
    private final IUMListener iumListener;

    @Inject
    public AdminServlet(UserManager userManager, TemplateRenderer renderer, LoginUriProvider loginUriProvider, UserService userService, I18nService i18nService, ApplicationProperties applicationProperties, IUMListener iumListener, LicenseService licenseService, WebSudoManager webSudoManager, LoggingService clusteredLoggingService, SecurityService securityService, JobClusterService jobClusterService, IUMHelperService helperService) {
        this.userManager = Objects.requireNonNull(userManager);
        this.renderer = Objects.requireNonNull(renderer);
        this.loginUriProvider = Objects.requireNonNull(loginUriProvider);
        this.applicationProperties = applicationProperties;
        this.userService = userService;
        this.i18nService = i18nService;
        this.webSudoManager = webSudoManager;
        this.iumListener = iumListener;
        this.licenseService = licenseService;
        this.jobClusterService = jobClusterService;
        this.helperService = helperService;
        this.securityService = securityService;
        this.clusteredLoggingService = clusteredLoggingService;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            boolean showSideLicense;
            this.webSudoManager.willExecuteWebSudoRequest(request);
            UserProfile user = this.userManager.getRemoteUser(request);
            if (user == null || !this.userManager.isAdmin(user.getUserKey())) {
                throw new WebSudoSessionException();
            }
            String pageId = request.getParameter("page");
            Page page = Page.getPage(pageId);
            if (page == Page.PageLicense) {
                this.renderSideLicenseVM(response, null, null);
                return;
            }
            boolean bl = showSideLicense = !"".equals(DAO.getSideLicense());
            if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
                this.renderLicenseErrorVM(response, showSideLicense);
                return;
            }
            switch (page) {
                case PageGroupSettings: 
                case PageLicense: {
                    this.renderAdminVM(response, null, null, page, showSideLicense);
                    return;
                }
                case PageSAMLSSO: {
                    this.renderSamlVM(response, null, null);
                    return;
                }
            }
            this.renderAdminVM(response, null, null, page, showSideLicense);
        }
        catch (WebSudoSessionException wes) {
            LOG.error("Exception:" + wes.getMessage(), (Throwable)wes);
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            boolean showSideLicense;
            this.webSudoManager.willExecuteWebSudoRequest(request);
            UserProfile theUser = this.userManager.getRemoteUser(request);
            if (theUser == null || !this.userManager.isAdmin(theUser.getUserKey())) {
                throw new WebSudoSessionException();
            }
            String pageId = request.getParameter("page");
            Page page = Page.getPage(pageId);
            if (page == Page.PageLicense) {
                try {
                    String sideLicense = request.getParameter("sideLicense");
                    if (sideLicense == null || "".equals(sideLicense)) {
                        ConditionEvaluatorIUMImpl.deleteSideLicense();
                    }
                    DAO.updateSideLicense(sideLicense);
                    ConditionEvaluatorIUMImpl.setSideLicense();
                    this.renderSideLicenseVM(response, this.i18nService.getMessagePattern("de.accxia.apps.bitbucket.IUM.save.license"), null);
                }
                catch (Exception e) {
                    LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                    this.renderSideLicenseVM(response, null, e.getMessage());
                }
                return;
            }
            boolean bl = showSideLicense = !"".equals(DAO.getSideLicense());
            if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
                this.renderLicenseErrorVM(response, showSideLicense);
                return;
            }
            String action = request.getParameter("action");
            if ("remove".equals(action)) {
                String successMessage = this.helperService.disabelAllUsersFromTheEnabledGroups(request.getParameter("groupName"));
                this.renderAdminVM(response, successMessage, null, Page.PageUserManagement, showSideLicense);
                return;
            }
            switch (page) {
                case PageSAMLSSO: {
                    try {
                        String samlIdp = "";
                        if (request.getParameter("samlIdp") != null) {
                            samlIdp = request.getParameter("samlIdp");
                        }
                        DAO.updateSamlIdp(samlIdp);
                        String samlMapping = "saml2:nameId";
                        if (request.getParameter("samlMapping") != null) {
                            samlMapping = request.getParameter("samlMapping");
                        }
                        DAO.updateSamlMapping(samlMapping);
                        String samlAzureStr = null;
                        if (request.getParameter("samlAzure") != null) {
                            samlAzureStr = request.getParameter("samlAzure");
                        }
                        DAO.updateSamlAzure(samlAzureStr);
                        this.renderSamlVM(response, this.i18nService.getMessagePattern("de.accxia.apps.bitbucket.IUM.save.saml"), null);
                    }
                    catch (Exception e) {
                        LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                        this.renderSamlVM(response, null, e.getMessage());
                    }
                    return;
                }
                case PageGroupSettings: {
                    try {
                        if (request.getParameterValues("IUMGroup") != null && request.getParameterValues("IUMGroupDIS") != null && request.getParameterValues("queueSize") != null) {
                            List enableGroups = Arrays.stream(request.getParameterValues("IUMGroup")).distinct().collect(Collectors.toList());
                            List disableGroups = Arrays.stream(request.getParameterValues("IUMGroupDIS")).distinct().collect(Collectors.toList());
                            List queueSize = Arrays.stream(request.getParameterValues("queueSize")).collect(Collectors.toList());
                            if (enableGroups.size() == disableGroups.size() && enableGroups.size() == queueSize.size()) {
                                String reportGroups = String.join((CharSequence)",", enableGroups);
                                DAO.updateIUMGroup(reportGroups);
                                String reportGroupsDIS = String.join((CharSequence)",", disableGroups);
                                DAO.updateIUMGroupDisabled(reportGroupsDIS);
                                DAO.updateQueueSize(String.join((CharSequence)",", queueSize));
                                String duration = "1";
                                if (request.getParameterValues("duration") != null) {
                                    duration = String.join((CharSequence)",", request.getParameterValues("duration"));
                                    DAO.updateDuration(duration);
                                }
                                String internLicense = "1";
                                if (request.getParameterValues("internLicense") != null) {
                                    internLicense = String.join((CharSequence)",", request.getParameterValues("internLicense"));
                                }
                                DAO.updateInternLicense(internLicense);
                                this.renderAdminVM(response, this.i18nService.getMessagePattern("de.accxia.apps.bitbucket.IUM.save.group"), null, page, showSideLicense);
                                return;
                            }
                        }
                        throw new Exception(" Invalid Parameters Error");
                    }
                    catch (Exception e) {
                        LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                        this.renderAdminVM(response, null, e.getMessage(), page, showSideLicense);
                        return;
                    }
                }
                case PageJob: {
                    try {
                        String workingJob;
                        String startingFrom;
                        String inactivityDuration;
                        boolean shouldRestart = false;
                        String repeatInterval = request.getParameter("repeatInterval");
                        if (repeatInterval != null && !repeatInterval.equalsIgnoreCase(DAO.getRepeatInterval())) {
                            try {
                                Long.parseLong(repeatInterval);
                                DAO.updateRepeatInterval(repeatInterval);
                            }
                            catch (Exception e) {
                                repeatInterval = null;
                                LOG.error("Exception " + e.getMessage(), (Throwable)e);
                            }
                            shouldRestart = true;
                        }
                        if ((inactivityDuration = request.getParameter("inactivityDuration")) != null && !inactivityDuration.equalsIgnoreCase(DAO.getInactivityDuration())) {
                            try {
                                Long.parseLong(inactivityDuration);
                                DAO.updateInactivityDuration(inactivityDuration);
                            }
                            catch (Exception e) {
                                inactivityDuration = null;
                                LOG.error("Exception " + e.getMessage(), (Throwable)e);
                            }
                            shouldRestart = true;
                        }
                        if ((startingFrom = request.getParameter("startingFrom")) != null && !startingFrom.equalsIgnoreCase(DAO.getStartingFrom())) {
                            try {
                                Long.parseLong(startingFrom);
                                DAO.updateStartingFrom(startingFrom);
                            }
                            catch (Exception e) {
                                startingFrom = null;
                                LOG.error("Exception " + e.getMessage(), (Throwable)e);
                            }
                            shouldRestart = true;
                        }
                        if ((workingJob = request.getParameter("workingJob")) != null && "on".equalsIgnoreCase(workingJob)) {
                            DAO.updateWorkingJob(workingJob);
                            if (shouldRestart || !this.jobClusterService.isWorking()) {
                                LOG.info("Start JobService " + new Date());
                                this.jobClusterService.start();
                                this.iumListener.publishJobNotification(true);
                            }
                        } else if (workingJob == null || "off".equalsIgnoreCase(workingJob)) {
                            DAO.updateWorkingJob("off");
                            if (this.jobClusterService.isWorking()) {
                                LOG.info("Stop JobService " + new Date());
                                this.jobClusterService.stop();
                                this.iumListener.publishJobNotification(false);
                            }
                        }
                        this.renderAdminVM(response, this.i18nService.getMessagePattern("de.accxia.apps.bitbucket.IUM.save.job"), null, page, showSideLicense);
                    }
                    catch (Exception e) {
                        LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                        this.renderAdminVM(response, null, e.getMessage(), page, showSideLicense);
                    }
                    return;
                }
                case PageDesign: {
                    try {
                        String urlLogo = request.getParameter("urlLogo");
                        DAO.updateUrlLogo(urlLogo);
                        String queueMessage = request.getParameter("queueMessage");
                        if (StringUtils.isEmpty((CharSequence)queueMessage)) {
                            queueMessage = this.i18nService.getMessagePattern("IUM-queueMessage.default");
                        }
                        DAO.updateQueueMessage(queueMessage);
                        this.renderAdminVM(response, this.i18nService.getMessagePattern("de.accxia.apps.bitbucket.IUM.save.design"), null, page, showSideLicense);
                    }
                    catch (Exception e) {
                        LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                        this.renderAdminVM(response, null, e.getMessage(), page, showSideLicense);
                    }
                    return;
                }
                case PageLogging: {
                    try {
                        String logger = request.getParameter("logger");
                        if (logger != null && "on".equalsIgnoreCase(logger)) {
                            this.setDebugLogger(true);
                        } else {
                            this.setDebugLogger(false);
                        }
                        this.renderAdminVM(response, this.i18nService.getMessagePattern("de.accxia.apps.bitbucket.IUM.save.logging"), null, page, showSideLicense);
                    }
                    catch (Exception e) {
                        LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                        this.renderAdminVM(response, null, e.getMessage(), page, showSideLicense);
                    }
                    return;
                }
                case PageRest: {
                    try {
                        String urlRest = request.getParameter("urlRest");
                        DAO.updateRestRoute(urlRest);
                        RestRoute.getInstance().updateRestRoute(urlRest);
                        this.renderAdminVM(response, this.i18nService.getMessagePattern("de.accxia.apps.bitbucket.IUM.save.rest"), null, page, showSideLicense);
                    }
                    catch (Exception e) {
                        LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                        this.renderAdminVM(response, null, e.getMessage(), page, showSideLicense);
                    }
                    return;
                }
            }
            this.renderAdminVM(response, null, null, page, showSideLicense);
        }
        catch (WebSudoSessionException wes) {
            LOG.error("Exception:" + wes.getMessage(), (Throwable)wes);
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    private void renderSamlVM(HttpServletResponse response, String successMessage, String errorMessages) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("samlIdp", DAO.getSamlIdp());
        context.put("samlMapping", DAO.getSamlMapping());
        context.put("samlAzure", "on".equalsIgnoreCase(DAO.getSamlAzure()));
        context.put("successMessage", successMessage);
        context.put("errorMessages", errorMessages);
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/SAML_IUM.vm", context, (Writer)response.getWriter());
    }

    private void renderSideLicenseVM(HttpServletResponse response, String successMessage, String errorMessages) throws IOException {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("sideLicense", this.getSideLicense());
        context.put("successMessage", successMessage);
        context.put("errorMessages", errorMessages);
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/sidelicense_IUM.vm", context, (Writer)response.getWriter());
    }

    private void renderLicenseErrorVM(HttpServletResponse response, boolean showSideLicense) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("showSideLicense", showSideLicense);
        context.put("baseurl", this.applicationProperties.getBaseUrl());
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/checklicense_IUM.vm", context, (Writer)response.getWriter());
    }

    private void renderAdminVM(HttpServletResponse response, String successMessage, String errorMessages, Page page, boolean showSideLicense) throws IOException {
        String queueMessage;
        String urlLogo;
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("successMessage", successMessage);
        context.put("errorMessages", errorMessages);
        context.put("showSideLicense", showSideLicense);
        if (page == Page.PageGroupSettings) {
            this.addGroupSettings(context);
        }
        if (page == Page.PageDesign) {
            urlLogo = DAO.getValueByKey("urlLogo");
            queueMessage = DAO.getValueByKey("queueMessage");
            context.put("urlLogo", urlLogo.isEmpty() ? "" : urlLogo);
            if (StringUtils.isEmpty((CharSequence)queueMessage)) {
                queueMessage = this.i18nService.getMessagePattern("IUM-queueMessage.default");
                DAO.updateQueueMessage(queueMessage);
            }
            context.put("queueMessage", queueMessage);
        }
        context.put("testing", true);
        if (ConditionEvaluatorIUMImpl.getSideLicense() != null) {
            context.put("enhanced", ConditionEvaluatorIUMImpl.getSideLicense().getAppKey().contains("Enhanced"));
        }
        if (page == Page.PageDesign) {
            urlLogo = DAO.getValueByKey("urlLogo");
            queueMessage = DAO.getValueByKey("queueMessage");
            context.put("urlLogo", urlLogo.isEmpty() ? "" : urlLogo);
            if (StringUtils.isEmpty((CharSequence)queueMessage)) {
                queueMessage = this.i18nService.getMessagePattern("IUM-queueMessage.default");
                queueMessage = this.setValue("queueMessage", queueMessage);
            }
            context.put("queueMessage", queueMessage);
        }
        if (page == Page.PageRest) {
            String urlRest = DAO.getValueByKey("urlRest");
            if (!urlRest.isEmpty()) {
                urlRest = RestRoute.removeDefaultRoute(urlRest);
            }
            context.put("urlRest", urlRest.isEmpty() ? "" : urlRest);
        }
        if (page == Page.PageJob) {
            context.put("repeatInterval", DAO.getRepeatInterval());
            context.put("inactivityDuration", DAO.getInactivityDuration());
            context.put("startingFrom", DAO.getStartingFrom());
            context.put("serverTime", SDF.format(new Date()));
            context.put("workingJob", this.jobClusterService.isWorking());
            if (this.jobClusterService.getNextRunDate() != null) {
                context.put("nextRunDate", SDF.format(this.jobClusterService.getNextRunDate()));
            }
            this.addLatestJobClusterResults(context);
        }
        if (page == Page.PageLogging) {
            context.put("logger", this.getDebugLogger());
        }
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/" + page.pageName, context, (Writer)response.getWriter());
    }

    private void addGroupSettings(Map<String, Object> context) {
        String duration;
        ArrayList<IUMGroup> groupPairs = new ArrayList<IUMGroup>();
        String[] iumEnableGroups = DAO.getIUMGroups().split(",");
        String[] iumDisableGroups = DAO.getIUMGroupsDisabled().split(",");
        String[] iumQueueSize = DAO.getQueueSize().split(",");
        for (int i = 0; i < iumEnableGroups.length; ++i) {
            groupPairs.add(new IUMGroup(iumEnableGroups[i], iumDisableGroups.length > i ? iumDisableGroups[i] : "", iumQueueSize.length > i ? AdminServlet.safeParseInt(iumQueueSize[i], 1) : 0));
        }
        List<String> allGroupList = this.helperService.getAllGroups();
        List<String> allBitbucketGroupList = this.helperService.getBitbucketGroups();
        context.put("groupPairs", groupPairs);
        context.put("allGroups", allGroupList);
        context.put("bitbucketGroups", allBitbucketGroupList);
        ArrayList nonBitbucketGroups = new ArrayList(CollectionUtils.removeAll(allGroupList, allBitbucketGroupList));
        context.put("nonBitbucketGroups", nonBitbucketGroups);
        context.put("licenseConsuming", this.helperService.getLicenseUsedByIUM().size());
        context.put("licenseConsumingUsers", this.helperService.getLicenseUsedByIUM());
        context.put("licenseConsumingPowerUsers", this.helperService.getUsersWithBitbucketAccessOtherIUM().size() + 3);
        if (this.licenseService != null && this.licenseService.get() != null) {
            if (this.licenseService.get().isUnlimitedNumberOfUsers()) {
                context.put("serviceSeats", 50000);
            } else if (this.licenseService.get().getMaximumNumberOfUsers() > 0) {
                context.put("serviceSeats", this.licenseService.get().getMaximumNumberOfUsers());
            } else {
                context.put("serviceSeats", 0);
                context.put("errorMessages", "Error retrieving the number of licenses");
            }
        }
        context.put("duration", (duration = DAO.getDuration()).isEmpty() ? "24" : duration);
    }

    private void addLatestJobClusterResults(Map<String, Object> context) {
        List<JobResultDTO> jobResultDTOList = this.jobClusterService.findLatest(0, 10);
        this.customProcessJobResult(jobResultDTOList);
        context.put("jobResults", jobResultDTOList);
    }

    private void customProcessJobResult(List<JobResultDTO> jobResultDTOList) {
        for (JobResultDTO jobResult : jobResultDTOList) {
            if (jobResult.getSourceGroups() != null) {
                String[] tmpSourceGroups = jobResult.getSourceGroups().split(";");
                jobResult.setShortSourceGroups(tmpSourceGroups.length > 0 ? tmpSourceGroups[0] : "");
                jobResult.setSourceGroups(jobResult.getSourceGroups().replaceAll(";", ", "));
            }
            if (jobResult.getTargetGroup() == null) continue;
            String[] tmpTargetGroup = jobResult.getTargetGroup().split(";");
            jobResult.setShortTargetGroup(tmpTargetGroup.length > 0 ? tmpTargetGroup[0] : "");
            jobResult.setTargetGroup(jobResult.getTargetGroup().replaceAll(";", ", "));
        }
    }

    public String getSideLicense() {
        String sideLicense = DAO.getSideLicense();
        return sideLicense;
    }

    private void setDebugLogger(boolean b) {
        DAO.updateLoggerLevel(b);
        this.securityService.withPermission(Permission.SYS_ADMIN, "Accxia").call(() -> {
            this.clusteredLoggingService.setLevel("de.accxia.apps.bitbucket.ium", b ? "DEBUG" : "INFO");
            return 0;
        });
    }

    private boolean getDebugLogger() {
        String retVal = (String)this.securityService.withPermission(Permission.SYS_ADMIN, "Accxia").call(() -> this.clusteredLoggingService.getLevel("de.accxia.apps.bitbucket.ium"));
        if (LOG.isInfoEnabled()) {
            LOG.info("IntelligentUserManagerConfigServlet=" + (retVal != null ? retVal : "NULL"));
        }
        return "DEBUG".equalsIgnoreCase(retVal);
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private String setValue(String key, String value) {
        if (value == null) {
            value = "";
        }
        DAO.setValue(key, value);
        return value;
    }

    private static int safeParseInt(String value, int defValue) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            return defValue;
        }
    }

    static enum Page {
        None("", "empty.vm"),
        PageGroupSettings("group", "admin_group_IUM.vm"),
        PageDesign("design", "admin_design_IUM.vm"),
        PageRest("rest", "admin_rest_IUM.vm"),
        PageLogging("logging", "admin_logging_IUM.vm"),
        PageUserManagement("user", "user_IUM.vm"),
        PageJob("job", "admin_job_IUM.vm"),
        PageLicense("sl", "sidelicense_IUM.vm"),
        PageSAMLSSO("saml", "SAML_IUM.vm");

        String pageId;
        String pageName;

        private Page(String pageId, String pageName) {
            this.pageId = pageId;
            this.pageName = pageName;
        }

        public static Page getPage(String pageId) {
            if (pageId == null) {
                return PageGroupSettings;
            }
            for (Page p : Page.values()) {
                if (!p.pageId.equals(pageId)) continue;
                return p;
            }
            return None;
        }
    }
}

