/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.api.querydsl.tuple;

import com.atlassian.annotations.Internal;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.dsl.NumberExpression;
import java.math.BigDecimal;
import java.util.function.Function;

@Internal
class TupleMapper {
    TupleMapper() {
    }

    <T> Function<Tuple, T> column(Expression<T> expr) {
        return tuple -> {
            Object t2 = tuple.get(expr);
            return t2 == null ? null : t2;
        };
    }

    <T extends Number> Function<Tuple, Integer> toInt(NumberExpression<T> expr) {
        return tuple -> {
            Number t2 = (Number)tuple.get(expr);
            return t2 == null ? null : Integer.valueOf(t2.intValue());
        };
    }

    <T extends Number> Function<Tuple, Long> toLong(NumberExpression<T> expr) {
        return tuple -> {
            Number t2 = (Number)tuple.get(expr);
            return t2 == null ? null : Long.valueOf(t2.longValue());
        };
    }

    <T extends Number> Function<Tuple, Float> toFloat(NumberExpression<T> expr) {
        return tuple -> {
            Number t2 = (Number)tuple.get(expr);
            return t2 == null ? null : Float.valueOf(t2.floatValue());
        };
    }

    <T extends Number> Function<Tuple, Double> toDouble(NumberExpression<T> expr) {
        return tuple -> {
            Number t2 = (Number)tuple.get(expr);
            return t2 == null ? null : Double.valueOf(t2.doubleValue());
        };
    }

    <T extends Number> Function<Tuple, BigDecimal> toBigDecimal(NumberExpression<T> expr) {
        return tuple -> {
            Number t2 = (Number)tuple.get(expr);
            if (t2 instanceof BigDecimal) {
                return (BigDecimal)t2;
            }
            return t2 == null ? null : new BigDecimal(t2.doubleValue());
        };
    }
}

