/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.cache;

import com.atlassian.cache.CacheEntryEvent;
import com.atlassian.cache.CacheEntryListener;
import de.accxia.apps.bitbucket.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.bitbucket.ium.config.DAO;
import de.accxia.apps.bitbucket.ium.job.JobClusterService;
import java.lang.reflect.Field;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="PropertyCacheEntryAdapter")
public class PropertyCacheEntryAdapter
implements CacheEntryListener<String, String> {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyCacheEntryAdapter.class);
    private final JobClusterService jobClusterService;

    @Inject
    public PropertyCacheEntryAdapter(JobClusterService jobClusterService) {
        this.jobClusterService = jobClusterService;
    }

    public void onAdd(@Nonnull CacheEntryEvent<String, String> cacheEntryEvent) {
        if (!(cacheEntryEvent.getKey() instanceof String) || !(cacheEntryEvent.getValue() instanceof String)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CacheEntryEvent onAdd " + (String)cacheEntryEvent.getKey() + " old=" + (String)cacheEntryEvent.getOldValue() + " new=" + (String)cacheEntryEvent.getValue());
        }
        if (((String)cacheEntryEvent.getKey()).equalsIgnoreCase("sideLicense")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[PropertyCacheEntryAdapter] receive sideLicense= [" + (String)cacheEntryEvent.getKey() + "] value=" + (String)cacheEntryEvent.getValue());
            }
            String sideLicense = (String)cacheEntryEvent.getValue();
            try {
                DAO.updateSideLicense(sideLicense);
                ConditionEvaluatorIUMImpl.deleteSideLicense();
                ConditionEvaluatorIUMImpl.setSideLicense(sideLicense);
                LOG.info("[PropertyCacheEntryAdapter] update sideLicense " + new Date());
            }
            catch (Exception ex) {
                LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void onEvict(@Nonnull CacheEntryEvent<String, String> cacheEntryEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("CacheEntryEvent onEvict " + (String)cacheEntryEvent.getKey() + " old=" + (String)cacheEntryEvent.getOldValue() + " new=" + (String)cacheEntryEvent.getValue());
        }
    }

    public void onRemove(@Nonnull CacheEntryEvent<String, String> cacheEntryEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("CacheEntryEvent onRemove " + (String)cacheEntryEvent.getKey() + " old=" + (String)cacheEntryEvent.getOldValue() + " new=" + (String)cacheEntryEvent.getValue());
        }
    }

    public void onUpdate(@Nonnull CacheEntryEvent<String, String> cacheEntryEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("CacheEntryEvent onUpdate " + (String)cacheEntryEvent.getKey() + " old=" + (String)cacheEntryEvent.getOldValue() + " new=" + (String)cacheEntryEvent.getValue());
            LOG.debug("CacheEntryEvent onUpdate " + (String)cacheEntryEvent.getKey() + " new=" + ((String)cacheEntryEvent.getValue()).getClass().getName());
        }
        if (((String)cacheEntryEvent.getKey()).equalsIgnoreCase("sideLicense")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[PropertyCacheEntryAdapter] receive sideLicense= [" + (String)cacheEntryEvent.getKey() + "] value=" + (String)cacheEntryEvent.getValue());
            }
            String sideLicense = (String)cacheEntryEvent.getValue();
            try {
                DAO.updateSideLicense(sideLicense);
                ConditionEvaluatorIUMImpl.deleteSideLicense();
                ConditionEvaluatorIUMImpl.setSideLicense(sideLicense);
                LOG.info("[PropertyCacheEntryAdapter] update sideLicense " + new Date());
            }
            catch (Exception ex) {
                LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private String extractValueFromEntryEvent(CacheEntryEvent<String, String> cacheEntryEvent) {
        if (cacheEntryEvent.getValue() instanceof String) {
            return (String)cacheEntryEvent.getValue();
        }
        if (cacheEntryEvent.getValue() == null) {
            return "";
        }
        Field field = null;
        try {
            field = FieldUtils.getField(((String)cacheEntryEvent.getValue()).getClass(), (String)"value", (boolean)true);
            field.setAccessible(true);
            String str = field.get(cacheEntryEvent.getValue()) == null ? "" : field.get(cacheEntryEvent.getValue()).toString();
            return str;
        }
        catch (Exception ex) {
            LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
            return "";
        }
    }
}

