/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.job;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.crowd.exception.PermissionException;
import de.accxia.apps.bitbucket.ium.job.IJob;
import de.accxia.apps.bitbucket.ium.job.ProcessResult;
import de.accxia.apps.bitbucket.ium.job.access.AccxiaAccessMap;
import de.accxia.apps.bitbucket.ium.job.access.IUMBaseAccess;
import de.accxia.apps.bitbucket.ium.job.access.IntentRemoveAccess;
import de.accxia.apps.bitbucket.ium.repository.JobResultRepository;
import de.accxia.apps.bitbucket.ium.repository.PocketRepository;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMAccessJob
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMAccessJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static IUMAccessJob instance;
    private PermissionService permissionService;
    private PocketRepository pocketRepository;
    private JobResultRepository jobResultRepository;
    private SecurityService securityService;
    private UserAdminService userAdminService;
    private AccxiaAccessMap accxiaAccessMap;

    private IUMAccessJob() {
    }

    public static IUMAccessJob getInstance() {
        if (instance == null) {
            instance = new IUMAccessJob();
        }
        return instance;
    }

    @Override
    public void injectService(PocketRepository pocketRepository, JobResultRepository jobResultRepository, SecurityService securityService, UserAdminService userAdminService) {
        IUMAccessJob.instance.pocketRepository = pocketRepository;
        IUMAccessJob.instance.jobResultRepository = jobResultRepository;
        IUMAccessJob.instance.securityService = securityService;
        IUMAccessJob.instance.userAdminService = userAdminService;
    }

    @Override
    public void injectService(PermissionService permissionService) {
        IUMAccessJob.instance.permissionService = permissionService;
    }

    @Override
    public void injectService(AccxiaAccessMap accxiaAccessMap) {
        this.accxiaAccessMap = accxiaAccessMap;
    }

    @Override
    public List<ProcessResult> doProcessingJob(Map<String, Serializable> parameters) throws PermissionException {
        long timestamp = System.currentTimeMillis();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMAccessJob start process #[" + SDF.format(new Date()) + "] ");
        }
        ArrayList<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        for (String username : this.accxiaAccessMap.getKeys()) {
            IUMBaseAccess baseAccess = this.accxiaAccessMap.getValue(username);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("IUMAccessJob groups = {} -> {}  at [ {} ] ", new Object[]{baseAccess.getDisableGroups(), baseAccess.getEnableGroups(), SDF.format(new Date())});
            }
            if (!(baseAccess instanceof IntentRemoveAccess)) continue;
            this.removeUserFromGroup(username, baseAccess.getArrayEnableGroups());
            this.accxiaAccessMap.remove(username);
            ProcessResult processResult = new ProcessResult("AccessJob", baseAccess.getEnableGroups(), baseAccess.getDisableGroups());
            processResultList.add(processResult);
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMAccessJob end process #[" + SDF.format(new Date()) + "]  time spent (sec) = " + String.valueOf((System.currentTimeMillis() - timestamp) / 1000L));
        }
        return processResultList;
    }

    private boolean removeUserFromGroup(String usename, String[] groups) {
        boolean retVal = (Boolean)this.securityService.withPermission(Permission.ADMIN, "Accxia").call(() -> {
            try {
                for (String group : groups) {
                    this.userAdminService.removeUserFromGroup(group, usename);
                }
            }
            catch (Exception e) {
                this.LOG.error("Exception[removeUserFromGroup]: " + e.getMessage());
                return false;
            }
            return true;
        });
        return retVal;
    }

    private boolean addUserToGroup(String usename, String[] groups) {
        boolean retVal = (Boolean)this.securityService.withPermission(Permission.ADMIN, "Accxia").call(() -> {
            try {
                for (String group : groups) {
                    this.userAdminService.addUserToGroups(usename, Collections.singleton(group));
                }
            }
            catch (Exception e) {
                this.LOG.error("Exception[removeUserFromGroup]: " + e.getMessage());
                return false;
            }
            return true;
        });
        return retVal;
    }
}

