/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.job;

import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserAdminService;
import de.accxia.apps.bitbucket.ium.job.IJob;
import de.accxia.apps.bitbucket.ium.job.JobData;
import de.accxia.apps.bitbucket.ium.job.ProcessResult;
import de.accxia.apps.bitbucket.ium.repository.JobResultRepository;
import de.accxia.apps.bitbucket.ium.repository.PocketRepository;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMFakeJob
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMFakeJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private PermissionService permissionService;
    private PocketRepository pocketRepository;
    private JobResultRepository jobResultRepository;
    private SecurityService securityService;
    private UserAdminService userAdminService;
    private static IUMFakeJob instance;
    int syncUsers = 0;

    private IUMFakeJob() {
    }

    public static IUMFakeJob getInstance() {
        if (instance == null) {
            instance = new IUMFakeJob();
        }
        return instance;
    }

    @Override
    public void injectService(PocketRepository pocketRepository, JobResultRepository jobResultRepository, SecurityService securityService, UserAdminService userAdminService) {
        IUMFakeJob.instance.pocketRepository = pocketRepository;
        IUMFakeJob.instance.jobResultRepository = jobResultRepository;
        IUMFakeJob.instance.securityService = securityService;
        IUMFakeJob.instance.userAdminService = userAdminService;
    }

    @Override
    public void injectService(PermissionService permissionService) {
        IUMFakeJob.instance.permissionService = permissionService;
    }

    @Override
    public List<ProcessResult> doProcessingJob(Map<String, Serializable> parameters) {
        int startingFrom;
        long repeatInterval;
        ArrayList<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        String enableGroups = (String)((Object)parameters.get("enable_groups"));
        String disableGroups = (String)((Object)parameters.get("disable_groups"));
        long inactivityInterval = (Long)parameters.get("inactivity_interval");
        if (inactivityInterval <= 0L) {
            inactivityInterval = JobData.DEFAULT_USER_INACTIVITY_INTERVAL;
        }
        if ((repeatInterval = ((Long)parameters.get("repeat_interval")).longValue()) <= 0L) {
            repeatInterval = 60L;
        }
        if ((startingFrom = ((Integer)parameters.get("starting_from")).intValue()) <= 0) {
            startingFrom = 1;
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMFakeJob Process with groups={} interval={} at [ {} ] ", new Object[]{enableGroups, inactivityInterval, SDF.format(new Date())});
        }
        this.LOG.info("IUMFakeJob Process with groups={}/{} interval={} [{} / {}] at [ {} ] ", new Object[]{disableGroups, enableGroups, inactivityInterval, repeatInterval, startingFrom, SDF.format(new Date())});
        return processResultList;
    }
}

