/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.job;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.scheduler.status.RunDetails;
import de.accxia.apps.bitbucket.ium.job.IUMSyncJob;
import de.accxia.apps.bitbucket.ium.job.JobDataUtils;
import de.accxia.apps.bitbucket.ium.job.MonitorJobRunner;
import java.util.Date;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ExportAsService(value={JobSyncService.class})
@Named(value="jobSyncService")
public class JobSyncService {
    private static final Logger LOG = LoggerFactory.getLogger(JobSyncService.class);
    private final MonitorJobRunner monitorJobRunner;

    @Autowired
    public JobSyncService(MonitorJobRunner monitorJobRunner) {
        this.monitorJobRunner = monitorJobRunner;
    }

    public boolean start() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("JobSyncService call start");
            }
            this.monitorJobRunner.doUnSchedule(IUMSyncJob.class);
            this.monitorJobRunner.doSchedule(JobDataUtils.createIUMSyncJobData(), IUMSyncJob.getInstance());
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            LOG.error("Exception" + msg, (Throwable)e);
            return false;
        }
    }

    public boolean stop() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("JobSyncService doStop");
            }
            this.monitorJobRunner.doUnSchedule(IUMSyncJob.class);
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            LOG.error("Exception" + msg, (Throwable)e);
            return false;
        }
    }

    public boolean isWorking() {
        return this.monitorJobRunner.isWorking(IUMSyncJob.class);
    }

    public JobDetails getJobDetails() {
        return this.monitorJobRunner.getJobDetails(IUMSyncJob.class);
    }

    public Date getNextRunDate() {
        return this.monitorJobRunner.getNextRunDate(IUMSyncJob.class);
    }

    public RunDetails getLastSuccessfulRunForJob() {
        return this.monitorJobRunner.getLastSuccessfulRunForJob(IUMSyncJob.class);
    }
}

