/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.rest;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.log.LoggingService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.apps.bitbucket.ium.impl.CurrentUser;
import de.accxia.apps.bitbucket.ium.util.IUMHelperService;
import de.accxia.apps.bitbucket.ium.util.Quota;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/apps")
@Component
@UnrestrictedAccess
public class IUMRest {
    private static final Logger LOG = LoggerFactory.getLogger(IUMRest.class);
    @ComponentImport
    private final AuthenticationContext authenticationContext;
    @ComponentImport
    private SecurityService securityService;
    @ComponentImport
    private final LoggingService loggingService;
    private final IUMHelperService helperService;

    @Autowired
    public IUMRest(SecurityService securityService, IUMHelperService helperService, AuthenticationContext authenticationContext, LoggingService loggingService) {
        this.helperService = helperService;
        this.authenticationContext = authenticationContext;
        this.securityService = securityService;
        this.loggingService = loggingService;
    }

    @Path(value="/retry")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response attemptToEnableUser(@Context HttpServletRequest request) {
        boolean message = false;
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        try {
            CurrentUser currentUser = this.helperService.enableUserFromGroup(user, request);
            message = currentUser != null;
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
        return Response.ok((Object)("{\"warningMessage\":\"" + message + "\"}")).build();
    }

    @Path(value="/check")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response checkCanGetFreeSlots(@QueryParam(value="username") String username) {
        try {
            Quota retVal = this.helperService.checkCanGetFreeSlots(username);
            return Response.ok((Object)retVal).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.ok((Object)Quota.Empty).build();
        }
    }

    @Path(value="/log")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response switchLoggedLevel(@QueryParam(value="level") int level) {
        try {
            String retVal = level > 0 ? "DEBUG" : "INFO";
            LOG.info("setLoggerLevel = " + retVal);
            String retVal2 = (String)this.securityService.withPermission(Permission.SYS_ADMIN, "Accxia").call(() -> {
                this.loggingService.setLevel("de.accxia.apps.bitbucket.ium", retVal);
                return retVal;
            });
            return Response.ok((Object)retVal2).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.ok((Object)Quota.Empty).build();
        }
    }

    private static org.apache.log4j.Logger getLogger(String loggerName) {
        return "root".equals(loggerName) ? org.apache.log4j.Logger.getRootLogger() : org.apache.log4j.Logger.getLogger((String)loggerName);
    }
}

