/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.servlet;

import com.atlassian.bitbucket.user.UserService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import de.accxia.apps.bitbucket.ium.servlet.filter.UserSessionTracker;
import de.accxia.apps.bitbucket.ium.util.IUMHelperService;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class TestServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(TestServlet.class);
    private static final long serialVersionUID = 1L;
    private String IUMGroup = null;
    private String IUMGroupDIS = null;
    private String duration = null;
    private String queueSize = null;
    private String sideLicense = null;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserService userService;
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private final LoginUriProvider loginUriProvider;
    @ComponentImport
    private final WebSudoManager webSudoManager;
    private final IUMHelperService helperService;
    private final UserSessionTracker userSessionTracker;

    @Inject
    public TestServlet(UserManager userManager, TemplateRenderer renderer, LoginUriProvider loginUriProvider, UserService userService, WebSudoManager webSudoManager, IUMHelperService helperService, UserSessionTracker userSessionTracker) {
        this.userManager = Objects.requireNonNull(userManager);
        this.renderer = Objects.requireNonNull(renderer);
        this.loginUriProvider = Objects.requireNonNull(loginUriProvider);
        this.userService = userService;
        this.webSudoManager = webSudoManager;
        this.helperService = helperService;
        this.userSessionTracker = userSessionTracker;
    }

    public void renderTS(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String retVal = new Date().toLocaleString();
        res.setHeader("Content-Type", "text/plain");
        res.getWriter().write(retVal);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String param = req.getParameter("param");
        if (param == null) {
            this.renderTS(req, res);
            return;
        }
        if (param.equalsIgnoreCase("session")) {
            this.doShowSessions(req, res);
            return;
        }
        if (param.equalsIgnoreCase("user")) {
            this.doShowUsers(req, res);
            return;
        }
        String retVal = new Date().toLocaleString();
        res.setHeader("Content-Type", "text/plain");
        res.getWriter().write(retVal);
    }

    protected void doShowSessions(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String pattern = "MM-dd-yyyy HH:mm:ss";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        try {
            this.webSudoManager.willExecuteWebSudoRequest(req);
            String retVal = this.userSessionTracker.getSnapshot().stream().map(navUserDTO -> "NavUserDTO{ID=" + navUserDTO.getID() + ", requestCount=" + navUserDTO.getRequestCount() + ", userName='" + navUserDTO.getUserName() + "', lastAccessTime=" + navUserDTO.getLastAccessTime() + ", lastViewTime=" + navUserDTO.getLastViewTime() + ", lastViewTime=" + navUserDTO.getSavedTime() + ", creationTime=" + navUserDTO.getCreationTime() + "'}").collect(Collectors.joining("\n"));
            res.setHeader("Content-Type", "text/plain");
            res.getWriter().write(retVal);
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(req, res);
        }
    }

    protected void doShowUsers(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            this.webSudoManager.willExecuteWebSudoRequest(req);
            UserProfile user = this.userManager.getRemoteUser(req);
            if (user == null || !this.userManager.isAdmin(user.getUserKey())) {
                throw new WebSudoSessionException();
            }
            String testUsers = this.helperService.getUserListFromGroup("stash-users");
            res.setHeader("Content-Type", "text/plain");
            res.getWriter().write(testUsers);
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(req, res);
        }
    }
}

