/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.servlet.filter;

import com.atlassian.bitbucket.auth.Authentication;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionCheck;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.permission.PermissionVote;
import com.atlassian.bitbucket.permission.PermissionVoter;
import com.atlassian.bitbucket.permission.PermissionVoterProvider;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import de.accxia.apps.bitbucket.ium.util.IUMHelperService;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BitbucketComponent(value="permissionVoterProviderIUM")
public class PermissionVoterProviderIUM
implements PermissionVoterProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PermissionVoterProviderIUM.class);
    @ComponentImport
    private final AuthenticationContext authenticationContext;
    @ComponentImport
    private final PermissionService permissionService;
    private final IUMHelperService helperService;

    public PermissionVoterProviderIUM(AuthenticationContext authenticationContext, PermissionService permissionService, IUMHelperService helperService) {
        this.authenticationContext = authenticationContext;
        this.permissionService = permissionService;
        this.helperService = helperService;
    }

    @Nullable
    public PermissionVoter create(@Nonnull Authentication authentication) {
        final Optional applicationUser = authentication.getUser();
        return new PermissionVoter(){

            @Nonnull
            public PermissionVote vote(@Nonnull PermissionCheck permissionCheck) {
                block8: {
                    if (applicationUser.isPresent() && ((ApplicationUser)applicationUser.get()).isActive() && PermissionVoterProviderIUM.this.helperService.isUserInDisabledGroups((ApplicationUser)applicationUser.get())) {
                        try {
                            if (permissionCheck == null || permissionCheck.getPermission() != Permission.LICENSED_USER && permissionCheck.getPermission() != Permission.REPO_READ || permissionCheck.getResult() == PermissionVote.GRANT || PermissionVoterProviderIUM.this.authenticationContext.isAuthenticated() && PermissionVoterProviderIUM.this.helperService.isUserInEnabledGroups((ApplicationUser)applicationUser.get()) && PermissionVoterProviderIUM.this.helperService.isUserInPullGroup((ApplicationUser)applicationUser.get())) break block8;
                            if (LOG.isDebugEnabled()) {
                                boolean isAuth = PermissionVoterProviderIUM.this.authenticationContext.isAuthenticated();
                                boolean isEnabledGroups = PermissionVoterProviderIUM.this.helperService.isUserInEnabledGroups((ApplicationUser)applicationUser.get());
                                LOG.debug("PermissionVote applicationUser=" + ((ApplicationUser)applicationUser.get()).getName() + ", PermissionVote isAuthenticated=" + (isAuth ? "TRUE" : "FALSE") + ", PermissionVote isEnabledGroups=" + (isEnabledGroups ? "TRUE" : "FALSE") + ", PermissionVote Permission=" + permissionCheck.getPermission() + ", PermissionVote Resource=" + permissionCheck.getResource() + ", PermissionVote Result=" + permissionCheck.getResult());
                            }
                            if (permissionCheck.getPermission() == Permission.REPO_READ && permissionCheck.getResource().isPresent() && permissionCheck.getResource().get() instanceof Repository) {
                                PermissionValidationService permissionValidationService = (PermissionValidationService)ComponentLocator.getComponent(PermissionValidationService.class);
                                boolean hasRepositoryPermission = false;
                                try {
                                    permissionValidationService.validateForUser(((ApplicationUser)applicationUser.get()).getId(), permissionCheck.getPermission());
                                    hasRepositoryPermission = true;
                                }
                                catch (Exception e) {
                                    hasRepositoryPermission = false;
                                }
                                return hasRepositoryPermission ? PermissionVote.GRANT : PermissionVote.ABSTAIN;
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("PermissionVote applicationUser=" + ((ApplicationUser)applicationUser.get()).getName() + "  PermissionVote Produce =" + PermissionVote.GRANT);
                            }
                            return PermissionVote.GRANT;
                        }
                        catch (Exception e) {
                            LOG.error("Exception " + e.getMessage(), (Throwable)e);
                        }
                    }
                }
                return PermissionVote.ABSTAIN;
            }
        };
    }
}

