/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.servlet.filter;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import de.accxia.apps.bitbucket.ium.config.DAO;
import de.accxia.apps.bitbucket.ium.model.NavUser;
import de.accxia.apps.bitbucket.ium.model.NavUserDTO;
import de.accxia.apps.bitbucket.ium.repository.NavUserRepository;
import de.accxia.apps.bitbucket.ium.util.IUMHelperService;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class UserSessionTracker {
    private static final Logger LOG = LoggerFactory.getLogger(UserSessionTracker.class);
    @ComponentImport
    private final AuthenticationContext authenticationContext;
    private NavUserRepository navUserRepository;
    private final ConcurrentHashMap<String, NavUserDTO> userRequestMap;
    private final IUMHelperService helperService;
    public static final long INTERVAL = 15000L;
    private static final int MINUTE = 60000;
    public static final Comparator<NavUserDTO> BY_LAST_ACCESS_TIME = new Comparator<NavUserDTO>(){

        @Override
        public int compare(NavUserDTO userKeySession1, NavUserDTO userKeySession2) {
            long lat1 = userKeySession1.getLastAccessTime().getTime();
            long lat2 = userKeySession2.getLastAccessTime().getTime();
            return Long.compare(lat1, lat2);
        }
    };

    @Inject
    public UserSessionTracker(AuthenticationContext authenticationContext, NavUserRepository navUserRepository, IUMHelperService helperService) {
        this.authenticationContext = authenticationContext;
        this.navUserRepository = navUserRepository;
        this.helperService = helperService;
        this.userRequestMap = new ConcurrentHashMap();
    }

    public void recordInteraction(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String userName = httpServletRequest.getRemoteUser();
        String requestURI = httpServletRequest.getRequestURI();
        if (userName == null || requestURI == null) {
            return;
        }
        NavUserDTO navUserDTO = this.userRequestMap.get(userName);
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (user == null) {
            return;
        }
        String iumEnableGroups = DAO.getIUMGroups();
        if (!this.helperService.isUserInGroups(user, iumEnableGroups)) {
            return;
        }
        if (this.navUserRepository == null) {
            this.navUserRepository = (NavUserRepository)ComponentLocator.getComponent(NavUserRepository.class);
        }
        if (navUserDTO == null || navUserDTO.getID() == null) {
            navUserDTO = this.buildNavUserDTO(httpServletRequest);
            this.userRequestMap.put(userName, navUserDTO);
        } else {
            navUserDTO.addRequestCount();
            navUserDTO.setLastAccessTime(new Date());
            this.userRequestMap.put(userName, navUserDTO);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CALL " + (httpServletRequest.getRemoteUser() == null ? "N/A" : httpServletRequest.getRemoteUser()) + " " + httpServletRequest.getRequestURI());
        }
        if (this.navUserRepository != null && (navUserDTO.getSavedTime() == null || System.currentTimeMillis() - navUserDTO.getSavedTime().getTime() > 30000L)) {
            Date currentDate = new Date();
            NavUser[] navUsers = this.navUserRepository.getByUserName(navUserDTO.getUserName());
            if (navUsers.length > 0) {
                NavUser refNavUser = navUsers[navUsers.length - 1];
                if (navUsers.length > 1) {
                    this.navUserRepository.deleteOldestExceptUsers(navUserDTO.getUserName(), refNavUser);
                }
                refNavUser = this.navUserRepository.update(refNavUser, navUserDTO);
                navUserDTO.setID(refNavUser.getID());
                navUserDTO.setSavedTime(currentDate);
            } else {
                NavUser navUser = this.navUserRepository.save(navUserDTO);
                navUserDTO.setID(navUser.getID());
                navUserDTO.setSavedTime(currentDate);
            }
        }
    }

    public List<NavUserDTO> getSnapshot() {
        List<NavUserDTO> userSessions = this.userRequestMap.values().stream().collect(Collectors.toList());
        Collections.sort(userSessions, Collections.reverseOrder(BY_LAST_ACCESS_TIME));
        return userSessions;
    }

    private synchronized void removeExpiredSession() {
        Iterator<Map.Entry<String, NavUserDTO>> iterator = this.userRequestMap.entrySet().iterator();
        long refTimeMillis = System.currentTimeMillis() - 1800000L;
        while (iterator.hasNext()) {
            Map.Entry<String, NavUserDTO> entry = iterator.next();
            NavUserDTO userKeySession = entry.getValue();
            if (userKeySession.getLastAccessTime().getTime() >= refTimeMillis) continue;
            iterator.remove();
        }
    }

    private NavUserDTO buildNavUserDTO(HttpServletRequest httpServletRequest) {
        NavUserDTO navUserDTO = new NavUserDTO();
        Date now = new Date();
        navUserDTO.setID(null);
        navUserDTO.setRequestCount(1L);
        navUserDTO.setUserName(httpServletRequest.getRemoteUser());
        navUserDTO.setLastAccessTime(now);
        navUserDTO.setCreationTime(now);
        return navUserDTO;
    }

    private int safeParseToInt(String time) {
        if (time == null || time.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(time);
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public void safeRemove(ApplicationUser user) {
        try {
            this.userRequestMap.remove(user.getName());
        }
        catch (Exception e) {
            LOG.error("Exception:" + e.getMessage(), (Throwable)e);
        }
    }
}

