/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.side;

import com.atlassian.bitbucket.auth.AuthenticationService;
import com.atlassian.bitbucket.permission.PermissionAdminService;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserManager;
import de.accxia.apps.bitbucket.ium.model.NavUser;
import de.accxia.apps.bitbucket.ium.model.NavUserDTO;
import de.accxia.apps.bitbucket.ium.repository.NavUserRepository;
import de.accxia.apps.bitbucket.ium.repository.PocketRepository;
import de.accxia.apps.bitbucket.ium.util.IUMHelperService;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Path(value="/test")
@Consumes(value={"text/html"})
@Produces(value={"text/plain"})
@Component
public class TestRest {
    private static final Logger LOG = LoggerFactory.getLogger(TestRest.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserService userService;
    @ComponentImport
    private final UserAdminService userAdminService;
    @ComponentImport
    private final SecurityService securityService;
    @ComponentImport
    private final PermissionService permissionService;
    @ComponentImport
    private final PermissionAdminService permissionAdminService;
    @ComponentImport
    private final AuthenticationService authenticationService;
    private final IUMHelperService helperService;
    @ComponentImport
    private final ApplicationContext applicationContext;
    private PocketRepository pocketRepository;
    private NavUserRepository navUserRepository;

    public TestRest(UserManager userManager, UserService userService, UserAdminService userAdminService, SecurityService securityService, PermissionService permissionService, PermissionAdminService permissionAdminService, ApplicationContext applicationContext, AuthenticationService authenticationService, NavUserRepository navUserRepository, PocketRepository pocketRepository, IUMHelperService helperService) {
        this.userManager = userManager;
        this.userService = userService;
        this.userAdminService = userAdminService;
        this.securityService = securityService;
        this.permissionService = permissionService;
        this.permissionAdminService = permissionAdminService;
        this.authenticationService = authenticationService;
        this.applicationContext = applicationContext;
        this.navUserRepository = navUserRepository;
        this.pocketRepository = pocketRepository;
        this.helperService = helperService;
    }

    @Path(value="/nav1")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getNavUserForGroupLtTime(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        long time = this.safeParseToInt(request.getParameter("time"));
        int offset = this.safeParseToInt(request.getParameter("offset"));
        int cnt = this.safeParseToInt(request.getParameter("cnt"));
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        Timestamp ts = new Timestamp(new Date().getTime() - time * 1000L * 60L);
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getNavUserForGroupLtTime(group, ts, offset, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s - date %s", navUser.getUserName(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s - date %s", navUser.getUserNameEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav2")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getActiveNavUserForGroupLtTime(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        long time = this.safeParseToInt(request.getParameter("time"));
        int offset = this.safeParseToInt(request.getParameter("offset"));
        int cnt = this.safeParseToInt(request.getParameter("cnt"));
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        Timestamp ts = new Timestamp(new Date().getTime() - time * 1000L * 60L);
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getNavUserForGroupLtTime(group, true, ts, offset, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s - date %s", navUser.getUserName(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s - date %s", navUser.getUserNameEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav3")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAllNavUserForGroup(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        int offset = this.safeParseToInt(request.getParameter("offset"));
        int cnt = this.safeParseToInt(request.getParameter("cnt"));
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getAllNavUserForGroup(group, offset, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s - date %s", navUser.getUserName(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s - date %s", navUser.getUserNameEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav4")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getSortedUserListFromGroup(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        int offset = this.safeParseToInt(request.getParameter("offset"));
        int cnt = this.safeParseToInt(request.getParameter("cnt"));
        String filtergroup = request.getParameter("filtergroup");
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getOldestUsers(group, offset, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s %s %s - date %s", navUser.getUserName(), navUser.getGroupNameEx(), navUser.getUserNameEx(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s %s %s - date %s", navUser.getUserNameEx(), navUser.getGroupNameEx(), navUser.getUserNameEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav5")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getSortedUserListFromGroup2(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        int offset = this.safeParseToInt(request.getParameter("offset"));
        int cnt = this.safeParseToInt(request.getParameter("cnt"));
        String filtergroup = request.getParameter("filtergroup");
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getOldestUsers(group, filtergroup, offset, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s %s %s - date %s", navUser.getUserName(), navUser.getGroupNameEx(), navUser.getUserNameEx(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s %s %s - date %s", navUser.getUserNameEx(), navUser.getGroupNameEx(), navUser.getUserNameEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav6")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response countSortedUserListFromGroup2(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        String filtergroup = request.getParameter("filtergroup");
        ArrayList retVal = new ArrayList();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        if (this.pocketRepository != null) {
            long countOldestUsers = this.pocketRepository.countOldestUsers(group, filtergroup);
            return Response.ok((Object)countOldestUsers).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing pocket").build();
    }

    @Path(value="/nav7")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getInactiveActiveNavUserForGroupLtTime(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        String group2 = request.getParameter("group2");
        long time = this.safeParseToInt(request.getParameter("time"));
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        Timestamp ts = new Timestamp(new Date().getTime() - time * 1000L * 60L);
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getNavUserForGroupLtTime(group, group2, ts, 100);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s - date %s", navUser.getUserName(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s - date %s", navUser.getUserNameEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav8")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getCountOfNavUserForGroup(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        long time = this.safeParseToInt(request.getParameter("time"));
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        Timestamp ts = new Timestamp(new Date().getTime() - time * 1000L * 60L);
        if (this.pocketRepository != null) {
            long count = this.pocketRepository.getCountOfNavUserForGroup(group);
            retVal.add(String.format("Group %s - count of NavUser  %d", group, count));
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav9")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getCountOfUsersForGroup(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository != null) {
            long count = this.pocketRepository.getCountOfUsersForGroup(group);
            retVal.add(String.format("Group %s - count  %d", group, count));
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/timeview")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAllNavUserForGroupX(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        ArrayList<String> retVal = new ArrayList<String>();
        Timestamp ts = new Timestamp(new Date().getTime() - 300000L);
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getNavUserForGroupLtTime(group, ts, 0, 20);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s - date %s", navUser.getUserName(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s - date %s", navUser.getUserNameEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/view")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getOldestNavUserForGroup(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getOldestUsers(group, 0, 20);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s - date %s", navUser.getUserName(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s - date %s", navUser.getUserNameEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Deprecated
    @Path(value="/action2")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getActionIUMEnableUsers(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        ArrayList<String> retVal = new ArrayList<String>();
        Page users = this.userService.findUsersByGroup(group, (PageRequest)new PageRequestImpl(0, 1000));
        String[] userNames = (String[])users.stream().map(user -> user.getName()).toArray(String[]::new);
        NavUserRepository navUserRepository = (NavUserRepository)this.applicationContext.getBean(NavUserRepository.class);
        if (navUserRepository != null) {
            NavUser[] navUsers;
            for (NavUser navUser : navUsers = navUserRepository.getOldestUsers(userNames, 10)) {
                retVal.add(String.format("User %s - date %s", navUser.getUserName(), SDF.format(navUser.getLastAccessTime())));
            }
        }
        return Response.ok(retVal).build();
    }

    private int safeParseToInt(String time) {
        if (time == null || time.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(time);
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return 0;
        }
    }
}

