/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.job;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.crowd.exception.PermissionException;
import de.accxia.apps.bitbucket.ium.job.IJob;
import de.accxia.apps.bitbucket.ium.job.JobData;
import de.accxia.apps.bitbucket.ium.job.ProcessResult;
import de.accxia.apps.bitbucket.ium.model.NavUserDTO;
import de.accxia.apps.bitbucket.ium.repository.JobResultRepository;
import de.accxia.apps.bitbucket.ium.repository.PocketRepository;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMClusterJob
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMClusterJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static IUMClusterJob instance;
    private PocketRepository pocketRepository;
    private JobResultRepository jobResultRepository;
    private UserAdminService userAdminService;
    private SecurityService securityService;

    private IUMClusterJob() {
    }

    public static IUMClusterJob getInstance() {
        if (instance == null) {
            instance = new IUMClusterJob();
        }
        return instance;
    }

    @Override
    public void injectService(PocketRepository pocketRepository, JobResultRepository jobResultRepository, SecurityService securityService, UserAdminService userAdminService) {
        IUMClusterJob.instance.pocketRepository = pocketRepository;
        IUMClusterJob.instance.jobResultRepository = jobResultRepository;
        IUMClusterJob.instance.securityService = securityService;
        IUMClusterJob.instance.userAdminService = userAdminService;
    }

    @Override
    public List<ProcessResult> doProcessingJob(Map<String, Serializable> parameters) throws PermissionException {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMSyncJob Process #[" + SDF.format(new Date()) + "] ");
        }
        ArrayList<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        long inactivityInterval = (Long)parameters.get("inactivity_interval");
        if (inactivityInterval <= 0L) {
            inactivityInterval = JobData.DEFAULT_USER_INACTIVITY_INTERVAL;
        }
        String enableGroups = (String)((Object)parameters.get("enable_groups"));
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMClusterJob Process with groups={} interval={} at [ {} ] ", new Object[]{enableGroups, inactivityInterval, SDF.format(new Date())});
        }
        ProcessResult processResult = new ProcessResult("CleanJob", (String)((Object)parameters.get("enable_groups")), (String)((Object)parameters.get("disable_groups")));
        if (this.pocketRepository != null) {
            String[] arrayEnableGroups = IUMClusterJob.isEmpty(enableGroups) ? null : enableGroups.split(",");
            Timestamp ts = new Timestamp(new Date().getTime() - inactivityInterval);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("IUMClusterJob Process with groups={} interval={} at [ {} ] ", new Object[]{enableGroups, inactivityInterval, SDF.format(new Date())});
            }
            HashMap<String, List<NavUserDTO>> usersEnabled = new HashMap<String, List<NavUserDTO>>();
            long now = new Date().getTime();
            if (arrayEnableGroups != null) {
                for (String group : arrayEnableGroups) {
                    long count = this.pocketRepository.getCountOfUsersForGroup(group);
                    int cnt = 100;
                    int i = 0;
                    while ((long)i < count) {
                        List<NavUserDTO> oldestUsers = this.pocketRepository.getNavUserForGroupLtTime(group, ts, i, cnt);
                        for (NavUserDTO oldestUser : oldestUsers) {
                            this.doAddUserActive(oldestUser, group, usersEnabled);
                        }
                        i += cnt;
                    }
                }
                processResult.setUserRemoved(0L);
                this.securityService.withPermission(Permission.ADMIN, "Accxia").call(() -> {
                    for (Map.Entry userEnabled : usersEnabled.entrySet()) {
                        if (((List)userEnabled.getValue()).size() <= 0) continue;
                        for (NavUserDTO navUser : (List)userEnabled.getValue()) {
                            if (navUser.getGroupNameEx() == null) continue;
                            try {
                                this.userAdminService.removeUserFromGroup(navUser.getGroupNameEx(), (String)userEnabled.getKey());
                                processResult.setUserRemoved(processResult.getUserRemoved() + 1L);
                                if (!this.LOG.isInfoEnabled()) continue;
                                this.LOG.info("IUMClusterJob removed user {} from group {} ", new Object[]{userEnabled.getKey(), navUser.getGroupNameEx()});
                            }
                            catch (Exception e) {
                                this.LOG.error("Exception[removeUserFromGroup]: " + e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    return 0;
                });
            }
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMClusterJob Processed #[" + SDF.format(new Date()) + "] ");
        }
        processResultList.add(processResult);
        return processResultList;
    }

    private static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    private void doAddUserActive(NavUserDTO navUser, String group, Map<String, List<NavUserDTO>> usersEnabled) {
        String userName;
        String string = userName = navUser.getUserName() == null ? navUser.getUserNameEx() : navUser.getUserName();
        if (userName != null) {
            if (navUser.getGroupNameEx() == null) {
                navUser.setGroupNameEx(group);
            }
            if (!usersEnabled.containsKey(userName)) {
                usersEnabled.put(userName, new ArrayList());
            }
            List<NavUserDTO> userActiveList = usersEnabled.get(userName);
            userActiveList.add(navUser);
        }
    }
}

