/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.job;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.crowd.exception.PermissionException;
import com.google.common.collect.Sets;
import de.accxia.apps.bitbucket.ium.config.DAO;
import de.accxia.apps.bitbucket.ium.job.IJob;
import de.accxia.apps.bitbucket.ium.job.ProcessResult;
import de.accxia.apps.bitbucket.ium.repository.JobResultRepository;
import de.accxia.apps.bitbucket.ium.repository.PocketRepository;
import java.io.Serializable;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMDailyJob
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMDailyJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static IUMDailyJob instance;
    private PermissionService permissionService;
    private PocketRepository pocketRepository;
    private JobResultRepository jobResultRepository;
    private SecurityService securityService;
    private UserAdminService userAdminService;
    int syncUsers = 0;

    private IUMDailyJob() {
    }

    public static IUMDailyJob getInstance() {
        if (instance == null) {
            instance = new IUMDailyJob();
        }
        return instance;
    }

    @Override
    public void injectService(PocketRepository pocketRepository, JobResultRepository jobResultRepository, SecurityService securityService, UserAdminService userAdminService) {
        IUMDailyJob.instance.pocketRepository = pocketRepository;
        IUMDailyJob.instance.jobResultRepository = jobResultRepository;
        IUMDailyJob.instance.securityService = securityService;
        IUMDailyJob.instance.userAdminService = userAdminService;
    }

    @Override
    public void injectService(PermissionService permissionService) {
        IUMDailyJob.instance.permissionService = permissionService;
    }

    @Override
    public List<ProcessResult> doProcessingJob(Map<String, Serializable> parameters) throws PermissionException {
        long timestamp = System.currentTimeMillis();
        if (this.LOG.isInfoEnabled()) {
            this.LOG.info("IUMDailyJob start process #[" + SDF.format(new Date()) + "] ");
        }
        ArrayList<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        String sourceGroups = DAO.getIUMGroups();
        String targetGroup = DAO.getIUMGroupsDisabled();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMDailyJob Sync groups = {} -> {}  at [ {} ] ", new Object[]{sourceGroups, targetGroup, SDF.format(new Date())});
        }
        if (this.pocketRepository != null && this.jobResultRepository != null && !StringUtils.isEmpty((CharSequence)sourceGroups) && !StringUtils.isEmpty((CharSequence)targetGroup)) {
            String[] arraySourceGroups = sourceGroups.split(",");
            String[] arrayTargetGroups = targetGroup.split(",");
            Set<String> groupsWithBBAccess = this.getGroupsWithBBAccessExceptIUM();
            this.syncUsers = 0;
            for (int i = 0; i < arraySourceGroups.length; ++i) {
                if (arrayTargetGroups.length <= i || IUMDailyJob.isEmpty(arraySourceGroups[i]) || IUMDailyJob.isEmpty(arrayTargetGroups[i])) continue;
                ProcessResult processResult = this.processPair(arraySourceGroups[i], arrayTargetGroups[i], groupsWithBBAccess);
                processResultList.add(processResult);
                try {
                    TimeUnit.MILLISECONDS.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    this.LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                }
            }
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("IUMDailyJob copied #" + this.syncUsers + " to group " + targetGroup);
            }
        }
        if (this.LOG.isInfoEnabled()) {
            this.LOG.info("IUMDailyJob end process #[" + SDF.format(new Date()) + "]  time spent (sec) = " + String.valueOf((System.currentTimeMillis() - timestamp) / 1000L));
        }
        return processResultList;
    }

    private ProcessResult processPair(String sourceGroup, String targetGroup, Set<String> groupsWithBBAccess) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMDailyJob Sync groups = {} -> {}  at [ {} ] ", new Object[]{sourceGroup, targetGroup, SDF.format(new Date())});
        }
        ProcessResult processResult = new ProcessResult("DailyJob", sourceGroup, targetGroup);
        if (sourceGroup != null && targetGroup != null) {
            int cnt1 = 0;
            int cnt2 = 0;
            for (String groupWithBBAccess : groupsWithBBAccess) {
                List<String> targetUsers;
                List<String> sourceUsers;
                try {
                    sourceUsers = this.pocketRepository.getNavUserFor2Groups(sourceGroup, groupWithBBAccess);
                    targetUsers = this.pocketRepository.getNavUserFor2Groups(targetGroup, groupWithBBAccess);
                }
                catch (Exception ex) {
                    this.LOG.error("Exception=" + ex.getMessage(), (Throwable)ex);
                    return processResult;
                }
                processResult.setUserCopied(cnt1 += this.removeUserToGroup(sourceUsers, sourceGroup));
                processResult.setUserRemoved(cnt2 += this.removeUserToGroup(targetUsers, targetGroup));
            }
        } else {
            this.LOG.info("IUMDailyJob skipped Empty Source/Target config");
        }
        return processResult;
    }

    public Set<String> getGroupsWithBBAccessExceptIUM() {
        String[] groupsName;
        HashSet users = new HashSet();
        HashSet<String> enableGroups = new HashSet<String>();
        int start = 0;
        int limit = 100;
        for (String group : groupsName = DAO.getIUMGroups().split(",")) {
            enableGroups.add(group);
        }
        ArrayList groups = new ArrayList();
        try {
            PageRequestImpl page = new PageRequestImpl(start, limit);
            Page pageGroups = this.permissionService.getGrantedGroups(Permission.LICENSED_USER, (PageRequest)page);
            Set<String> groupsWithPermissions = pageGroups.stream().filter(grp -> !enableGroups.contains(grp)).collect(Collectors.toSet());
            return groupsWithPermissions;
        }
        catch (Exception e) {
            this.LOG.error("Exception= " + e.getMessage(), (Throwable)e);
            return Collections.emptySet();
        }
    }

    private int removeUserToGroup(List<String> sourceUsers, String targetGroup) {
        this.securityService.withPermission(Permission.ADMIN, "Accxia").call(() -> {
            int cnt = 0;
            for (String sourceUser : sourceUsers) {
                if (sourceUser == null) continue;
                try {
                    this.userAdminService.removeUserFromGroup(targetGroup, sourceUser);
                    ++cnt;
                }
                catch (Exception e) {
                    this.LOG.error("Exception[removeUserFromGroup]: " + e.getMessage(), (Throwable)e);
                }
            }
            return cnt;
        });
        return sourceUsers.size();
    }

    private void addUserToGroup(Sets.SetView<DetailedUser> sourceUsers, String targetGroup) {
        this.securityService.withPermission(Permission.ADMIN, "Accxia").call(() -> {
            Set users = sourceUsers.stream().map(Principal::getName).collect(Collectors.toSet());
            try {
                this.userAdminService.addMembersToGroup(targetGroup, users);
            }
            catch (Exception e) {
                this.LOG.error("Exception[removeUserFromGroup]: " + e.getMessage(), (Throwable)e);
            }
            return 0;
        });
    }

    private List<DetailedUser> getUsersFromGroup(String group) {
        Page users;
        ArrayList<DetailedUser> res = new ArrayList<DetailedUser>();
        PageRequestImpl pagerq = new PageRequestImpl(0, 200);
        do {
            users = (Page)this.securityService.withPermission(Permission.ADMIN, "Daily hook").call(() -> this.userAdminService.findUsersWithGroup(group, "", (PageRequest)new PageRequestImpl(0, 1000)));
            Iterator iterator = users.getValues().iterator();
            while (iterator.hasNext()) {
                res.add((DetailedUser)iterator.next());
            }
        } while ((pagerq = users.getNextPageRequest()) != null);
        return res;
    }

    private static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }
}

