/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.job;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.sal.api.component.ComponentLocator;
import de.accxia.apps.bitbucket.ium.config.DAO;
import de.accxia.apps.bitbucket.ium.job.JobData;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobDataUtils {
    private static Logger LOG = LoggerFactory.getLogger(JobDataUtils.class);

    public static JobData createJobData(String startingFrom, String repeatInterval, String userInactiveInterval, String enableGroups, String disableGroups) {
        JobData jobData = new JobData();
        try {
            jobData.setStartingFrom(Integer.parseInt(startingFrom));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setStartingFrom(1);
        }
        try {
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(Long.parseLong(repeatInterval)));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(60L));
        }
        try {
            jobData.setUserInactivityInterval(TimeUnit.MINUTES.toMillis(Long.parseLong(userInactiveInterval)));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setUserInactivityInterval(JobData.DEFAULT_USER_INACTIVITY_INTERVAL);
        }
        jobData.getParameters().put("repeat_interval", Long.valueOf(jobData.getRepeatInterval()));
        jobData.getParameters().put("starting_from", Integer.valueOf(jobData.getStartingFrom()));
        jobData.getParameters().put("inactivity_interval", Long.valueOf(jobData.getUserInactivityInterval()));
        jobData.getParameters().put("enable_groups", (Serializable)((Object)enableGroups));
        jobData.getParameters().put("disable_groups", (Serializable)((Object)disableGroups));
        AuthenticationContext authenticationContext = (AuthenticationContext)ComponentLocator.getComponent(AuthenticationContext.class);
        jobData.getParameters().put("current_user", (Serializable)((Object)(authenticationContext.getCurrentUser() != null ? authenticationContext.getCurrentUser().getName() : "IUMPlugin")));
        return jobData;
    }

    public static JobData createSyncJobData(String startingFrom, String repeatInterval, String enableGroups, String disableGroups) {
        JobData jobData = new JobData();
        try {
            jobData.setStartingFrom(Integer.parseInt(startingFrom));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setStartingFrom(1);
        }
        try {
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(Long.parseLong(repeatInterval)));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(60L));
        }
        jobData.getParameters().put("sync_repeat_interval", Long.valueOf(jobData.getRepeatInterval()));
        jobData.getParameters().put("sync_starting_from", Integer.valueOf(jobData.getStartingFrom()));
        jobData.getParameters().put("source_all_groups", (Serializable)((Object)enableGroups));
        jobData.getParameters().put("target_all_group", (Serializable)((Object)disableGroups));
        AuthenticationContext authenticationContext = (AuthenticationContext)ComponentLocator.getComponent(AuthenticationContext.class);
        jobData.getParameters().put("current_user", (Serializable)((Object)(authenticationContext.getCurrentUser() != null ? authenticationContext.getCurrentUser().getName() : "IUMPlugin")));
        return jobData;
    }

    public static JobData createDailyJobData() {
        JobData jobData = new JobData();
        int startingFrom = 2;
        long repeatInterval = 1440L;
        Date date = new Date();
        startingFrom = date.getHours();
        repeatInterval = 2L;
        try {
            jobData.setStartingFrom(startingFrom);
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setStartingFrom(1);
        }
        try {
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(repeatInterval));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(60L));
        }
        AuthenticationContext authenticationContext = (AuthenticationContext)ComponentLocator.getComponent(AuthenticationContext.class);
        jobData.getParameters().put("current_user", (Serializable)((Object)(authenticationContext.getCurrentUser() != null ? authenticationContext.getCurrentUser().getName() : "IUMPlugin")));
        return jobData;
    }

    public static JobData createIUMJobData() {
        return JobDataUtils.createJobData(DAO.getStartingFrom(), DAO.getRepeatInterval(), DAO.getInactivityDuration(), DAO.getIUMGroups(), DAO.getIUMGroupsDisabled());
    }

    public static JobData createIUMSyncJobData() {
        return JobDataUtils.createSyncJobData(DAO.getSyncStartingFrom(), DAO.getSyncRepeatInterval(), DAO.getSyncAllSrcGoups(), DAO.getSyncAllTargetGoups());
    }

    public static JobData createFakeIUMJobData() {
        JobData jobData = new JobData();
        Date date = new Date();
        jobData.setStartingFrom(date.getHours());
        jobData.setRepeatInterval(10000L);
        jobData.setUserInactivityInterval(30000L);
        jobData.getParameters().put("repeat_interval", Long.valueOf(jobData.getRepeatInterval()));
        jobData.getParameters().put("starting_from", Integer.valueOf(jobData.getStartingFrom()));
        jobData.getParameters().put("inactivity_interval", Long.valueOf(jobData.getUserInactivityInterval()));
        jobData.getParameters().put("enable_groups", (Serializable)((Object)DAO.getIUMGroups()));
        jobData.getParameters().put("disable_groups", (Serializable)((Object)DAO.getIUMGroupsDisabled()));
        return jobData;
    }

    public static JobData createFakeIUMSyncJobData() {
        JobData jobData = new JobData();
        Date date = new Date();
        jobData.setStartingFrom(date.getHours());
        jobData.setRepeatInterval(10000L);
        jobData.setUserInactivityInterval(30000L);
        jobData.getParameters().put("sync_repeat_interval", Long.valueOf(jobData.getRepeatInterval()));
        jobData.getParameters().put("sync_starting_from", Integer.valueOf(jobData.getStartingFrom()));
        jobData.getParameters().put("source_all_groups", (Serializable)((Object)"SrcGroup"));
        jobData.getParameters().put("target_all_group", (Serializable)((Object)"DestGroup"));
        AuthenticationContext authenticationContext = (AuthenticationContext)ComponentLocator.getComponent(AuthenticationContext.class);
        jobData.getParameters().put("current_user", (Serializable)((Object)(authenticationContext.getCurrentUser() != null ? authenticationContext.getCurrentUser().getName() : "IUMPlugin")));
        return jobData;
    }

    public static JobData createIUMAccessJobData() {
        return JobDataUtils.createAccessJobData();
    }

    public static JobData createAccessJobData() {
        JobData jobData = new JobData();
        Date date = new Date();
        int startingFrom = date.getHours();
        long repeatInterval = 5L;
        try {
            jobData.setStartingFrom(startingFrom);
            jobData.setRepeatInterval(TimeUnit.SECONDS.toMillis(repeatInterval));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setStartingFrom(1);
        }
        AuthenticationContext authenticationContext = (AuthenticationContext)ComponentLocator.getComponent(AuthenticationContext.class);
        jobData.getParameters().put("current_user", (Serializable)((Object)(authenticationContext.getCurrentUser() != null ? authenticationContext.getCurrentUser().getName() : "IUMPlugin")));
        return jobData;
    }

    public static JobData createFakeIUMAccessJobData() {
        JobData jobData = new JobData();
        Date date = new Date();
        int startingFrom = date.getHours();
        long repeatInterval = 10L;
        try {
            jobData.setStartingFrom(startingFrom);
            jobData.setRepeatInterval(TimeUnit.SECONDS.toMillis(repeatInterval));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setStartingFrom(1);
        }
        AuthenticationContext authenticationContext = (AuthenticationContext)ComponentLocator.getComponent(AuthenticationContext.class);
        jobData.getParameters().put("current_user", (Serializable)((Object)(authenticationContext.getCurrentUser() != null ? authenticationContext.getCurrentUser().getName() : "IUMPlugin")));
        return jobData;
    }

    public static JobData createIUMDailyJobData() {
        return JobDataUtils.createDailyJobData();
    }

    public static JobData createFakeIUMDailyJobData() {
        JobData jobData = new JobData();
        Date date = new Date();
        int startingFrom = date.getHours();
        long repeatInterval = 1L;
        try {
            jobData.setStartingFrom(startingFrom);
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setStartingFrom(1);
        }
        try {
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(repeatInterval));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(60L));
        }
        AuthenticationContext authenticationContext = (AuthenticationContext)ComponentLocator.getComponent(AuthenticationContext.class);
        jobData.getParameters().put("current_user", (Serializable)((Object)(authenticationContext.getCurrentUser() != null ? authenticationContext.getCurrentUser().getName() : "IUMPlugin")));
        return jobData;
    }

    public static long hours2millis(long hours) {
        try {
            return TimeUnit.HOURS.toMillis(hours);
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public static long hours2millis(String hours) {
        try {
            return TimeUnit.HOURS.toMillis(Long.parseLong(hours));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public static long toHours(String mills) {
        if (mills != null) {
            try {
                return TimeUnit.MILLISECONDS.toHours(Long.parseLong(mills));
            }
            catch (Exception e) {
                LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            }
        }
        return 0L;
    }

    public static long minutes2millis(long minutes) {
        try {
            return TimeUnit.MINUTES.toMillis(minutes);
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public static long minutes2millis(String minutes) {
        try {
            return TimeUnit.MINUTES.toMillis(Long.parseLong(minutes));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public static long toMinutes(String mills) {
        if (mills != null) {
            try {
                return TimeUnit.MILLISECONDS.toMinutes(Long.parseLong(mills));
            }
            catch (Exception e) {
                LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            }
        }
        return 0L;
    }

    public static long toLong(String numbr) {
        if (numbr != null) {
            try {
                return Long.parseLong(numbr);
            }
            catch (Exception e) {
                LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            }
        }
        return 0L;
    }
}

