/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.job;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.status.JobDetails;
import de.accxia.apps.bitbucket.ium.config.DAO;
import de.accxia.apps.bitbucket.ium.job.IUMSyncJob;
import de.accxia.apps.bitbucket.ium.job.JobDataUtils;
import de.accxia.apps.bitbucket.ium.job.MonitorJobRunner;
import de.accxia.apps.bitbucket.ium.job.ProcessResult;
import de.accxia.apps.bitbucket.ium.model.JobResultDTO;
import de.accxia.apps.bitbucket.ium.repository.JobResultRepository;
import de.accxia.apps.bitbucket.ium.repository.PocketRepository;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/sjob")
@Consumes(value={"text/html", "application/json"})
@Produces(value={"application/json"})
@Component
public class JobSyncRestController {
    private static final Logger LOG = LoggerFactory.getLogger(JobSyncRestController.class);
    @ComponentImport
    private final AuthenticationContext authenticationContext;
    @ComponentImport
    private SecurityService securityService;
    @ComponentImport
    private UserAdminService userAdminService;
    @ComponentImport
    private PermissionService permissionService;
    private final PocketRepository pocketRepository;
    private JobResultRepository jobResultRepository;
    private final MonitorJobRunner monitorJobRunner;
    private static LocalThread localThread = null;

    @Autowired
    public JobSyncRestController(MonitorJobRunner monitorJobRunner, PocketRepository pocketRepository, JobResultRepository jobResultRepository, SecurityService securityService, PermissionService permissionService, UserAdminService userAdminService, AuthenticationContext authenticationContext) {
        this.monitorJobRunner = monitorJobRunner;
        this.pocketRepository = pocketRepository;
        this.jobResultRepository = jobResultRepository;
        this.securityService = securityService;
        this.userAdminService = userAdminService;
        this.authenticationContext = authenticationContext;
    }

    @Path(value="/config")
    @GET
    @Produces(value={"application/json"})
    public Response getCurrentConfig() {
        List<JobDetails> details;
        HashMap<Object, String> map = new HashMap<Object, String>();
        map.put("repeat_interval", DAO.getRepeatInterval());
        map.put("starting_from", DAO.getStartingFrom());
        map.put("enable_groups", DAO.getIUMGroups());
        map.put("disable_groups", DAO.getIUMGroupsDisabled());
        map.put("working", String.valueOf(this.monitorJobRunner.isWorking(IUMSyncJob.class)));
        if (this.monitorJobRunner.getJobDetails(IUMSyncJob.class) != null) {
            map.put("jobDetails", this.convert2String(this.monitorJobRunner.getJobDetails(IUMSyncJob.class)));
        }
        if ((details = this.monitorJobRunner.getJobsByJobRunnerKey(IUMSyncJob.class)) != null) {
            for (int i = 0; i < details.size(); ++i) {
                map.put("jobDetails" + i, details.get(i).toString());
            }
        }
        if (this.monitorJobRunner.isWorking(IUMSyncJob.class)) {
            map.put("lastRunForJob", this.convert2String(this.monitorJobRunner.getLastRunForJob(IUMSyncJob.class)));
            map.put("lastSuccessfulRunForJob", this.convert2String(this.monitorJobRunner.getLastSuccessfulRunForJob(IUMSyncJob.class)));
            map.put("nextRunDate", this.convert2String(this.monitorJobRunner.getNextRunDate(IUMSyncJob.class)));
        }
        return Response.ok(map).build();
    }

    @Path(value="/config")
    @POST
    @Produces(value={"application/json"})
    public Response setCurrentConfig(@QueryParam(value="repeat_interval") String repeatinterval, @QueryParam(value="starting_from") String startingFrom) {
        DAO.updateRepeatInterval(repeatinterval);
        DAO.updateStartingFrom(startingFrom);
        return this.getCurrentConfig();
    }

    @Path(value="/start")
    @GET
    @Produces(value={"application/json"})
    public Response startDebugJob() {
        try {
            this.monitorJobRunner.doUnSchedule(IUMSyncJob.class);
            IUMSyncJob.getInstance().injectService(this.pocketRepository, this.jobResultRepository, this.securityService, this.userAdminService);
            IUMSyncJob.getInstance().injectService(this.permissionService);
            String jobKey = this.monitorJobRunner.doSchedule(JobDataUtils.createFakeIUMSyncJobData(), IUMSyncJob.getInstance());
            if (LOG.isDebugEnabled()) {
                LOG.debug("jobKey= " + jobKey);
            }
            return Response.ok((Object)"success").build();
        }
        catch (SchedulerServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/stop")
    @GET
    @Produces(value={"application/json"})
    public Response stopDebugJob() {
        try {
            this.monitorJobRunner.doUnSchedule(IUMSyncJob.class);
            return Response.ok((Object)"success").build();
        }
        catch (SchedulerServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/runnow")
    @GET
    @Produces(value={"application/json"})
    public Response runNowsJob() {
        if (localThread != null && JobSyncRestController.localThread.isWorking) {
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        try {
            long duration = Long.parseLong(DAO.getInactivityDuration()) * 60L * 1000L;
            HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
            parameters.put("source_all_groups", (Serializable)((Object)DAO.getSyncAllSrcGoups()));
            parameters.put("target_all_group", (Serializable)((Object)DAO.getSyncAllTargetGoups()));
            parameters.put("inactivity_interval", Long.valueOf(duration));
            ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
            parameters.put("current_user", (Serializable)((Object)(currentUser != null ? currentUser.getName() : "IUMPlugin")));
            IUMSyncJob.getInstance().injectService(this.pocketRepository, this.jobResultRepository, this.securityService, this.userAdminService);
            IUMSyncJob.getInstance().injectService(this.permissionService);
            localThread = new LocalThread(currentUser, parameters);
            localThread.start();
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        catch (Exception e) {
            String response = "{\"message\":\"" + e.getMessage() + "\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
    }

    @Path(value="/jobcheck")
    @GET
    @Produces(value={"application/json"})
    public Response runNowsCheckJob() {
        if (localThread == null) {
            String response = "{\"message\":\"not stating\"}";
            return Response.ok((Object)response).build();
        }
        if (JobSyncRestController.localThread.isWorking) {
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        try {
            if (JobSyncRestController.localThread.errorMessage != null) {
                String response = "{\"message\":\"" + JobSyncRestController.localThread.errorMessage + "\"}";
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
            }
            return Response.ok(JobSyncRestController.localThread.processResultList).build();
        }
        catch (Exception e) {
            String response = "{\"message\":\"" + e.getMessage() + "\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
    }

    private void doSaveProcessResultList(List<ProcessResult> processResultList, Map<String, Serializable> parameters, long elapsedTime) {
        String currentUser = (String)((Object)parameters.get("current_user"));
        for (ProcessResult processResult : processResultList) {
            this.jobResultRepository.save(JobResultDTO.createJobResult(processResult, currentUser, elapsedTime));
        }
    }

    private <T> String convert2String(T t2) {
        return t2 != null ? t2.toString() : "";
    }

    class LocalThread
    extends Thread {
        Map<String, Serializable> parameters;
        ApplicationUser currentUser;
        List<ProcessResult> processResultList = null;
        long elapsedTime;
        String errorMessage;
        boolean isWorking;

        public LocalThread(ApplicationUser currentUser, Map<String, Serializable> parameters) {
            this.parameters = parameters;
            this.currentUser = currentUser;
            this.isWorking = false;
            this.errorMessage = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long startTime = System.currentTimeMillis();
                JobSyncRestController.localThread.isWorking = true;
                IUMSyncJob.getInstance().injectService(JobSyncRestController.this.pocketRepository, JobSyncRestController.this.jobResultRepository, JobSyncRestController.this.securityService, JobSyncRestController.this.userAdminService);
                IUMSyncJob.getInstance().injectService(JobSyncRestController.this.permissionService);
                List<ProcessResult> processResultList = IUMSyncJob.getInstance().doProcessingJob(this.parameters);
                long stopTime = System.currentTimeMillis();
                this.elapsedTime = stopTime - startTime;
                JobSyncRestController.localThread.processResultList = processResultList;
                JobSyncRestController.this.doSaveProcessResultList(processResultList, this.parameters, this.elapsedTime);
            }
            catch (Exception e) {
                LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                try {
                    JobSyncRestController.localThread.errorMessage = e.getMessage();
                }
                catch (Exception ex) {
                    LOG.error("Exception: " + ex.getMessage(), (Throwable)ex);
                    throw new RuntimeException(ex);
                }
            }
            finally {
                JobSyncRestController.localThread.isWorking = false;
            }
        }
    }
}

