/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.job;

import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.crowd.exception.PermissionException;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerHistoryService;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.scheduler.status.RunDetails;
import de.accxia.apps.bitbucket.ium.job.IJob;
import de.accxia.apps.bitbucket.ium.job.JobData;
import de.accxia.apps.bitbucket.ium.job.MonitorJobRunner;
import de.accxia.apps.bitbucket.ium.job.ProcessResult;
import de.accxia.apps.bitbucket.ium.job.access.AccxiaAccessMap;
import de.accxia.apps.bitbucket.ium.model.JobResultDTO;
import de.accxia.apps.bitbucket.ium.repository.JobResultRepository;
import de.accxia.apps.bitbucket.ium.repository.NavUserRepository;
import de.accxia.apps.bitbucket.ium.repository.PocketRepository;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ExportAsService(value={MonitorJobRunnerImpl.class})
@Named(value="monitorJobRunner")
public class MonitorJobRunnerImpl
implements MonitorJobRunner {
    private Logger LOG = LoggerFactory.getLogger(MonitorJobRunnerImpl.class);
    public static final String JOB_ID = "JOB_ID";
    private final ConcurrentHashMap<JobId, JobRunnerKeyDetail> map;
    @ComponentImport
    private final SchedulerService scheduler;
    @ComponentImport
    private final SchedulerHistoryService schedulerHistoryService;
    @ComponentImport
    private final SecurityService securityService;
    @ComponentImport
    private UserAdminService userAdminService;
    @ComponentImport
    private PermissionService permissionService;
    private PocketRepository pocketRepository;
    private JobResultRepository jobResultRepository;
    private NavUserRepository navUserRepository;
    private AccxiaAccessMap accxiaAccessMap;

    @Autowired
    public MonitorJobRunnerImpl(SchedulerService scheduler, SchedulerHistoryService schedulerHistoryService, SecurityService securityService, PermissionService permissionService, NavUserRepository navUserRepository, PocketRepository pocketRepository, AccxiaAccessMap accxiaAccessMap, JobResultRepository jobResultRepository, UserAdminService userAdminService) {
        this.scheduler = scheduler;
        this.schedulerHistoryService = schedulerHistoryService;
        this.securityService = securityService;
        this.permissionService = permissionService;
        this.accxiaAccessMap = accxiaAccessMap;
        this.map = new ConcurrentHashMap();
        this.navUserRepository = navUserRepository;
        this.pocketRepository = pocketRepository;
        this.jobResultRepository = jobResultRepository;
        this.userAdminService = userAdminService;
    }

    @Override
    public String doSchedule(JobData jobData, final IJob job) throws SchedulerServiceException {
        JobId jobId = JobId.of((String)job.getClass().getName());
        JobRunnerKeyDetail jobRunnerKeyDetail = this.getOrCreateJob(jobId);
        job.injectService(this.pocketRepository, this.jobResultRepository, this.securityService, this.userAdminService);
        job.injectService(this.permissionService);
        job.injectService(this.accxiaAccessMap);
        this.scheduler.registerJobRunner(jobRunnerKeyDetail.jobRunnerKey, new JobRunner(){

            @Nullable
            public JobRunnerResponse runJob(JobRunnerRequest jobRequest) {
                try {
                    if (MonitorJobRunnerImpl.this.LOG.isInfoEnabled()) {
                        MonitorJobRunnerImpl.this.LOG.info("Begin ProcessingJob at " + new Date());
                    }
                    MonitorJobRunnerImpl.this.doProcessingJob(job, jobRequest.getJobConfig().getParameters());
                    if (MonitorJobRunnerImpl.this.LOG.isInfoEnabled()) {
                        MonitorJobRunnerImpl.this.LOG.info("End ProcessingJob at " + new Date());
                    }
                }
                catch (Exception e) {
                    MonitorJobRunnerImpl.this.LOG.error("Exception ProcessingJob: " + e.getMessage(), (Throwable)e);
                    return JobRunnerResponse.aborted((String)("Task aborted due to the following error : " + e.getMessage()));
                }
                return JobRunnerResponse.success();
            }
        });
        jobData.getParameters().put(JOB_ID, (Serializable)((Object)jobId.toString()));
        jobRunnerKeyDetail.nextRunDate = this.createFirstRunDate(jobData.getRepeatInterval(), jobData.getStartingFrom());
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKeyDetail.jobRunnerKey).withRunMode(RunMode.RUN_LOCALLY).withParameters(jobData.getParameters()).withSchedule(Schedule.forInterval((long)jobData.getRepeatInterval(), (Date)jobRunnerKeyDetail.nextRunDate));
        try {
            this.scheduler.scheduleJob(jobId, jobConfig);
            this.LOG.info("Job schedule with id =" + jobId.toString());
            return jobRunnerKeyDetail.jobRunnerKey.toString();
        }
        catch (Exception e) {
            this.LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new SchedulerServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void doUnSchedule(Class classz) throws SchedulerServiceException {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
            this.LOG.info("Stopping..." + jobRunnerKeyDetail.jobRunnerKey);
            this.scheduler.unscheduleJob(jobId);
            this.getOrCreateJob((JobId)jobId).nextRunDate = null;
        }
    }

    @Override
    public JobDetails getJobDetails(Class classz) {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            return this.scheduler.getJobDetails(jobId);
        }
        return null;
    }

    @Override
    public Date getNextRunDate(Class classz) {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
            return jobRunnerKeyDetail.nextRunDate;
        }
        return null;
    }

    @Override
    public RunDetails getLastRunForJob(Class classz) {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            return this.schedulerHistoryService.getLastRunForJob(jobId);
        }
        return null;
    }

    @Override
    public RunDetails getLastSuccessfulRunForJob(Class classz) {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            return this.schedulerHistoryService.getLastSuccessfulRunForJob(jobId);
        }
        return null;
    }

    @Override
    public boolean isWorking(Class classz) {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
            return jobRunnerKeyDetail.nextRunDate != null;
        }
        return false;
    }

    @Override
    public List<JobDetails> getJobsByJobRunnerKey(Class classz) {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
            return this.scheduler.getJobsByJobRunnerKey(jobRunnerKeyDetail.jobRunnerKey);
        }
        return Collections.EMPTY_LIST;
    }

    private void doProcessingJob(IJob job, Map<String, Serializable> parameters) throws PermissionException {
        if (job != null) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("ProcessingJob parameters ");
                for (Map.Entry<String, Serializable> parameter : parameters.entrySet()) {
                    this.LOG.debug("key: " + parameter.getKey() + " = " + parameter.getValue());
                }
            }
            long startTime = System.currentTimeMillis();
            String className = (String)((Object)parameters.get(JOB_ID));
            JobId jobId = JobId.of((String)className);
            List<ProcessResult> processResultList = job.doProcessingJob(parameters);
            long stopTime = System.currentTimeMillis();
            long elapsedTime = stopTime - startTime;
            this.doSaveProcessResultList(processResultList, parameters, elapsedTime);
            Schedule schedule = this.scheduler.getJobDetails(jobId).getSchedule();
            if (schedule != null) {
                long timeInSecs = System.currentTimeMillis();
                Date nextRunDate = new Date(timeInSecs + schedule.getIntervalScheduleInfo().getIntervalInMillis());
                this.LOG.info("nextRunDate= " + nextRunDate);
                this.getOrCreateJob((JobId)jobId).nextRunDate = nextRunDate;
            }
        } else {
            this.LOG.info("ProcessingJob NO JOB");
        }
    }

    private void doSaveProcessResultList(List<ProcessResult> processResultList, Map<String, Serializable> parameters, long elapsedTime) {
        String currentUser = (String)((Object)parameters.get("current_user"));
        for (ProcessResult processResult : processResultList) {
            this.jobResultRepository.save(JobResultDTO.createJobResult(processResult, currentUser, elapsedTime));
        }
    }

    private String createPlainMessage(List<ProcessResult> processResultList, long elapsedTime) {
        StringBuffer sb = new StringBuffer();
        sb.append("Status:Done").append("\n");
        for (ProcessResult processResult : processResultList) {
            sb.append(String.format("Copy From %s to %s #%d", processResult.getSourceGroups(), processResult.getTargetGroup(), processResult.getUserCopied())).append("\n");
            sb.append(String.format("Remove From %s #%d", processResult.getTargetGroup(), processResult.getUserCopied())).append("\n");
        }
        sb.append(String.format("Duration %5.1f", (double)elapsedTime / 60.0 / 1000.0)).append(" minutes");
        return sb.toString();
    }

    private boolean isRunning(JobId jobId) {
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
            return jobRunnerKeyDetail.nextRunDate != null;
        }
        return false;
    }

    private boolean stopRunning(JobId jobId) {
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
            jobRunnerKeyDetail.nextRunDate = null;
            return true;
        }
        return false;
    }

    private JobRunnerKeyDetail getOrCreateJob(String className) {
        JobId jobId = JobId.of((String)className);
        if (!this.map.containsKey(jobId) || this.map.get(jobId) == null) {
            this.map.put(jobId, new JobRunnerKeyDetail(className));
        }
        JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
        return jobRunnerKeyDetail;
    }

    private JobRunnerKeyDetail getOrCreateJob(JobId jobId) {
        if (!this.map.containsKey(jobId) || this.map.get(jobId) == null) {
            this.map.put(jobId, new JobRunnerKeyDetail(jobId.toString()));
        }
        JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
        return jobRunnerKeyDetail;
    }

    private Date createFirstRunDate(long repeatInterval, int hour) {
        Random random = new Random();
        int randomNum = (random.nextInt(3) + 3) * 1000;
        if (repeatInterval <= 300000L) {
            long currentTimeMillis = System.currentTimeMillis();
            return new Date(currentTimeMillis + (long)randomNum);
        }
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(11) >= hour) {
            calendar.set(5, calendar.get(5) + 1);
        }
        calendar.set(11, hour);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long calendarTimeMillis = calendar.getTime().getTime();
        return new Date(calendarTimeMillis + (long)randomNum);
    }

    class JobRunnerKeyDetail {
        public JobRunnerKey jobRunnerKey;
        public Date nextRunDate = null;

        public JobRunnerKeyDetail(JobRunnerKey jobRunnerKey, Date nextRunDate) {
            this.jobRunnerKey = jobRunnerKey;
            this.nextRunDate = nextRunDate;
        }

        public JobRunnerKeyDetail(JobRunnerKey jobRunnerKey) {
            this(jobRunnerKey, null);
        }

        public JobRunnerKeyDetail(String className) {
            this.jobRunnerKey = JobRunnerKey.of((String)className);
            this.nextRunDate = null;
        }
    }
}

