/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.listener;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.log.LoggingService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.topic.MessageEvent;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicListener;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginDisablingEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.apps.bitbucket.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.bitbucket.ium.config.DAO;
import de.accxia.apps.bitbucket.ium.job.JobAccessService;
import de.accxia.apps.bitbucket.ium.job.JobClusterService;
import de.accxia.apps.bitbucket.ium.job.JobDailyService;
import de.accxia.apps.bitbucket.ium.job.JobSyncService;
import de.accxia.apps.bitbucket.ium.servlet.filter.UserSessionTracker;
import de.accxia.apps.bitbucket.ium.util.IUMHelperService;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService(value={IUMListener.class})
@Component(value="IUMListener")
public class IUMListener
implements InitializingBean,
DisposableBean,
TopicListener<String> {
    private static final Logger LOG = LoggerFactory.getLogger(IUMListener.class);
    private static final String PLUGIN_KEY = "de.accxia.apps.bitbucket.ium.IUMForBitbucket";
    public static Boolean PLUGIN_ENABLED = false;
    @ComponentImport
    private final EventPublisher eventPublisher;
    @ComponentImport
    private final UserService userService;
    @ComponentImport
    private final TopicService topicService;
    String topicName;
    private Topic<String> topic;
    public static final String TOPIC_NAME = "IUMListener2";
    @ComponentImport
    private final LoggingService clusteredLoggingService;
    @ComponentImport
    private SecurityService securityService;
    private final DAO dao;
    private final IUMHelperService helperService;
    private final JobClusterService jobClusterService;
    private final JobSyncService jobSyncService;
    private final JobDailyService jobDailyService;
    private final JobAccessService jobAccessService;
    private final UserSessionTracker userSessionTracker;

    @Autowired
    public IUMListener(EventPublisher eventPublisher, UserService userService, SecurityService securityService, LoggingService clusteredLoggingService, TopicService topicService, JobClusterService jobClusterService, JobSyncService jobSyncService, JobDailyService jobDailyService, JobAccessService jobAccessService, IUMHelperService helperService, DAO dao, UserSessionTracker userSessionTracker) {
        this.eventPublisher = eventPublisher;
        this.userService = userService;
        this.securityService = securityService;
        this.clusteredLoggingService = clusteredLoggingService;
        this.helperService = helperService;
        this.dao = dao;
        this.topicService = topicService;
        this.topic = topicService.getTopic(TOPIC_NAME, TopicSettings.builder(String.class).build());
        this.jobClusterService = jobClusterService;
        this.jobSyncService = jobSyncService;
        this.jobDailyService = jobDailyService;
        this.jobAccessService = jobAccessService;
        this.userSessionTracker = userSessionTracker;
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
        PLUGIN_ENABLED = true;
        ConditionEvaluatorIUMImpl.setSideLicense();
        this.topicName = this.topic.subscribe((TopicListener)this);
        if ("on".equalsIgnoreCase(DAO.getWorkingJob()) && !this.jobClusterService.isWorking()) {
            this.jobClusterService.start();
        }
        if (DAO.getLoggerLevel().booleanValue()) {
            try {
                LOG.info("setLoggerLevel=TRUE");
                this.securityService.withPermission(Permission.SYS_ADMIN, "Accxia").call(() -> {
                    this.clusteredLoggingService.setLevel("de.accxia.apps.bitbucket.ium", "DEBUG");
                    return 0;
                });
            }
            catch (Exception e) {
                LOG.error("Exception " + e.getMessage(), (Throwable)e);
            }
        }
        if (!this.jobDailyService.isWorking()) {
            this.jobDailyService.start();
        }
        if (!this.jobAccessService.isWorking()) {
            this.jobAccessService.start();
        }
    }

    public void destroy() throws Exception {
        DAO.propertyCachedManager.cleanup();
        this.eventPublisher.unregister((Object)this);
        this.topic.unsubscribe(this.topicName);
        try {
            if (this.jobClusterService.isWorking()) {
                this.jobClusterService.stop();
            }
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
        try {
            this.jobDailyService.stop();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
        try {
            this.jobAccessService.stop();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
        PLUGIN_ENABLED = false;
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        String pluginKey = event.getPlugin().getKey();
        if (PLUGIN_KEY.equals(pluginKey)) {
            PLUGIN_ENABLED = true;
        }
    }

    @PluginEventListener
    public void onPluginDisabling(PluginDisablingEvent event) {
        String pluginKey = event.getPlugin().getKey();
        if (PLUGIN_KEY.equals(pluginKey)) {
            PLUGIN_ENABLED = false;
        }
    }

    @EventListener
    public void onAccxiaEvent(ApplicationEvent event) {
        try {
            String myClass = event.getClass().getName();
            if (ConditionEvaluatorIUMImpl.isLicenseValid() && "com.atlassian.stash.internal.event.LogoutSuccessEvent".equals(myClass)) {
                this.helperService.moveUserToDisabled(event.getUser());
                this.userSessionTracker.safeRemove(event.getUser());
            }
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
    }

    public void onMessage(@Nonnull MessageEvent<String> messageEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("IUMListener onMessage =" + (String)messageEvent.getMessage() + " topic " + messageEvent.getTopic());
        }
        if (messageEvent.getTopic().equals(TOPIC_NAME)) {
            Boolean isStarted;
            String[] parts;
            String message = (String)messageEvent.getMessage();
            if (LOG.isDebugEnabled()) {
                LOG.debug("IUMListener onMessage topicName=" + this.topicName + " , message=" + message);
            }
            if (message.startsWith("workingJob")) {
                parts = message.split(";");
                isStarted = Boolean.valueOf(parts[1]);
                if (isStarted.booleanValue()) {
                    this.jobClusterService.start();
                    LOG.info("IUMListener[workingJob] Job isStarted = " + isStarted);
                    DAO.updateWorkingJob("on");
                } else {
                    this.jobClusterService.stop();
                    LOG.info("IUMListener[workingJob] Job isStopped = " + isStarted);
                    DAO.updateWorkingJob("off");
                }
            }
            if (message.startsWith("workingSyncJob")) {
                parts = message.split(";");
                isStarted = Boolean.valueOf(parts[1]);
                if (isStarted.booleanValue()) {
                    this.jobSyncService.start();
                    LOG.info("IUMListener[workingSyncJob] Job isStarted = " + isStarted);
                    DAO.updateSyncWorkingJob("on");
                } else {
                    this.jobSyncService.stop();
                    LOG.info("IUMListener[workingSyncJob] Job isStopped = " + isStarted);
                    DAO.updateSyncWorkingJob("off");
                }
            }
        }
    }

    public void publishJobNotification(boolean isStarted) {
        if (LOG.isInfoEnabled()) {
            LOG.info("IUMListener publishJobNotification isStarted=" + isStarted);
        }
        this.topic.publish((Serializable)((Object)("workingJob;" + isStarted)));
    }

    public void publishJobSyncNotification(boolean isStarted) {
        if (LOG.isInfoEnabled()) {
            LOG.info("IUMListener publishJobSyncNotification isStarted=" + isStarted);
        }
        this.topic.publish((Serializable)((Object)("workingSyncJob;" + isStarted)));
    }
}

