/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.repository;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.sql.SQLQuery;
import de.accxia.apps.bitbucket.ium.model.NavUserDTO;
import de.accxia.apps.bitbucket.ium.repository.AccxiaDatabaseAccessor;
import de.accxia.apps.bitbucket.ium.tables.QGroup;
import de.accxia.apps.bitbucket.ium.tables.QMembership;
import de.accxia.apps.bitbucket.ium.tables.QNavUser;
import de.accxia.apps.bitbucket.ium.tables.QUser;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService(value={PocketRepository.class})
@Component(value="PocketRepository")
public class PocketRepository {
    private static final Logger LOG = LoggerFactory.getLogger(PocketRepository.class);
    private AccxiaDatabaseAccessor accxiaDatabaseAccessor;

    @Autowired
    public PocketRepository(AccxiaDatabaseAccessor accxiaDatabaseAccessor) {
        this.accxiaDatabaseAccessor = accxiaDatabaseAccessor;
    }

    public List<NavUserDTO> getAllNavUserForGroup(String groupName) {
        return this.getAllNavUserForGroup(groupName, -1, -1);
    }

    @Deprecated
    public List<NavUserDTO> getAllNavUserForGroup(String groupName, int offset, int ctx) {
        List tupleSQLQuery = this.accxiaDatabaseAccessor.run(databaseConnection -> {
            List<Path<?>> path = QNavUser.NAVUSER.getColumns();
            path.add(QMembership.MEMBERSHIP.childName);
            path.add(QMembership.MEMBERSHIP.parentName);
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(path.toArray(new Path[0])).from((Expression<?>)QMembership.MEMBERSHIP)).leftJoin((EntityPath)QNavUser.NAVUSER)).on((Predicate)QNavUser.NAVUSER.userName.eq(QMembership.MEMBERSHIP.childName))).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childId))).where(QUser.MEMBERSHIP.active.eq("T").and(QMembership.MEMBERSHIP.lowerParentName.eq(groupName.toLowerCase())))).orderBy((OrderSpecifier<?>)QNavUser.NAVUSER.lastAccessTime.asc().nullsFirst());
            if (offset > 0) {
                sqlQuery.offset(offset);
            }
            if (ctx > 0) {
                sqlQuery.limit(ctx);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("getAllNavUserForGroup SQL = " + sqlQuery.toString());
                LOG.debug("getAllNavUserForGroup groupName = " + groupName);
                LOG.debug("getAllNavUserForGroup offset = " + offset);
                LOG.debug("getAllNavUserForGroup ctx = " + ctx);
            }
            List list = sqlQuery.fetch();
            return list;
        });
        List<NavUserDTO> navUserList = this.convertTuplesToNavUserDTO(tupleSQLQuery);
        if (LOG.isTraceEnabled()) {
            for (NavUserDTO navUser : navUserList) {
                LOG.trace(navUser.toString());
            }
        }
        return navUserList;
    }

    public List<NavUserDTO> getNavUserForGroupLtTime(String groupName, Timestamp timestamp, int offset, int ctx) {
        List tupleSQLQuery = this.accxiaDatabaseAccessor.run(databaseConnection -> {
            List<Path<?>> path = QNavUser.NAVUSER.getColumns();
            path.add(QMembership.MEMBERSHIP.childName);
            path.add(QMembership.MEMBERSHIP.parentName);
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(path.toArray(new Path[0])).from((Expression<?>)QMembership.MEMBERSHIP)).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on((Predicate)QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId))).leftJoin((EntityPath)QNavUser.NAVUSER)).on((Predicate)QNavUser.NAVUSER.userName.eq(QUser.MEMBERSHIP.userName))).where(QUser.MEMBERSHIP.active.eq("T").and(QMembership.MEMBERSHIP.lowerParentName.eq(groupName.toLowerCase())).and(QNavUser.NAVUSER.lastAccessTime.lt(timestamp).or(QNavUser.NAVUSER.lastAccessTime.isNull())))).orderBy((OrderSpecifier<?>)QNavUser.NAVUSER.lastAccessTime.asc().nullsFirst());
            if (offset > 0) {
                sqlQuery.offset(offset);
            }
            if (ctx > 0) {
                sqlQuery.limit(ctx);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("getNavUserForGroupLtTime SQL = " + sqlQuery.toString());
                LOG.debug("getNavUserForGroupLtTime groupName = " + groupName);
                LOG.debug("getNavUserForGroupLtTime offset = " + offset);
                LOG.debug("getNavUserForGroupLtTime ctx = " + ctx);
            }
            List list = sqlQuery.fetch();
            return list;
        });
        List<NavUserDTO> navUserList = this.convertTuplesToNavUserDTO(tupleSQLQuery);
        if (LOG.isTraceEnabled()) {
            for (NavUserDTO navUser : navUserList) {
                LOG.trace(navUser.toString());
            }
        }
        return navUserList;
    }

    public List<NavUserDTO> getNavUserForGroupLtTime(String groupName, boolean onlyActive, Timestamp timestamp, int offset, int ctx) {
        List tupleSQLQuery = this.accxiaDatabaseAccessor.run(databaseConnection -> {
            List<Path<?>> path = QNavUser.NAVUSER.getColumns();
            path.add(QMembership.MEMBERSHIP.childName);
            path.add(QMembership.MEMBERSHIP.parentName);
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(path.toArray(new Path[0])).from((Expression<?>)QMembership.MEMBERSHIP)).leftJoin((EntityPath)QNavUser.NAVUSER)).on((Predicate)QNavUser.NAVUSER.userName.eq(QMembership.MEMBERSHIP.childName))).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childId));
            if (onlyActive) {
                sqlQuery.where(QUser.MEMBERSHIP.active.eq("T").and(QMembership.MEMBERSHIP.lowerParentName.eq(groupName.toLowerCase())).and(QNavUser.NAVUSER.lastAccessTime.lt(timestamp).or(QNavUser.NAVUSER.lastAccessTime.isNull())));
            } else {
                sqlQuery.where(QMembership.MEMBERSHIP.lowerParentName.eq(groupName.toLowerCase()).and(QNavUser.NAVUSER.lastAccessTime.lt(timestamp).or(QNavUser.NAVUSER.lastAccessTime.isNull())));
            }
            ((SQLQuery)((SQLQuery)sqlQuery.orderBy((OrderSpecifier<?>)QNavUser.NAVUSER.lastAccessTime.asc().nullsFirst())).offset(offset)).limit(ctx);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getNavUserForGroupLtTime SQL = " + sqlQuery.toString());
                LOG.debug("getNavUserForGroupLtTime groupName = " + groupName);
                LOG.debug("getNavUserForGroupLtTime offset = " + offset);
                LOG.debug("getNavUserForGroupLtTime ctx = " + ctx);
            }
            List list = sqlQuery.fetch();
            return list;
        });
        return this.convertTuplesToNavUserDTO(tupleSQLQuery);
    }

    public List<NavUserDTO> getNavUserForGroupLtTime(String fromGroupName, String withGroupName, Timestamp timestamp, int ctx) {
        List tupleSQLQuery = this.accxiaDatabaseAccessor.run(databaseConnection -> {
            List<Path<?>> path = QNavUser.NAVUSER.getColumns();
            path.add(QMembership.MEMBERSHIP.childName);
            path.add(QMembership.MEMBERSHIP.parentName);
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(path.toArray(new Path[0])).from((Expression<?>)QUser.MEMBERSHIP)).leftJoin((EntityPath)QNavUser.NAVUSER)).on((Predicate)QNavUser.NAVUSER.userName.eq(QUser.MEMBERSHIP.lowerUserName))).innerJoin((EntityPath)QMembership.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childId))).innerJoin((EntityPath)QMembership.MEMBERSHIP2)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP2.childId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on(new Predicate[]{QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId), QGroup.MEMBERSHIP.lowerGroupName.eq(fromGroupName)})).innerJoin((EntityPath)QGroup.MEMBERSHIP2)).on(new Predicate[]{QGroup.MEMBERSHIP2.id.eq(QMembership.MEMBERSHIP2.parentId), QGroup.MEMBERSHIP2.lowerGroupName.eq(withGroupName)});
            sqlQuery.where(QNavUser.NAVUSER.lastAccessTime.lt(timestamp).or(QNavUser.NAVUSER.lastAccessTime.isNull()));
            ((SQLQuery)sqlQuery.orderBy((OrderSpecifier<?>)QNavUser.NAVUSER.lastAccessTime.asc().nullsFirst())).limit(ctx);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getNavUserForGroupLtTime SQL = " + sqlQuery.toString());
                LOG.debug("getNavUserForGroupLtTime groupName = " + fromGroupName);
                LOG.debug("getNavUserForGroupLtTime groupName = " + withGroupName);
                LOG.debug("getNavUserForGroupLtTime timestamp = " + timestamp);
            }
            List list = sqlQuery.fetch();
            return list;
        });
        return this.convertTuplesToNavUserDTO(tupleSQLQuery);
    }

    public List<String> getNavUserFor2Groups(String groupName1, String groupName2) {
        List tupleSQLQuery = this.accxiaDatabaseAccessor.run(databaseConnection -> {
            ArrayList<StringPath> path = new ArrayList<StringPath>();
            path.add(QUser.MEMBERSHIP.userName);
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(path.toArray(new Path[0])).from((Expression<?>)QUser.MEMBERSHIP)).innerJoin((EntityPath)QMembership.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childId))).innerJoin((EntityPath)QMembership.MEMBERSHIP2)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP2.childId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on(new Predicate[]{QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId), QGroup.MEMBERSHIP.lowerGroupName.eq(groupName1)})).innerJoin((EntityPath)QGroup.MEMBERSHIP2)).on(new Predicate[]{QGroup.MEMBERSHIP2.id.eq(QMembership.MEMBERSHIP2.parentId), QGroup.MEMBERSHIP2.lowerGroupName.eq(groupName2)});
            if (LOG.isDebugEnabled()) {
                LOG.debug("getNavUserForGroupLtTime SQL = " + sqlQuery.toString());
                LOG.debug("getNavUserForGroupLtTime groupName = " + groupName1);
                LOG.debug("getNavUserForGroupLtTime groupName = " + groupName2);
            }
            List list = sqlQuery.fetch();
            return list;
        });
        return this.convertTuplesToString(tupleSQLQuery);
    }

    public List<NavUserDTO> getOldestUsers(String groupName, int offset, int ctx) {
        List tupleSQLQuery = this.accxiaDatabaseAccessor.run(databaseConnection -> {
            List<Path<?>> path = QNavUser.NAVUSER.getColumns();
            path.add(QMembership.MEMBERSHIP.childName);
            path.add(QMembership.MEMBERSHIP.parentName);
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(path.toArray(new Path[0])).from((Expression<?>)QMembership.MEMBERSHIP)).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childId))).leftJoin((EntityPath)QNavUser.NAVUSER)).on((Predicate)QNavUser.NAVUSER.userName.eq(QUser.MEMBERSHIP.userName))).where(QMembership.MEMBERSHIP.lowerParentName.eq(groupName.toLowerCase()))).orderBy((OrderSpecifier<?>)QNavUser.NAVUSER.lastAccessTime.asc().nullsFirst())).offset(offset)).limit(ctx);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getOldestUsers SQL = " + sqlQuery.toString());
                LOG.debug("getOldestUsers groupName = " + groupName);
                LOG.debug("getOldestUsers offset = " + offset);
                LOG.debug("getOldestUsers ctx = " + ctx);
            }
            List list = sqlQuery.fetch();
            return list;
        });
        List<NavUserDTO> navUserList = this.convertTuplesToNavUserDTO(tupleSQLQuery);
        if (LOG.isTraceEnabled()) {
            for (NavUserDTO navUser : navUserList) {
                LOG.trace(navUser.toString());
            }
        }
        return navUserList;
    }

    public long getCountOfNavUserForGroup(String groupName) {
        long tupleSQLQuery = this.accxiaDatabaseAccessor.run(databaseConnection -> {
            List<Path<?>> path = QNavUser.NAVUSER.getColumns();
            path.add(QMembership.MEMBERSHIP.childName);
            path.add(QMembership.MEMBERSHIP.parentName);
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(path.toArray(new Path[0])).from((Expression<?>)QMembership.MEMBERSHIP)).leftJoin((EntityPath)QNavUser.NAVUSER)).on((Predicate)QNavUser.NAVUSER.userName.eq(QMembership.MEMBERSHIP.childName))).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childId))).where(QUser.MEMBERSHIP.active.eq("T").and(QMembership.MEMBERSHIP.lowerParentName.eq(groupName.toLowerCase())))).orderBy((OrderSpecifier<?>)QNavUser.NAVUSER.lastAccessTime.asc().nullsFirst());
            if (LOG.isDebugEnabled()) {
                LOG.debug("CountOfNavUserForGroup SQL = " + sqlQuery.toString());
                LOG.debug("CountOfNavUserForGroup groupName = " + groupName);
            }
            List list = sqlQuery.fetch();
            long retVal = sqlQuery.fetchCount();
            return retVal;
        });
        return tupleSQLQuery;
    }

    public List<NavUserDTO> getOldestUsers(String groupName, String filterGroup, int offset, int ctx) {
        String filterGroupName = StringUtils.isEmpty((CharSequence)filterGroup) ? null : filterGroup.toLowerCase();
        List tupleSQLQuery = this.accxiaDatabaseAccessor.run(databaseConnection -> {
            List<Path<?>> path = QNavUser.NAVUSER.getColumns();
            path.add(QUser.MEMBERSHIP.displayName);
            path.add(QUser.MEMBERSHIP.emailAddress);
            path.add(QMembership.MEMBERSHIP.childName);
            path.add(QMembership.MEMBERSHIP.parentName);
            SubQueryExpression filterQuery = filterGroupName == null ? null : (SubQueryExpression)((SQLQuery)databaseConnection.select(QMembership.MEMBERSHIP.lowerChildName).from((Expression<?>)QMembership.MEMBERSHIP)).where(QMembership.MEMBERSHIP.lowerParentName.eq(filterGroupName));
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(path.toArray(new Path[0])).from((Expression<?>)QMembership.MEMBERSHIP)).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on((Predicate)QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId))).leftJoin((EntityPath)QNavUser.NAVUSER)).on((Predicate)QNavUser.NAVUSER.userName.eq(QUser.MEMBERSHIP.userName))).where(QUser.MEMBERSHIP.active.eq("T").and(QMembership.MEMBERSHIP.parentName.eq(groupName)).and(filterGroupName == null ? Expressions.TRUE : QMembership.MEMBERSHIP.lowerChildName.notIn(filterQuery)))).orderBy((OrderSpecifier<?>)QNavUser.NAVUSER.lastAccessTime.asc().nullsFirst())).offset(offset);
            if (ctx > 0) {
                sqlQuery.limit(ctx);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("getOldestUsers SQL = " + sqlQuery.toString());
                if (filterGroupName != null) {
                    LOG.debug("getOldestUsers filterGroup = " + filterGroup);
                    LOG.debug("getOldestUsers filterQuery = " + filterQuery.toString());
                }
                LOG.debug("getOldestUsers groupName = " + groupName);
                LOG.debug("getOldestUsers offset = " + offset);
                LOG.debug("getOldestUsers ctx = " + ctx);
            }
            List list = sqlQuery.fetch();
            return list;
        });
        List<NavUserDTO> navUserList = this.convertTuplesToNavUserDTO(tupleSQLQuery);
        if (LOG.isDebugEnabled()) {
            for (NavUserDTO navUser : navUserList) {
                LOG.debug(navUser.toString());
            }
        }
        return navUserList;
    }

    public long countOldestUsers(String groupName, String filterGroup) {
        String filterGroupName = StringUtils.isEmpty((CharSequence)filterGroup) ? null : filterGroup.toLowerCase();
        long tupleSQLQuery = this.accxiaDatabaseAccessor.run(databaseConnection -> {
            SubQueryExpression filterQuery = filterGroupName == null ? null : (SubQueryExpression)((SQLQuery)databaseConnection.select(QMembership.MEMBERSHIP.lowerChildName).from((Expression<?>)QMembership.MEMBERSHIP)).where(QMembership.MEMBERSHIP.lowerParentName.eq(filterGroupName));
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(new Expression[0]).from((Expression<?>)QMembership.MEMBERSHIP)).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on((Predicate)QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId))).leftJoin((EntityPath)QNavUser.NAVUSER)).on((Predicate)QNavUser.NAVUSER.userName.eq(QUser.MEMBERSHIP.userName))).where(QUser.MEMBERSHIP.active.eq("T").and(QMembership.MEMBERSHIP.parentName.eq(groupName)).and(filterGroupName == null ? Expressions.TRUE : QMembership.MEMBERSHIP.lowerChildName.notIn(filterQuery)));
            if (LOG.isDebugEnabled()) {
                LOG.debug("countOldestUsers SQL = " + sqlQuery.toString());
                if (filterGroupName != null) {
                    LOG.debug("countOldestUsers filterGroup = " + filterGroup);
                    LOG.debug("countOldestUsers filterQuery = " + filterQuery.toString());
                }
                LOG.debug("countOldestUsers groupName = " + groupName);
            }
            long retVal = sqlQuery.fetchCount();
            return retVal;
        });
        return tupleSQLQuery;
    }

    public long countOldestUsers(String groupName) {
        return this.countOldestUsers(groupName, null);
    }

    public long getCountOfUsersForGroup(String groupName) {
        long tupleSQLQuery = this.accxiaDatabaseAccessor.run(databaseConnection -> {
            List<Path<?>> path = QNavUser.NAVUSER.getColumns();
            path.add(QMembership.MEMBERSHIP.childName);
            path.add(QMembership.MEMBERSHIP.parentName);
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)databaseConnection.select(new Expression[0]).from((Expression<?>)QMembership.MEMBERSHIP)).where(QMembership.MEMBERSHIP.lowerParentName.eq(groupName.toLowerCase()));
            if (LOG.isDebugEnabled()) {
                LOG.debug("CountOfUsersForGroup SQL = " + sqlQuery.toString());
            }
            long retVal = sqlQuery.fetchCount();
            return retVal;
        });
        return tupleSQLQuery;
    }

    @Deprecated
    public List<String> getMembershipForUser(String username) {
        List tupleSQLQuery = this.accxiaDatabaseAccessor.run(databaseConnection -> {
            List<Path<?>> path = QMembership.MEMBERSHIP.getColumns();
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)databaseConnection.select(path.toArray(new Path[0])).from((Expression<?>)QMembership.MEMBERSHIP)).where(QMembership.MEMBERSHIP.lowerChildName.eq(username.toLowerCase()));
            if (LOG.isDebugEnabled()) {
                LOG.debug("getMmebershipForUser SQL = " + sqlQuery.toString());
            }
            List list = sqlQuery.fetch();
            return list;
        });
        return this.convertTuplesToUsertMmebership(tupleSQLQuery);
    }

    public List<String> getMebershipForGroup(String groupname) {
        List tupleSQLQuery = this.accxiaDatabaseAccessor.run(databaseConnection -> {
            List<Path<?>> path = QMembership.MEMBERSHIP.getColumns();
            path.add(QUser.MEMBERSHIP.id);
            path.add(QUser.MEMBERSHIP.directoryId);
            path.add(QUser.MEMBERSHIP.userName);
            path.add(QUser.MEMBERSHIP.lowerUserName);
            path.add(QGroup.MEMBERSHIP.id);
            path.add(QGroup.MEMBERSHIP.groupName);
            path.add(QGroup.MEMBERSHIP.lowerGroupName);
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(path.toArray(new Path[0])).from((Expression<?>)QMembership.MEMBERSHIP)).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on((Predicate)QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId))).where(QMembership.MEMBERSHIP.parentName.eq(groupname).and(QUser.MEMBERSHIP.active.eq("T")));
            if (LOG.isDebugEnabled()) {
                LOG.debug("getMmebershipForUser SQL = " + sqlQuery.toString());
            }
            List list = sqlQuery.fetch();
            return list;
        });
        return this.convertTuplesToUsertMmebership(tupleSQLQuery);
    }

    private List<NavUserDTO> convertTuplesToNavUserDTO(List<Tuple> tupleSQLQuery) {
        ArrayList<NavUserDTO> retVal = new ArrayList<NavUserDTO>();
        for (Tuple tuple : tupleSQLQuery) {
            retVal.add(this.convertTupleToEventModel(tuple));
        }
        return retVal;
    }

    private NavUserDTO convertTupleToEventModel(Tuple tuple) {
        NavUserDTO navUserDTO = new NavUserDTO();
        if (tuple.get(QNavUser.NAVUSER.id) != null) {
            navUserDTO.setID(tuple.get(QNavUser.NAVUSER.id));
            navUserDTO.setRequestCount(tuple.get(QNavUser.NAVUSER.requestCount));
            navUserDTO.setUserName(tuple.get(QNavUser.NAVUSER.userName));
            navUserDTO.setLastAccessTime(tuple.get(QNavUser.NAVUSER.lastAccessTime));
            navUserDTO.setCreationTime(tuple.get(QNavUser.NAVUSER.creationTime));
        }
        navUserDTO.setUserNameEx(tuple.get(QMembership.MEMBERSHIP.childName));
        navUserDTO.setGroupNameEx(tuple.get(QMembership.MEMBERSHIP.parentName));
        return navUserDTO;
    }

    private List<String> convertTuplesToUsertMmebership(List<Tuple> tupleSQLQuery) {
        ArrayList<String> retVal = new ArrayList<String>();
        for (Tuple tuple : tupleSQLQuery) {
            retVal.add(this.convertTupleToMembershipModel(tuple));
        }
        return retVal;
    }

    private String convertTupleToMembershipModel(Tuple tuple) {
        ArrayList<Object> membership = new ArrayList<Object>();
        membership.add(String.valueOf(tuple.get(QMembership.MEMBERSHIP.id)));
        membership.add(tuple.get(QMembership.MEMBERSHIP.childName));
        membership.add(tuple.get(QMembership.MEMBERSHIP.lowerChildName));
        membership.add(tuple.get(QMembership.MEMBERSHIP.parentName));
        membership.add(tuple.get(QMembership.MEMBERSHIP.lowerParentName));
        membership.add(tuple.get(QMembership.MEMBERSHIP.groupType));
        membership.add(String.valueOf(tuple.get(QMembership.MEMBERSHIP.membershipType)));
        membership.add("Membership.directoryId-" + String.valueOf(tuple.get(QMembership.MEMBERSHIP.directoryId)));
        membership.add("Membership.userId=" + String.valueOf(tuple.get(QMembership.MEMBERSHIP.childId)));
        membership.add("Membership.groupId=" + String.valueOf(tuple.get(QMembership.MEMBERSHIP.parentId)));
        membership.add("User.id=" + String.valueOf(tuple.get(QUser.MEMBERSHIP.id)));
        membership.add("User.directoryId=" + String.valueOf(tuple.get(QUser.MEMBERSHIP.directoryId)));
        membership.add("User.userName=" + tuple.get(QUser.MEMBERSHIP.userName));
        membership.add("User.lowerUserName=" + tuple.get(QUser.MEMBERSHIP.lowerUserName));
        return membership.stream().collect(Collectors.joining(", "));
    }

    private List<String> convertTuplesToString(List<Tuple> tupleSQLQuery) {
        ArrayList<String> retVal = new ArrayList<String>();
        for (Tuple tuple : tupleSQLQuery) {
            retVal.add(this.convertTupleToString(tuple));
        }
        return retVal;
    }

    private String convertTupleToString(Tuple tuple) {
        return tuple.get(QUser.MEMBERSHIP.userName);
    }
}

