/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.servlet;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import de.accxia.apps.bitbucket.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.bitbucket.ium.config.DAO;
import de.accxia.apps.bitbucket.ium.impl.CurrentUser;
import de.accxia.apps.bitbucket.ium.saml.SAMLHelper;
import de.accxia.apps.bitbucket.ium.util.IUMHelperService;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SAMLServlet
extends HttpServlet {
    private static final long serialVersionUID = -1585035763724104775L;
    private static final Logger log = LoggerFactory.getLogger(SAMLServlet.class);
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private final UserService userService;
    private final IUMHelperService helperService;

    @Inject
    public SAMLServlet(UserManager userManager, UserService userService, IUMHelperService helperService, TemplateRenderer renderer) {
        this.userManager = userManager;
        this.userService = userService;
        this.helperService = helperService;
        this.renderer = renderer;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = request;
        if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
            response.getWriter().write("Error unlicensed");
            return;
        }
        if ("".equals(DAO.getSamlIdp())) {
            response.getWriter().write("Error no redir url configured");
            return;
        }
        HttpServletRequest httpRequest = request;
        HttpServletResponse httpResponse = response;
        String samlPar = req.getParameter("SAMLResponse");
        String userName = SAMLHelper.getSAMLUserFromSAMLResponse(samlPar);
        if (userName == null) {
            response.sendRedirect(DAO.getSamlIdp());
            return;
        }
        ApplicationUser user = this.userService.getUserByName(userName);
        if (this.helperService.isUserInGroups(user, DAO.getIUMGroups())) {
            httpResponse.sendRedirect(DAO.getSamlIdp());
            return;
        }
        if (!this.helperService.isUserInGroups(user, DAO.getIUMGroupsDisabled())) {
            httpResponse.sendRedirect(DAO.getSamlIdp());
            return;
        }
        CurrentUser currentUser = this.helperService.enableUserFromGroup(user, httpRequest);
        if (currentUser != null) {
            ApplicationUser theUser = currentUser.user;
            if (theUser != null) {
                httpResponse.sendRedirect(DAO.getSamlIdp());
            } else {
                this.renderQueueVM(currentUser.noOfUsers, httpRequest, httpResponse);
                return;
            }
        }
    }

    private void renderQueueVM(int noOfUsers, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("duration", DAO.getDuration());
        context.put("queueSize", noOfUsers);
        context.put("redirUrl", DAO.getSamlIdp());
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/queue_IUM.vm", context, (Writer)response.getWriter());
    }
}

