/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.servlet.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.apps.bitbucket.ium.repository.NavUserRepository;
import de.accxia.apps.bitbucket.ium.servlet.filter.UserSessionTracker;
import de.accxia.apps.bitbucket.ium.util.IUMHelperService;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@UnrestrictedAccess
public class AccessLogFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(AccessLogFilter.class);
    @ComponentImport
    private final AuthenticationContext authenticationContext;
    public final NavUserRepository navUserRepository;
    private final IUMHelperService helperService;
    private final UserSessionTracker userSessionTracker;

    @Inject
    public AccessLogFilter(AuthenticationContext authenticationContext, NavUserRepository navUserRepository, IUMHelperService helperService, UserSessionTracker userSessionTracker) {
        this.authenticationContext = authenticationContext;
        this.navUserRepository = navUserRepository;
        this.helperService = helperService;
        this.userSessionTracker = userSessionTracker;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        LOG.info("AccessLogFilter initialized.");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        try {
            String requestURI = httpServletRequest.getRequestURI();
            if (requestURI == null) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("AccessLogFilter requestURI=" + requestURI);
            }
            if (!requestURI.contains("/rest/oidc/") && !requestURI.contains("/rest/quickreload/") && (requestURI.contains("/rest/") || requestURI.contains("/synchrony/heartbeat") || requestURI.contains("/json/start"))) {
                return;
            }
            this.userSessionTracker.recordInteraction(httpServletRequest, httpServletResponse);
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
    }
}

