/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.servlet.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.apps.bitbucket.ium.conditions.ConditionEvaluatorIUMImpl;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@UnrestrictedAccess
public class IntelligentUserManagerRestHackFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(IntelligentUserManagerRestHackFilter.class);
    private static final String PATTERN_PERMISSION = "/rest/api/[\\S]+/projects/([\\S]+)/permissions/users/none";
    private static final String REST_API_USERS = "/rest/api/1.0/users";
    @ComponentImport
    private final AuthenticationContext authenticationContext;

    public IntelligentUserManagerRestHackFilter(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String requestURI;
        ApplicationUser user;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("IntelligentUserManagerRestHackFilter doFilter requestURI =" + (httpServletRequest.getRequestURI() != null ? httpServletRequest.getRequestURI() : "N/A") + ", servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "N/A") + ", pathInfo=" + (httpServletRequest.getPathInfo() != null ? httpServletRequest.getPathInfo() : "N/A") + ", user=" + (httpServletRequest.getRemoteUser() != null ? httpServletRequest.getRemoteUser() : "N/A"));
        }
        if ((user = this.authenticationContext.getCurrentUser()) == null || !user.isActive()) {
            chain.doFilter(request, response);
            return;
        }
        if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
            chain.doFilter(request, response);
            return;
        }
        if (httpServletRequest.getRequestURI() != null && httpServletRequest.getContentType() != null && httpServletRequest.getContentType().contains("application/json") && (requestURI = httpServletRequest.getRequestURI()).matches(PATTERN_PERMISSION)) {
            httpServletResponse.sendRedirect("/rest/api/1.0/users?" + httpServletRequest.getQueryString());
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

