var IUMCheck = new function() {
    var self=this;
    var theTimer;
    const INTERVAL=15000;
    const MINUTE=60 * 1000;
    const DELTA=300;
    const DEBUG=false;
    const IUM_CHECK_SLOT_PING='bb_ium_check_slot_ping'
    const IUM_CHECK_SLOT_LOGOUT='bb_ium_check_slot_logout'

    var logout=function(force){
        if(force){
            document.location.href=AJS.contextPath() + "/logout.action";
            return;
        }

        if(self.theLastUserName){
            document.location.href=AJS.contextPath() + "/secure/disable?username="+self.theLastUserName;
        }else {
            document.location.href = AJS.contextPath() + "/dashboard";
        }
    }

    var doRetry=function(){
       if(document.forms['retry']){
           document.forms['retry'].submit();
           return;
       }
        //document.location.href="/secure/restore?username="+self.theLastUserName;
        document.location.href = AJS.contextPath() + "/dashboard";
    }

    var checkApplicationAccess=function(){
        //pass 15 sec
        self.duration=self.duration-INTERVAL;
        console.log("checkApplicationAccess self.duration= "+self.duration);

        if(self.duration>0){
            var dateNow = Date.now();
            var dateStr=window.localStorage.getItem(IUM_CHECK_SLOT_PING);
            var dateRef =null;
            if(dateStr){
                try{
                    dateRef = JSON.parse(dateStr);
                    var dateDiff = dateNow - dateRef.timestamp;
                    if(DEBUG){
                        console.log("CHK:" + (new Date(dateNow).toISOString().slice(-13, -5)) + " / " + (new Date(dateRef.timestamp).toISOString().slice(-13, -5)) + " Access diff " + (dateNow - dateRef.timestamp));
                    }

                    if (((Math.abs(dateDiff - INTERVAL) > DELTA) && (dateDiff < INTERVAL + 2 * DELTA)) && (dateRef.username === self.theLastUserName)) {
                        if(DEBUG){
                            console.log("BKP:" + (new Date(dateNow).toISOString().slice(-13, -5)) + " / " + (new Date(dateRef.timestamp).toISOString().slice(-13, -5)) + " Access diff " + (dateNow - dateRef.timestamp));
                        }
                        doProcessData(dateRef,false);
                        return;
                    }
                } catch (error) {
                    console.error(error);
                    dateRef=null;
                }
            }

            if(DEBUG){
                if(dateRef && dateRef.timestamp){
                    console.log("NET:" +( new Date().toISOString().slice(-13, -5)) + " / " + ( new Date(dateRef.timestamp).toISOString().slice(-13, -5))  +  " Access diff " +(dateNow - dateRef.timestamp) );
                }else{
                    console.log("NET:" +( new Date().toISOString().slice(-13, -5)));
                }
            }

            self.ajaxGetCall(AJS.contextPath() + "/rest/IUM/latest/apps/check?username="+self.theLastUserName);
        }else{
            callRetry();
        }
    }

    var doProcessData=function(data,withSaving){
        if(DEBUG){
            console.log("data="+ JSON.stringify(data));
        }
        if(data.freeSlots){
            doRetry()
        }

        if(withSaving){
            data.timestamp = Date.now();
            data.username=self.theLastUserName;
            localStorage.setItem(IUM_CHECK_SLOT_PING,JSON.stringify(data));
            if(DEBUG){
                console.log("SAVE:" + ( new Date(data.timestamp).toISOString().slice(-13, -5))  +  " data=" +JSON.stringify(data) );
            }
        }
    }

    this.startCheckWatcher=function(){
        //1. retrive input.hidden
        var userName=AJS.$("#username").val();
        var duration=AJS.$("#duration").val();
        self.duration = duration ? duration : 1;

        //convert to milliseconds
        self.duration=self.duration * MINUTE;

        if (typeof (userName)!="undefined"){
            self.theLastUserName=userName;
            theTimer=setInterval(checkApplicationAccess, INTERVAL);

            window.addEventListener('storage', function(event) {
                // Check the changed key and react accordingly
                if (event.key === IUM_CHECK_SLOT_LOGOUT) {
                    var datRef =JSON.parse(event.newValue);
                    if(self.theLastUserName === datRef.username){
                        logout();
                    }
                }
            });

        }


    }

    var callRetry=function(){
        clearInterval(theTimer);
        doRetry();
    }

    var callLogout=function(force){
        clearInterval(theTimer);
        var dateRef={username:self.theLastUserName, timestamp:Date.now()};
        window.localStorage.setItem(IUM_CHECK_SLOT_LOGOUT,JSON.stringify(dateRef));
        logout(force);
        console.log("ACCXIA IUM: User has been logged out");
    }

    this.ajaxGetCall = function(url) {
        jQuery.ajax({
            url : url,
            dataType : 'json',
            contentType: "application/json; charset=utf-8",
            async : true,
            success : function(data) {
                doProcessData(data,true)

            },
            error :function (xhr, textStatus, errorThrown ) {
                if (xhr.status >= 400 || errorThrown ) {
                    // {"message":"Client must be authenticated to access this resource.","status-code":401}   Unauthorized
                    if(xhr.status==401){
                        callLogout(true);
                        return;
                    }

                    callLogout();
                }
            }
        });
    };
};

AJS.$( document ).ready(function() {
    IUMCheck.startCheckWatcher();
});
