/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.querydsl.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MemoizingResettingReference<P, T> {
    private final AtomicReference<Supplier<T>> supplierRef = new AtomicReference();
    private final Function<P, T> valueCreator;

    public MemoizingResettingReference(Function<P, T> valueCreator) {
        this.valueCreator = Preconditions.checkNotNull(valueCreator);
    }

    public T get(P parameter) {
        Supplier<T> supplier = this.supplierRef.get();
        if (supplier == null) {
            Supplier<Object> delegate = () -> this.valueCreator.apply(parameter);
            this.supplierRef.compareAndSet(null, new SmarterMemoizingSupplier(delegate));
        }
        supplier = this.supplierRef.get();
        return this.safelyGetT(supplier);
    }

    private T safelyGetT(Supplier<T> supplier) {
        try {
            T t2 = supplier.get();
            Preconditions.checkNotNull(t2, "You MUST not provide null values to MemoizingResettingReference");
            return t2;
        }
        catch (RuntimeException rte) {
            this.reset();
            throw rte;
        }
    }

    public T getMemoizedValue() throws MemoizedValueNotPresentException {
        Supplier<T> supplier = this.supplierRef.get();
        if (supplier == null) {
            throw new MemoizedValueNotPresentException();
        }
        return this.safelyGetT(supplier);
    }

    public void reset() {
        this.supplierRef.set(null);
    }

    private static class SmarterMemoizingSupplier<T>
    implements Supplier<T> {
        private AtomicReference<Supplier<T>> delegate;
        private AtomicReference<T> value;
        private AtomicBoolean initialized = new AtomicBoolean(false);

        private SmarterMemoizingSupplier(Supplier<T> delegate) {
            this.delegate = new AtomicReference<Supplier<T>>(delegate);
            this.value = new AtomicReference();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (!this.initialized.get()) {
                SmarterMemoizingSupplier smarterMemoizingSupplier = this;
                synchronized (smarterMemoizingSupplier) {
                    if (!this.initialized.get()) {
                        T t2 = this.delegate.get().get();
                        this.value.set(t2);
                        this.delegate.set(null);
                        this.initialized.set(true);
                    }
                }
            }
            return this.value.get();
        }
    }

    public static class MemoizedValueNotPresentException
    extends RuntimeException {
        public MemoizedValueNotPresentException() {
            super("MemoizingResettingReference.getMemoizedValue called and the value is not previously been initialised via MemoizingResettingReference.get(<P>)");
        }
    }
}

