/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.conditions;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.apps.bitbucket.ium.conditions.BaseCondition;
import de.accxia.apps.bitbucket.ium.config.DAO;
import de.accxia.apps.bitbucket.ium.util.IUMHelperService;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsUserInGroupsCondition
extends BaseCondition {
    private static final Logger LOG = LoggerFactory.getLogger(IsUserInGroupsCondition.class);
    @ComponentImport
    private final AuthenticationContext authenticationContext;
    private final IUMHelperService iumHelperService;
    private Map<String, String> map;

    @Inject
    public IsUserInGroupsCondition(IUMHelperService iumHelperService, AuthenticationContext authenticationContext) {
        super(authenticationContext);
        this.authenticationContext = authenticationContext;
        this.iumHelperService = iumHelperService;
    }

    @Override
    protected String queryKey() {
        return "ium-groups-bitbucket";
    }

    @Override
    protected boolean isConditionTrue() {
        if (!this.authenticationContext.isAuthenticated()) {
            LOG.debug("IsUserInGroupsCondition user F : currentUser unAuthenticated");
            return false;
        }
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("IsUserInGroupsCondition user F : currentUser= NULL");
            }
            return false;
        }
        if (this.iumHelperService.isUserInGroups(currentUser, DAO.getIUMGroupsDisabled())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("IsUserInGroupsCondition user T:" + currentUser.getName() + " is in groups=" + DAO.getIUMGroupsDisabled());
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("IsUserInGroupsCondition user F:" + currentUser.getName() + " is not in groups=" + DAO.getIUMGroupsDisabled());
        }
        return false;
    }
}

