/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.job;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.google.common.collect.Sets;
import de.accxia.apps.bitbucket.ium.job.IJob;
import de.accxia.apps.bitbucket.ium.job.ProcessResult;
import de.accxia.apps.bitbucket.ium.repository.JobResultRepository;
import de.accxia.apps.bitbucket.ium.repository.PocketRepository;
import java.io.Serializable;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMSyncJob
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMSyncJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static IUMSyncJob instance;
    private PermissionService permissionService;
    private PocketRepository pocketRepository;
    private JobResultRepository jobResultRepository;
    private SecurityService securityService;
    private UserAdminService userAdminService;
    int syncUsers = 0;

    private IUMSyncJob() {
    }

    public static IUMSyncJob getInstance() {
        if (instance == null) {
            instance = new IUMSyncJob();
        }
        return instance;
    }

    @Override
    public void injectService(PocketRepository pocketRepository, JobResultRepository jobResultRepository, SecurityService securityService, UserAdminService userAdminService) {
        IUMSyncJob.instance.pocketRepository = pocketRepository;
        IUMSyncJob.instance.jobResultRepository = jobResultRepository;
        IUMSyncJob.instance.securityService = securityService;
        IUMSyncJob.instance.userAdminService = userAdminService;
    }

    @Override
    public void injectService(PermissionService permissionService) {
        IUMSyncJob.instance.permissionService = permissionService;
    }

    @Override
    public List<ProcessResult> doProcessingJob(Map<String, Serializable> parameters) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMDailyJob Process #[" + SDF.format(new Date()) + "] ");
        }
        ArrayList<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        String sourceGroups = (String)((Object)parameters.get("source_all_groups"));
        String targetGroup = (String)((Object)parameters.get("target_all_group"));
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMSyncJob Sync groups = {} -> {}  at [ {} ] ", new Object[]{sourceGroups, targetGroup, SDF.format(new Date())});
        }
        if (this.pocketRepository != null && this.jobResultRepository != null && !StringUtils.isEmpty((CharSequence)sourceGroups) && !StringUtils.isEmpty((CharSequence)targetGroup)) {
            String[] arraySourceGroups = sourceGroups.split(",");
            String[] arrayTargetGroups = targetGroup.split(",");
            this.syncUsers = 0;
            for (int i = 0; i < arraySourceGroups.length; ++i) {
                if (arrayTargetGroups.length <= i || IUMSyncJob.isEmpty(arraySourceGroups[i]) || IUMSyncJob.isEmpty(arrayTargetGroups[i])) continue;
                ProcessResult processResult = this.processPair(arraySourceGroups[i], arrayTargetGroups[i]);
                processResultList.add(processResult);
            }
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("IUMSyncJob copied #" + this.syncUsers + " to groups " + targetGroup);
            }
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMSyncJob Processed #[" + SDF.format(new Date()) + "] ");
        }
        return processResultList;
    }

    private ProcessResult processPair(String sourceGroups, String targetGroup) {
        String[] arrayEnableGroups;
        String[] stringArray = arrayEnableGroups = IUMSyncJob.isEmpty(sourceGroups) ? null : sourceGroups.split(";");
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMSyncJob Sync groups = {} -> {}  at [ {} ] ", new Object[]{sourceGroups, targetGroup, SDF.format(new Date())});
        }
        ProcessResult processResult = new ProcessResult("SyncJob", sourceGroups, targetGroup);
        if (arrayEnableGroups != null && arrayEnableGroups.length > 0 && targetGroup != null && targetGroup.length() > 0) {
            List<DetailedUser> targetUsers;
            try {
                targetUsers = this.getUsersFromGroup(targetGroup);
            }
            catch (Exception ex) {
                this.LOG.error("Exception=" + ex.getMessage(), (Throwable)ex);
                return processResult;
            }
            ArrayList<DetailedUser> sourceUsers = new ArrayList<DetailedUser>();
            for (String group : arrayEnableGroups) {
                try {
                    sourceUsers.addAll(this.getUsersFromGroup(group));
                }
                catch (Exception ex) {
                    this.LOG.error("Exception=" + ex.getMessage(), (Throwable)ex);
                }
            }
            Set targetUserSet = targetUsers.stream().collect(Collectors.toSet());
            Set sourceUserSet = sourceUsers.stream().collect(Collectors.toSet());
            Sets.SetView<DetailedUser> set2AddView = Sets.difference(sourceUserSet, targetUserSet);
            Sets.SetView<DetailedUser> set2RemoveView = Sets.difference(targetUserSet, sourceUserSet);
            this.addUserToGroup(set2AddView, targetGroup);
            this.removeUserToGroup(set2RemoveView, targetGroup);
        } else {
            this.LOG.info("IUMSyncJob skipped Empty Source/Target config");
        }
        return processResult;
    }

    private void removeUserToGroup(Sets.SetView<DetailedUser> sourceUsers, String targetGroup) {
        this.securityService.withPermission(Permission.ADMIN, "Accxia").call(() -> {
            for (DetailedUser detailedUser : sourceUsers) {
                if (detailedUser == null) continue;
                try {
                    this.userAdminService.removeUserFromGroup(targetGroup, detailedUser.getName());
                }
                catch (Exception e) {
                    this.LOG.error("Exception[removeUserFromGroup]: " + e.getMessage(), (Throwable)e);
                }
            }
            return 0;
        });
    }

    private void addUserToGroup(Sets.SetView<DetailedUser> sourceUsers, String targetGroup) {
        this.securityService.withPermission(Permission.ADMIN, "Accxia").call(() -> {
            Set users = sourceUsers.stream().map(Principal::getName).collect(Collectors.toSet());
            try {
                this.userAdminService.addMembersToGroup(targetGroup, users);
            }
            catch (Exception e) {
                this.LOG.error("Exception[removeUserFromGroup]: " + e.getMessage(), (Throwable)e);
            }
            return 0;
        });
    }

    private List<DetailedUser> getUsersFromGroup(String group) {
        Page users;
        ArrayList<DetailedUser> res = new ArrayList<DetailedUser>();
        PageRequestImpl pagerq = new PageRequestImpl(0, 200);
        do {
            users = (Page)this.securityService.withPermission(Permission.ADMIN, "Retrieving repository hook").call(() -> this.userAdminService.findUsersWithGroup(group, "", (PageRequest)new PageRequestImpl(0, 1000)));
            Iterator iterator = users.getValues().iterator();
            while (iterator.hasNext()) {
                res.add((DetailedUser)iterator.next());
            }
        } while ((pagerq = users.getNextPageRequest()) != null);
        return res;
    }

    private static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }
}

