/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.job;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.status.JobDetails;
import de.accxia.apps.bitbucket.ium.config.DAO;
import de.accxia.apps.bitbucket.ium.job.IUMAccessJob;
import de.accxia.apps.bitbucket.ium.job.JobDataUtils;
import de.accxia.apps.bitbucket.ium.job.MonitorJobRunner;
import de.accxia.apps.bitbucket.ium.job.ProcessResult;
import de.accxia.apps.bitbucket.ium.job.access.AccxiaAccessMap;
import de.accxia.apps.bitbucket.ium.model.JobResultDTO;
import de.accxia.apps.bitbucket.ium.repository.JobResultRepository;
import de.accxia.apps.bitbucket.ium.repository.PocketRepository;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/ajob")
@Consumes(value={"text/html", "application/json"})
@Produces(value={"application/json"})
@Component
public class JobAccessRestController {
    private static final Logger LOG = LoggerFactory.getLogger(JobAccessRestController.class);
    @ComponentImport
    private final AuthenticationContext authenticationContext;
    @ComponentImport
    private SecurityService securityService;
    @ComponentImport
    private UserAdminService userAdminService;
    @ComponentImport
    private PermissionService permissionService;
    private final PocketRepository pocketRepository;
    private final JobResultRepository jobResultRepository;
    private final MonitorJobRunner monitorJobRunner;
    private final AccxiaAccessMap accxiaAccessMap;
    private static LocalThread localThread = null;

    @Inject
    public JobAccessRestController(MonitorJobRunner monitorJobRunner, PocketRepository pocketRepository, JobResultRepository jobResultRepository, AccxiaAccessMap accxiaAccessMap, SecurityService securityService, PermissionService permissionService, UserAdminService userAdminService, AuthenticationContext authenticationContext) {
        this.monitorJobRunner = monitorJobRunner;
        this.pocketRepository = pocketRepository;
        this.jobResultRepository = jobResultRepository;
        this.accxiaAccessMap = accxiaAccessMap;
        this.permissionService = permissionService;
        this.securityService = securityService;
        this.userAdminService = userAdminService;
        this.authenticationContext = authenticationContext;
    }

    @Path(value="/config")
    @GET
    @Produces(value={"application/json"})
    public Response getCurrentConfig() {
        List<JobDetails> details;
        HashMap<Object, String> map = new HashMap<Object, String>();
        map.put("daily_repeat_interval", DAO.getDailyRepeatInterval());
        map.put("daily_starting_from", DAO.getDailyStartingFrom());
        map.put("working", String.valueOf(this.monitorJobRunner.isWorking(IUMAccessJob.class)));
        if (this.monitorJobRunner.getJobDetails(IUMAccessJob.class) != null) {
            map.put("jobDetails", this.convert2String(this.monitorJobRunner.getJobDetails(IUMAccessJob.class)));
        }
        if ((details = this.monitorJobRunner.getJobsByJobRunnerKey(IUMAccessJob.class)) != null) {
            for (int i = 0; i < details.size(); ++i) {
                map.put("jobDetails" + i, details.get(i).toString());
            }
        }
        if (this.monitorJobRunner.isWorking(IUMAccessJob.class)) {
            map.put("lastRunForJob", this.convert2String(this.monitorJobRunner.getLastRunForJob(IUMAccessJob.class)));
            map.put("lastSuccessfulRunForJob", this.convert2String(this.monitorJobRunner.getLastSuccessfulRunForJob(IUMAccessJob.class)));
            map.put("nextRunDate", this.convert2String(this.monitorJobRunner.getNextRunDate(IUMAccessJob.class)));
        }
        return Response.ok(map).build();
    }

    @Path(value="/config")
    @POST
    @Produces(value={"application/json"})
    public Response setCurrentConfig(@QueryParam(value="repeat_interval") String repeatinterval, @QueryParam(value="starting_from") String startingFrom) {
        DAO.updateDailyRepeatInterval(repeatinterval);
        DAO.updateDailyStartingFrom(startingFrom);
        return this.getCurrentConfig();
    }

    @Path(value="/start")
    @GET
    @Produces(value={"application/json"})
    public Response startDebugJob() {
        try {
            this.monitorJobRunner.doUnSchedule(IUMAccessJob.class);
            IUMAccessJob.getInstance().injectService(this.pocketRepository, this.jobResultRepository, this.securityService, this.userAdminService);
            IUMAccessJob.getInstance().injectService(this.permissionService);
            String jobKey = this.monitorJobRunner.doSchedule(JobDataUtils.createFakeIUMAccessJobData(), IUMAccessJob.getInstance());
            if (LOG.isDebugEnabled()) {
                LOG.debug("jobKey= " + jobKey);
            }
            return Response.ok((Object)"success").build();
        }
        catch (SchedulerServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/stop")
    @GET
    @Produces(value={"application/json"})
    public Response stopDebugJob() {
        try {
            this.monitorJobRunner.doUnSchedule(IUMAccessJob.class);
            return Response.ok((Object)"success").build();
        }
        catch (SchedulerServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/runnow")
    @GET
    @Produces(value={"application/json"})
    public Response runNowsJob() {
        if (localThread != null && JobAccessRestController.localThread.isWorking) {
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        try {
            HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
            parameters.put("daily_repeat_interval", (Serializable)((Object)DAO.getDailyRepeatInterval()));
            parameters.put("daily_starting_from", (Serializable)((Object)DAO.getDailyStartingFrom()));
            String currentUser = this.authenticationContext.getCurrentUser() != null ? this.authenticationContext.getCurrentUser().getName() : "IUMPlugin";
            parameters.put("current_user", (Serializable)((Object)currentUser));
            IUMAccessJob.getInstance().injectService(this.pocketRepository, this.jobResultRepository, this.securityService, this.userAdminService);
            IUMAccessJob.getInstance().injectService(this.permissionService);
            IUMAccessJob.getInstance().injectService(this.accxiaAccessMap);
            localThread = new LocalThread(currentUser, parameters);
            localThread.start();
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        catch (Exception e) {
            String response = "{\"message\":\"" + e.getMessage() + "\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
    }

    private void doSaveProcessResultList(List<ProcessResult> processResultList, Map<String, Serializable> parameters, long elapsedTime) {
        String currentUser = (String)((Object)parameters.get("current_user"));
        for (ProcessResult processResult : processResultList) {
            this.jobResultRepository.save(JobResultDTO.createJobResult(processResult, currentUser, elapsedTime));
        }
    }

    private <T> String convert2String(T t2) {
        return t2 != null ? t2.toString() : "";
    }

    class LocalThread
    extends Thread {
        Map<String, Serializable> parameters;
        String currentUser;
        List<ProcessResult> processResultList = null;
        String errorMessage;
        boolean isWorking;

        public LocalThread(String currentUser, Map<String, Serializable> parameters) {
            this.parameters = parameters;
            this.currentUser = currentUser;
            this.isWorking = false;
            this.errorMessage = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long startTime = System.currentTimeMillis();
                JobAccessRestController.localThread.isWorking = true;
                IUMAccessJob.getInstance().injectService(JobAccessRestController.this.pocketRepository, JobAccessRestController.this.jobResultRepository, JobAccessRestController.this.securityService, JobAccessRestController.this.userAdminService);
                IUMAccessJob.getInstance().injectService(JobAccessRestController.this.permissionService);
                IUMAccessJob.getInstance().injectService(JobAccessRestController.this.accxiaAccessMap);
                this.parameters.put("current_user", (Serializable)((Object)this.currentUser));
                List<ProcessResult> processResultList = IUMAccessJob.getInstance().doProcessingJob(this.parameters);
                long stopTime = System.currentTimeMillis();
                long elapsedTime = stopTime - startTime;
                JobAccessRestController.localThread.processResultList = processResultList;
            }
            catch (Exception e) {
                LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                try {
                    JobAccessRestController.localThread.errorMessage = e.getMessage();
                }
                catch (Exception ex) {
                    LOG.error("Exception: " + ex.getMessage(), (Throwable)ex);
                    throw new RuntimeException(ex);
                }
            }
            finally {
                JobAccessRestController.localThread.isWorking = false;
            }
        }
    }
}

