/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.servlet.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.auth.AuthenticationService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import de.accxia.apps.bitbucket.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.bitbucket.ium.config.DAO;
import de.accxia.apps.bitbucket.ium.impl.CurrentUser;
import de.accxia.apps.bitbucket.ium.job.access.AccxiaAccessMap;
import de.accxia.apps.bitbucket.ium.repository.NavUserRepository;
import de.accxia.apps.bitbucket.ium.rest.RestRoute;
import de.accxia.apps.bitbucket.ium.servlet.filter.UserSessionTracker;
import de.accxia.apps.bitbucket.ium.util.IUMHelperService;
import de.accxia.apps.bitbucket.ium.util.Quota;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@UnrestrictedAccess
public class IntelligentUserManagerCerberosFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(IntelligentUserManagerCerberosFilter.class);
    public static final String ORIGIN = "origin";
    public static final String URI_RESTORE = "secure/restore";
    public static final String URI_DISABLE = "secure/disable";
    public static int REST_MAX_COUNT = 3;
    @ComponentImport
    private final AuthenticationService authenticationService;
    @ComponentImport
    private final AuthenticationContext authenticationContext;
    @ComponentImport
    private final ApplicationProperties applicationProperties;
    @ComponentImport
    private PageBuilderService pageBuilderService;
    @ComponentImport
    private final TemplateRenderer renderer;
    public final NavUserRepository navUserRepository;
    @ComponentImport
    private final NavBuilder navBuilder;
    private final IUMHelperService helperService;
    private final UserSessionTracker userSessionTracker;
    private final AccxiaAccessMap accxiaAccessMap;

    @Inject
    public IntelligentUserManagerCerberosFilter(IUMHelperService helperService, NavUserRepository navUserRepository, TemplateRenderer renderer, PageBuilderService pageBuilderService, NavBuilder navBuilder, AuthenticationContext authenticationContext, AuthenticationService authenticationService, ApplicationProperties applicationProperties, AccxiaAccessMap accxiaAccessMap, UserSessionTracker userSessionTracker) {
        this.helperService = helperService;
        this.navUserRepository = navUserRepository;
        this.renderer = renderer;
        this.navBuilder = navBuilder;
        this.authenticationContext = authenticationContext;
        this.authenticationService = authenticationService;
        this.applicationProperties = applicationProperties;
        this.pageBuilderService = pageBuilderService;
        this.userSessionTracker = userSessionTracker;
        this.accxiaAccessMap = accxiaAccessMap;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        CurrentUser currentUser;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("IntelligentUserManagerCerberosFilter doFilter requestURI =" + (httpServletRequest.getRequestURI() != null ? httpServletRequest.getRequestURI() : "N/A") + ", servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "N/A") + ", pathInfo=" + (httpServletRequest.getPathInfo() != null ? httpServletRequest.getPathInfo() : "N/A") + ", user=" + (httpServletRequest.getRemoteUser() != null ? httpServletRequest.getRemoteUser() : "N/A"));
        }
        if (httpServletRequest.getRequestURI() != null && httpServletRequest.getRequestURI().contains("j_atl_security_check")) {
            chain.doFilter(request, response);
            return;
        }
        if (!this.authenticationContext.isAuthenticated()) {
            if (httpServletRequest.getRequestURI() != null && httpServletRequest.getRequestURI().contains(URI_DISABLE)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Received disable url=secure/disable for unAuthenticated" + httpServletRequest.getRequestURI() + " ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
                }
                ((HttpServletResponse)response).sendRedirect(httpServletRequest.getContextPath() + "/");
                return;
            }
            if (httpServletRequest.getRequestURI() != null && httpServletRequest.getRequestURI().contains(URI_RESTORE)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Received restore url=secure/restore for unAuthenticated" + httpServletRequest.getRequestURI() + " ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
                }
                ((HttpServletResponse)response).sendRedirect(httpServletRequest.getContextPath() + "/");
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received url=" + httpServletRequest.getRequestURI() + " for unAuthenticated");
            }
            chain.doFilter(request, response);
            return;
        }
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (user == null || !user.isActive()) {
            chain.doFilter(request, response);
            return;
        }
        if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
            chain.doFilter(request, response);
            return;
        }
        if (httpServletRequest.getRequestURI() != null && httpServletRequest.getRequestURI().contains("j_atl_security_logout")) {
            this.userSessionTracker.safeRemove(user);
            chain.doFilter(request, response);
            return;
        }
        String cacheIUMGroupsDisabled = DAO.getIUMGroupsDisabled();
        if (!this.helperService.isUserInGroups(user, cacheIUMGroupsDisabled)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("IntelligentUserManagerCerberosFilter user " + user.getName() + " is not belong to IUM Disable :" + cacheIUMGroupsDisabled + "  ==> forward doFilter ");
            }
            chain.doFilter(request, response);
            return;
        }
        String cacheIUMEnableGroups = DAO.getIUMGroups();
        if (httpServletRequest.getRequestURI() != null && httpServletRequest.getRequestURI().contains(URI_DISABLE)) {
            String username;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received disable url=secure/disable " + httpServletRequest.getRequestURI() + " ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
            }
            if ((username = request.getParameter("username")) == null || username.length() == 0) {
                ((HttpServletResponse)response).sendRedirect(httpServletRequest.getContextPath() + "/");
                return;
            }
            if (this.helperService.isUserInGroups(this.authenticationContext.getCurrentUser(), cacheIUMEnableGroups)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Redirect to the saved url | referrer | base url " + this.applicationProperties.getBaseUrl());
                }
                this.doGlobalRedirect(httpServletRequest, (HttpServletResponse)response);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Redirect user " + username + " to the queue ");
            }
            this.renderQueueVM(username, this.helperService.getQuotaForGroupOfUsername(username), httpServletRequest, (HttpServletResponse)response);
            return;
        }
        if (this.helperService.isUserInGroups(user, cacheIUMEnableGroups)) {
            if (httpServletRequest.getRequestURI() != null && httpServletRequest.getRequestURI().contains(URI_RESTORE)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Received restore url=secure/restore  " + httpServletRequest.getRequestURI() + " ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
                }
                this.doGlobalRedirect(httpServletRequest, (HttpServletResponse)response);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("IntelligentUserManagerCerberosFilter user " + user.getName() + " belong to IUM Enable :" + cacheIUMEnableGroups + "  ==> forward doFilter ");
            }
            chain.doFilter(request, response);
            return;
        }
        if (this.shouldInterceptRestRequest(httpServletRequest)) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("TemporaryLicense=" + httpServletRequest.getRequestURI() + " ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
                }
                CurrentUser cloneUser = this.helperService.enableUserFromGroup(user, httpServletRequest, true);
                this.accxiaAccessMap.remove(user.getName());
                httpServletRequest.getSession().setAttribute("IUMUSER", (Object)user.getName());
                chain.doFilter(request, response);
            }
            catch (Exception ex) {
                LOG.error("Exception: " + ex.getMessage(), (Throwable)ex);
            }
            finally {
                this.accxiaAccessMap.add(user.getName());
            }
            this.authenticationService.clear();
            return;
        }
        if (httpServletRequest.getRequestURI() != null && (httpServletRequest.getRequestURI().contains("/rest/IUM/latest/apps") || httpServletRequest.getRequestURI().contains("/rest/IUM/latest/check") || httpServletRequest.getRequestURI().contains("/rest/IUM/latest/retry") || httpServletRequest.getRequestURI().contains("/rest/") || httpServletRequest.getRequestURI().contains("/rest/gadget/1.0/login"))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("WatchedRestRequest=" + httpServletRequest.getRequestURI() + " ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
            }
            chain.doFilter(request, response);
            return;
        }
        if (httpServletRequest.getRequestURI() != null && httpServletRequest.getRequestURI().contains("/scm")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Clone Request " + httpServletRequest.getRequestURI() + " ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
            }
            try {
                CurrentUser cloneUser = this.helperService.enableUserFromGroup(user, httpServletRequest, true);
                this.accxiaAccessMap.remove(user.getName());
                httpServletRequest.getSession().setAttribute("IUMUSER", (Object)user.getName());
                chain.doFilter(request, response);
            }
            catch (Exception ex) {
                LOG.error("Exception: " + ex.getMessage(), (Throwable)ex);
            }
            finally {
                this.accxiaAccessMap.add(user.getName());
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("For user[" + user.getName() + "] try to enable route=" + httpServletRequest.getRequestURI());
        }
        if ((currentUser = this.helperService.enableUserFromGroup(user, httpServletRequest, false)) != null && currentUser.user != null) {
            this.accxiaAccessMap.remove(user.getName());
            httpServletRequest.getSession().setAttribute("IUMUSER", (Object)user.getName());
            if (httpServletRequest.getRequestURI() != null && httpServletRequest.getRequestURI().contains(URI_RESTORE) && httpServletRequest.getMethod().equalsIgnoreCase("POST")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Received secure/restore " + httpServletRequest.getRequestURI() + " ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
                }
                this.doGlobalRedirect(httpServletRequest, (HttpServletResponse)response);
                return;
            }
            chain.doFilter((ServletRequest)httpServletRequest, response);
            return;
        }
        this.renderQueueVM(user.getName(), currentUser != null ? currentUser.noOfUsers : 0, httpServletRequest, httpServletResponse);
    }

    private void doGlobalRedirect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String referrer;
        String origin = httpServletRequest.getParameter(ORIGIN);
        if (origin != null && origin.length() > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("doGlobalRedirect  ==> " + origin);
            }
            httpServletResponse.sendRedirect(origin);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("IntelligentUserManagerCerberosFilter doGlobalRedirect requestURI =" + (httpServletRequest.getRequestURI() != null ? httpServletRequest.getRequestURI() : "N/A") + ", servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "N/A") + ", pathInfo=" + (httpServletRequest.getPathInfo() != null ? httpServletRequest.getPathInfo() : "N/A") + ", referer=" + (httpServletRequest.getHeader("referer") != null ? httpServletRequest.getHeader("referer") : "N/A") + ", user=" + (httpServletRequest.getRemoteUser() != null ? httpServletRequest.getRemoteUser() : "N/A"));
        }
        if (!((referrer = httpServletRequest.getHeader("referer")) == null || referrer.length() <= 0 || httpServletRequest.getRequestURI() == null || !httpServletRequest.getRequestURI().contains(URI_DISABLE) && !httpServletRequest.getRequestURI().contains(URI_RESTORE) || referrer.contains(URI_DISABLE) && referrer.contains(URI_RESTORE))) {
            httpServletResponse.sendRedirect(referrer);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("doGlobalRedirect  ==> /");
        }
        httpServletResponse.sendRedirect(httpServletRequest.getContextPath() + "/");
    }

    private void renderQueueVM(String username, Quota quota, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("quota= " + quota);
        }
        this.renderQueueVM(username, quota.getQueueSizes(), quota.getFreeSlots(), request, response);
    }

    private void renderQueueVM(String username, int noOfUsers, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.renderQueueVM(username, noOfUsers, -1, request, response);
    }

    private void renderQueueVM(String username, int noOfUsers, int freeSlots, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String referrer;
        String baseurl = this.applicationProperties.getBaseUrl();
        String origin = request.getParameter(ORIGIN);
        if (!(origin != null && origin.length() != 0 || (referrer = request.getHeader("referer")) == null || referrer.contains(URI_DISABLE) || referrer.contains("/login.jsp"))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Retrive referrer from request: " + referrer + " update latest ref");
            }
            origin = referrer;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(ORIGIN, origin);
        context.put("applicationProperties", this.applicationProperties);
        context.put("redirUrl", this.applicationProperties.getBaseUrl());
        context.put("baseurl", this.applicationProperties.getBaseUrl());
        context.put("duration", DAO.getDuration());
        context.put("urlLogo", DAO.getUrlLogo());
        context.put("queueMessage", DAO.getQueueMessage());
        context.put("username", request.getRemoteUser());
        context.put("queueSize", noOfUsers);
        if (freeSlots > 0) {
            context.put("freeSlots", freeSlots);
        }
        response.setContentType("text/html;charset=utf-8");
        this.pageBuilderService.assembler().resources().requireWebResource("de.accxia.apps.bitbucket.ium.IUMForBitbucket:IUM-Check-resources");
        this.pageBuilderService.assembler().resources().requireWebResource("de.accxia.apps.bitbucket.ium.IUMForBitbucket:IUM-resources");
        this.pageBuilderService.assembler().assembled().drainIncludedResources().writeHtmlTags((Writer)response.getWriter(), UrlMode.RELATIVE);
        this.renderer.render("templates/queue_IUM.vm", context, (Writer)response.getWriter());
    }

    private boolean shouldInterceptRestRequest(HttpServletRequest request) {
        if (RestRoute.getInstance().isEmpty()) {
            return false;
        }
        String referrer = request.getHeader("referer");
        String path = request.getRequestURI();
        boolean contain = Arrays.stream(RestRoute.getInstance().getAllRestRoutes()).anyMatch(s2 -> path.indexOf((String)s2) != -1);
        return contain;
    }

    private void doWarnRequestData(ServletRequest request, ServletResponse response) {
        try {
            Cookie[] cookies;
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            if (httpRequest.getQueryString() != null) {
                LOG.warn("QueryString=" + httpRequest.getQueryString());
            }
            for (Cookie cookie : cookies = httpRequest.getCookies()) {
                LOG.warn(cookie.getName() + " " + cookie.getValue());
            }
            Enumeration headerNames = httpRequest.getHeaderNames();
            if (headerNames != null) {
                while (headerNames.hasMoreElements()) {
                    String headerName = (String)headerNames.nextElement();
                    LOG.warn(headerName + "=" + httpRequest.getHeader(headerName));
                }
            }
            Enumeration parameterNames = httpRequest.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameterName = (String)parameterNames.nextElement();
                LOG.warn(parameterName + "=" + httpRequest.getParameter(parameterName));
            }
            Enumeration attributeNames = httpRequest.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                String attributeName = (String)attributeNames.nextElement();
                LOG.warn(attributeName + "=" + httpRequest.getParameter(attributeName));
            }
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
        }
    }
}

