/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet.filter;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.collect.Maps;
import de.accxia.jira.addon.IUM.domain.enums.LicenseType;
import de.accxia.jira.addon.IUM.service.LicenseService;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LicenseFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(LicenseFilter.class);
    @ComponentImport
    private final TemplateRenderer templateRenderer;
    private final LicenseService licenseService;

    public LicenseFilter(TemplateRenderer templateRenderer, LicenseService licenseService) {
        this.templateRenderer = templateRenderer;
        this.licenseService = licenseService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.licenseService.getCurrentLicenseType().equals((Object)LicenseType.NO_LICENSED) && Objects.isNull(request.getParameter("sideLicense"))) {
            HashMap context = Maps.newHashMap();
            response.setContentType("text/html;charset=utf-8");
            context.put("showSideLicense", true);
            this.templateRenderer.render("templates/checklicense_IUM.vm", (Map)context, (Writer)response.getWriter());
            return;
        }
        filterChain.doFilter(request, response);
    }

    public void destroy() {
    }
}

