/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.domain.model.CurrentUser;
import de.accxia.jira.addon.IUM.saml.SAMLHelper;
import de.accxia.jira.addon.IUM.service.impl.UserManagementServiceImpl;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class SAMLServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(SAMLServlet.class);
    @ComponentImport
    private final com.atlassian.sal.api.user.UserManager userManager;
    @ComponentImport
    private final LoginUriProvider loginUriProvider;
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;
    @ComponentImport
    private final ApplicationProperties applicationProperties;
    @ComponentImport
    private final UserManager userManagerJira;
    @ComponentImport
    private final PluginController pluginController;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpServletRequest req = request;
        String samlPar = req.getParameter("SAMLResponse");
        String user = SAMLHelper.getSAMLUserFromSAMLResponse(samlPar);
        if (user == null) {
            response.sendRedirect(DAO.getSamlIdp());
            return;
        }
        ApplicationUser applicationUser = this.userManagerJira.getUserByName(user);
        if ("".equals(DAO.getSamlIdp())) {
            response.sendRedirect("/");
            return;
        }
        if (UserManagementServiceImpl.isUserInGroups(applicationUser, DAO.getIUMGroups())) {
            response.sendRedirect(DAO.getSamlIdp());
            return;
        }
        if (!UserManagementServiceImpl.isUserInGroups(applicationUser, DAO.getIUMGroupsDisabled())) {
            response.sendRedirect(DAO.getSamlIdp());
            return;
        }
        CurrentUser currentUser = UserManagementServiceImpl.enableUserFromGroup(user, req);
        if (currentUser != null) {
            ApplicationUser theUser = currentUser.getUser();
            if (theUser != null) {
                request.getSession().setAttribute("IUMUSER", (Object)theUser.getUsername());
                response.sendRedirect(DAO.getSamlIdp());
                return;
            }
            this.renderQueueVM(currentUser.getNoOfUsers(), request, response);
            return;
        }
    }

    private void renderQueueVM(int noOfUsers, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("duration", DAO.getDuration());
        context.put("queueSize", noOfUsers);
        context.put("redirUrl", DAO.getSamlIdp());
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/queue_IUM.vm", context, (Writer)response.getWriter());
    }

    public SAMLServlet(com.atlassian.sal.api.user.UserManager userManager, LoginUriProvider loginUriProvider, TemplateRenderer renderer, PluginLicenseManager pluginLicenseManager, ApplicationProperties applicationProperties, UserManager userManagerJira, PluginController pluginController) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.renderer = renderer;
        this.pluginLicenseManager = pluginLicenseManager;
        this.applicationProperties = applicationProperties;
        this.userManagerJira = userManagerJira;
        this.pluginController = pluginController;
    }
}

