/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.UserDto;
import de.accxia.jira.addon.IUM.service.impl.UserManagementServiceImpl;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import javax.inject.Inject;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UserManagementServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(UserManagementServlet.class);
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final LoginUriProvider loginUriProvider;
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;
    @ComponentImport
    private final PluginController pluginController;
    @ComponentImport
    private final WebSudoManager webSudoManager;
    private static final UserUtil userUtil = ComponentAccessor.getUserUtil();
    private static final GroupManager groupManager = ComponentAccessor.getGroupManager();
    private final UserManagementServiceImpl userManagementService;
    private String fromgroup = null;
    private String togroup = null;
    private String filtergroup = null;
    private String size = "10";

    @Inject
    public UserManagementServlet(PluginController pluginController, UserManager userManager, LoginUriProvider loginUriProvider, TemplateRenderer renderer, PluginLicenseManager pluginLicenseManager, WebSudoManager webSudoManager, UserManagementServiceImpl userManagementService) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.renderer = renderer;
        this.pluginLicenseManager = pluginLicenseManager;
        this.pluginController = pluginController;
        this.webSudoManager = webSudoManager;
        this.userManagementService = userManagementService;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            UserKey userKey = this.userManager.getRemoteUserKey();
            if (userKey == null || !this.userManager.isAdmin(userKey)) {
                this.redirectToLogin(request, response);
                return;
            }
            this.webSudoManager.willExecuteWebSudoRequest(request);
            String action = this.getParameter(request, "action");
            if (!ConditionEvaluatorImpl.isLicenseValid()) {
                this.renderLicenseErrorVM(response, false);
                return;
            }
            HashMap attributes = Maps.newHashMap();
            boolean showSideLicense = !DAO.getSideLicense().isEmpty();
            String fromGroup = this.getParameter(request, "fromgroup");
            String toGroup = this.getParameter(request, "togroup");
            this.fromgroup = this.setValue("fromgroup", fromGroup);
            this.togroup = this.setValue("togroup", toGroup);
            if ("list".equals(action)) {
                String filterGroup = this.getParameter(request, "filtergroup");
                int size = 10;
                if (!Strings.isNullOrEmpty((String)request.getParameter("noof"))) {
                    size = Integer.parseInt(request.getParameter("noof"));
                }
                this.filtergroup = this.setValue("filtergroup", filterGroup);
                this.size = this.setValue("noof", "" + size);
                List<UserDto> users = this.userManagementService.getAllSortedUserListFromGroup(this.fromgroup, this.filtergroup);
                SortedSet admins = userUtil.getAllUsersInGroupNames(Arrays.asList("jira-administrators", "system-administrators"));
                for (UserDto userDto : users) {
                    if (!admins.contains(userDto.getUser())) continue;
                    userDto.setIsAdmin(true);
                }
                attributes.put("fromgroup", fromGroup);
                attributes.put("togroup", toGroup);
                attributes.put("filtergroup", filterGroup);
                attributes.put("noof", this.getValue("noof", "" + size));
                attributes.put("users", users);
                attributes.put("size", request.getParameter("size"));
            } else if ("move".equals(action) || "copy".equals(action)) {
                String res = "";
                if (request.getParameter("selUser") != null) {
                    String[] selectedUsers = request.getParameterValues("selUser");
                    res = UserManagementServiceImpl.moveUsersInListFromGroupToGroup(selectedUsers, fromGroup, toGroup, "move".equals(action));
                }
                attributes.put("fromgroup", this.getValue("fromgroup", fromGroup));
                attributes.put("togroup", this.getValue("togroup", toGroup));
                attributes.put("filtergroup", this.getParameter(request, "filtergroup"));
                attributes.put("noof", this.getValue("noof", this.size));
                attributes.put("size", request.getParameter("size"));
                attributes.put("message", res);
            }
            attributes.put("showSideLicense", showSideLicense);
            this.renderUserVM(response, attributes);
        }
        catch (WebSudoSessionException wes) {
            response.sendError(403);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            boolean showSideLicense;
            UserKey userKey = this.userManager.getRemoteUserKey();
            if (userKey == null || !this.userManager.isAdmin(userKey)) {
                this.redirectToLogin(request, response);
                return;
            }
            this.webSudoManager.willExecuteWebSudoRequest(request);
            boolean bl = showSideLicense = request.getParameter("sl") != null;
            if (showSideLicense) {
                this.renderSideLicenseVM(response);
            } else {
                boolean bl2 = showSideLicense = !"".equals(DAO.getSideLicense());
                if (!ConditionEvaluatorImpl.isLicenseValid()) {
                    this.renderLicenseErrorVM(response, showSideLicense);
                    return;
                }
                if (request.getParameter("oldest") != null) {
                    UserKey currentUserKey = this.userManager.getRemoteUserKey();
                    ApplicationUser currentUser = userUtil.getUserByKey(currentUserKey.getStringValue());
                    String theGroup = this.getValue("fromgroup", null);
                    Group testGroup = groupManager.getGroup(theGroup);
                    UserDto userDto = UserManagementServiceImpl.getOldestUser(testGroup, currentUser);
                    response.setContentType("text/plain");
                    long lastLogin = UserManagementServiceImpl.getLastLoginFromUser(currentUser);
                    if (userDto != null && userDto.getUser() != null) {
                        response.getWriter().write("Oldest User for Group " + theGroup + " =" + userDto.getUser().getUsername() + " last login was " + lastLogin + " oldestTs=" + userDto.getTs());
                    } else {
                        response.getWriter().write("No Oldest User found for Group " + theGroup);
                    }
                    return;
                }
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("fromgroup", "");
                attributes.put("filtergroup", this.getValue("filtergroup", this.filtergroup));
                attributes.put("noof", this.getValue("noof", this.size));
                attributes.put("size", "10");
                attributes.put("showSideLicense", showSideLicense);
                this.renderUserVM(response, attributes);
            }
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    private void renderLicenseErrorVM(HttpServletResponse response, boolean showSideLicense) throws IOException {
        HashMap<String, Boolean> context = new HashMap<String, Boolean>();
        response.setContentType("text/html;charset=utf-8");
        context.put("showSideLicense", showSideLicense);
        this.renderer.render("templates/checklicense_IUM.vm", context, (Writer)response.getWriter());
    }

    private void renderUserVM(HttpServletResponse response, Map<String, Object> context) throws IOException {
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/user_management_page.vm", context, (Writer)response.getWriter());
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private void renderSideLicenseVM(HttpServletResponse response) throws IOException {
        HashMap context = new HashMap();
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/sidelicense_IUM.vm", context, (Writer)response.getWriter());
    }

    public String getValue(String key, String currentVal) {
        return currentVal == null ? DAO.getValue(key) : currentVal;
    }

    public String setValue(String key, String value) {
        if (value == null) {
            value = "";
        }
        DAO.setValue(key, value);
        return value;
    }

    private boolean isEmpty(String contextPath) {
        return contextPath == null || contextPath.isEmpty();
    }

    private String getParameter(HttpServletRequest request, String parameter) {
        return request.getParameter(parameter) != null ? request.getParameter(parameter) : "";
    }

    private String getParameter(HttpServletRequest request, String parameter, String defaultValue) {
        return request.getParameter(parameter) != null ? request.getParameter(parameter) : defaultValue;
    }
}

