/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.conditions;

import com.atlassian.jira.license.LicenseCountService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluator;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.domain.enums.LicenseType;
import de.accxia.jira.addon.IUM.domain.model.LicenseData;
import de.accxia.jira.addon.IUM.side.VerifyMessage;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.inject.Inject;
import javax.inject.Named;

@ExportAsService(value={ConditionEvaluator.class})
@Named(value="IUMIsPluginLicensedCondition")
public class ConditionEvaluatorImpl
implements ConditionEvaluator {
    @ComponentImport
    private static PluginLicenseManager licenseManager;
    @ComponentImport
    private static LicenseCountService licenseCountService;
    private static LicenseData sideLicense;

    public static LicenseData getSideLicense() {
        return sideLicense;
    }

    public static void setSideLicense() {
        sideLicense = VerifyMessage.checkSideLicenses();
    }

    public static void deleteSideLicense() {
        sideLicense = null;
    }

    @Inject
    public ConditionEvaluatorImpl(PluginLicenseManager licenseManager, LicenseCountService licenseCountService) {
        ConditionEvaluatorImpl.licenseManager = licenseManager;
        ConditionEvaluatorImpl.licenseCountService = licenseCountService;
        ConditionEvaluatorImpl.setSideLicense();
    }

    @Override
    public boolean evaluate(LicenseType type) {
        switch (type) {
            case JIRA_LICENSED: {
                return ConditionEvaluatorImpl.isLicenseValid();
            }
            case SIDE_LICENSED: {
                return VerifyMessage.isSideLicenseValid(sideLicense);
            }
            case WRONG_SIDE_LICENSE: {
                if (DAO.getSideLicense().isEmpty()) {
                    return false;
                }
                boolean ignoreResult = ConditionEvaluatorImpl.isLicenseValid();
                return true;
            }
        }
        return false;
    }

    public static boolean isLicenseValid() {
        boolean isLicensed = false;
        boolean hasErrors = false;
        for (PluginLicense pluginLicense : licenseManager.getLicense()) {
            isLicensed = true;
            hasErrors = hasErrors || pluginLicense.getError().isDefined();
        }
        isLicensed = isLicensed && !hasErrors;
        return isLicensed || VerifyMessage.isSideLicenseValid(sideLicense);
    }

    public static boolean isEvaluation() {
        boolean isEval = false;
        for (PluginLicense pluginLicense : licenseManager.getLicense()) {
            if (!pluginLicense.isEvaluation()) continue;
            return true;
        }
        return isEval;
    }

    public static boolean isToOldEval(String timestampStr) {
        if (timestampStr != null && !"".equals(timestampStr)) {
            Timestamp timestamp = new Timestamp(Long.parseLong(timestampStr));
            Timestamp now = new Timestamp(System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(timestamp.getTime());
            cal.add(5, 45);
            Timestamp newtimestamp = new Timestamp(cal.getTime().getTime());
            if (newtimestamp.before(now)) {
                return true;
            }
        }
        return false;
    }

    static {
        sideLicense = null;
    }
}

