/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.side;

import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.domain.enums.LicenseStatus;
import de.accxia.jira.addon.IUM.domain.model.LicenseData;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyMessage {
    private static final Logger log = LoggerFactory.getLogger(VerifyMessage.class);
    private static final ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
    private static final ApplicationAuthorizationService applicationAuthorizationService = (ApplicationAuthorizationService)ComponentAccessor.getComponent(ApplicationAuthorizationService.class);
    private static final String OURAPPKEY = "de.accxia.jira.addon.IUM.IntelligentUserManager";
    private static final String OURAPPKEY2 = "de.accxia.jira.addon.IUM.Enhanced";
    private static Gson gson = new Gson();

    public static LicenseData verifyMessageString(String theMessage) throws Exception {
        byte[] vmessage;
        String[] msg = theMessage.split("\\$\\$");
        byte[] dmessage = Base64.getDecoder().decode(msg[0].getBytes());
        if (VerifyMessage.verifySignatureString(dmessage, vmessage = Base64.getDecoder().decode(msg[1].getBytes()))) {
            return gson.fromJson(new String(dmessage), LicenseData.class);
        }
        return null;
    }

    public static LicenseData checkSideLicenses() {
        String sideLicense = DAO.getSideLicense();
        if (Strings.isNullOrEmpty((String)sideLicense)) {
            return null;
        }
        try {
            LicenseData res = VerifyMessage.verifyMessageString(sideLicense);
            return res;
        }
        catch (JsonSyntaxException e) {
            log.warn(e.getMessage());
            return null;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }

    private static boolean verifySignatureString(byte[] data, byte[] signature) throws Exception {
        try {
            Signature sig = Signature.getInstance("SHA1withRSA");
            String publicKey = "MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBAIYrjQBEg6RPMYXJwS8FxE5E/s0I5XCpIlBP3yGi4zm3sGwiwyqck40MzMCBbb+3RoBZZkpfzNr99WYa3x+jme8CAwEAAQ==";
            sig.initVerify(VerifyMessage.getPublicFromString(publicKey));
            sig.update(data);
            return sig.verify(signature);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static int getNumberOfApplicationUsers() {
        int userNum = Math.max(applicationAuthorizationService.getUserCount(ApplicationKeys.SOFTWARE), applicationAuthorizationService.getUserCount(ApplicationKeys.CORE));
        userNum = Math.max(userNum, applicationAuthorizationService.getUserCount(ApplicationKeys.SERVICE_DESK));
        return userNum;
    }

    public static LicenseStatus getLicenseStatus(LicenseData sideLicense) {
        String ourServerID = applicationProperties.getString("jira.sid.key");
        if (sideLicense == null) {
            return LicenseStatus.LICENSE_MISSING;
        }
        if (!(OURAPPKEY.equals(sideLicense.getAppKey()) || OURAPPKEY2.equals(sideLicense.getAppKey()) || "".equals(sideLicense.getAppKey()))) {
            return LicenseStatus.LICENSE_WRONG_APP_KEY;
        }
        if (ourServerID == null || !ourServerID.equals(sideLicense.getSid()) && !"".equals(sideLicense.getSid())) {
            return LicenseStatus.LICENSE_WRONG_SERVER_ID;
        }
        if (VerifyMessage.getNumberOfApplicationUsers() > sideLicense.getUsers()) {
            return LicenseStatus.LICENSE_USERS_LIMIT;
        }
        return LicenseStatus.LICENSE_OK;
    }

    public static boolean isSideLicenseValid(LicenseData sideLicense) {
        return VerifyMessage.getLicenseStatus(sideLicense) == LicenseStatus.LICENSE_OK;
    }

    public static PublicKey getPublicFromString(String publicKey) throws Exception {
        byte[] keyBytes0 = publicKey.getBytes();
        byte[] keyBytes = Base64.getDecoder().decode(keyBytes0);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePublic(spec);
    }
}

