var isDeleted = false

var IUMLicenseInput = new function () {
    this.enterLicense = function () {
        var $theEle = AJS.$(".upm-plugin-name:contains(Intelligent User Manager)");
        var $ourRoot = $theEle.parent().parent().find(".submit-license");


        //Remove Side License
        if ($ourRoot.hasClass("AccxiaLicenseDone")) {
            if(AJS.$(".licenseKeyIUM").val() === "") {
                $.ajax({
                    url: AJS.contextPath() + "/rest/IUM/1.0/sideLicense",
                    type: 'DELETE',
                    dataType: 'json',
                    async: false,
                    success: function(result) {
                        isDeleted = true
                    },
                    error: function () {

                    }
                });
            };
            return;
        }

        //Add Side License
        setTimeout(function () {
            var $theEle = AJS.$(".upm-plugin-name:contains(Intelligent User Manager)");
            var $ourRoot = $theEle.parent().parent();
            var ourLicense = $ourRoot.find(".edit-license-key");

            $ourRoot.find(".submit-license").addClass("AccxiaLicenseDone").click(
                function (e) {
                    if (ourLicense.val().indexOf("$$") != -1) {
                        $.ajax({
                            url: AJS.contextPath() + "/rest/IUM/1.0/sideLicense",
                            type: 'POST',
                            data: {
                                "sideLicense": ourLicense.val()
                            },
                            dataType: 'json',
                            async: false,
                            success: function() {
                                AJS.dialog2("#sideLicenseDialog").show();
                            }
                        });
                        return false;
                    }
                    return true;
                });
        }, 1200);
    }
}

AJS.$(document).ready(function () {
    try {
        if (AJS.$("#upm-container").size() == 0) {
            return;
        }

        if (typeof JIRA != "undefined") {
            JIRA.bind(JIRA.Events.NEW_CONTENT_ADDED, function (e, $ctx) {
                IUMLicenseInput.enterLicense();
            });
        }

        IUMLicenseInput.enterLicense();

        //intercept jquery, dojo, etc. ajax requests to trigger app
        (function (send) {
            XMLHttpRequest.prototype.send = function (data) {
                send.call(this, data);
                if (!isDeleted) {
                    IUMLicenseInput.enterLicense();
                }
                isDeleted = false
            };
        })(XMLHttpRequest.prototype.send);
    } catch (e) {
    }
});

AJS.$(document).ready(function () {
    AJS.$("<section\n" +
        "        id='sideLicenseDialog'" +
        "        class='aui-dialog2 aui-dialog2-small aui-layer'" +
        "        role='dialog'" +
        "        tabindex='-1'" +
        "        aria-labelledby='dialog-show-button--heading'" +
        "        hidden>" +
        "    <header class='aui-dialog2-header'>" +
        "        <h4 class='aui-dialog2-header-main' id='dialog-show-button--heading'>Intelligent User Manager</h4>" +
        "        <button class='aui-close-button' type='button' aria-label='close'></button>" +
        "    </header>" +
        "    <div class='aui-dialog2-content'>" +
        "        <p>Thank you for using our products. To start training, click the \"Get started\" button.</p>" +
        "    </div>" +
        "    <footer class='aui-dialog2-footer'>" +
        "        <div class='aui-dialog2-footer-actions'>" +
        "            <button id='dialog-submit-button' class='aui-button aui-button'>Get started</button>" +
        "        </div>" +
        "    </footer>" +
        "</section>").insertAfter("body")
});

AJS.$(document).on("click", "#dialog-submit-button", function () {
    AJS.dialog2("#sideLicenseDialog").hide();

    var $form = AJS.$("<form id='sideLicenseForm' method='POST' action='" + AJS.contextPath() + "/plugins/servlet/ium-config?assistant=true'></form>").insertAfter("body");
    $form.submit();
})


