/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.event_listener;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.user.LogoutEvent;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.service.SamlService;
import de.accxia.jira.addon.IUM.service.impl.UserManagementServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class PluginEventListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(PluginEventListener.class);
    @ComponentImport
    private final EventPublisher eventPublisher;
    private final SamlService samlService;

    public PluginEventListener(EventPublisher eventPublisher, SamlService samlService) {
        this.eventPublisher = eventPublisher;
        this.samlService = samlService;
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onLogoutEvent(LogoutEvent logoutEvent) {
        ApplicationUser user;
        if (ConditionEvaluatorImpl.isLicenseValid() && (user = logoutEvent.getUser()) != null) {
            UserManagementServiceImpl.moveUserToDisabled(user);
        }
    }
}

