/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet.filter;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.domain.model.CurrentUser;
import de.accxia.jira.addon.IUM.service.impl.UserManagementServiceImpl;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IntelligentUserManagerServletFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(IntelligentUserManagerServletFilter.class);
    @ComponentImport
    private final TemplateRenderer templateRenderer;
    private boolean directMode = false;
    private static com.atlassian.sal.api.user.UserManager userManager = (com.atlassian.sal.api.user.UserManager)ComponentAccessor.getOSGiComponentInstanceOfType(com.atlassian.sal.api.user.UserManager.class);
    private static UserManager userManagerJira = ComponentAccessor.getUserManager();
    @ComponentImport
    private final UserUtil userUtil;
    private final UserManagementServiceImpl userManagementService;

    public IntelligentUserManagerServletFilter(TemplateRenderer templateRenderer, UserUtil userUtil, UserManagementServiceImpl userManagementService) {
        this.templateRenderer = templateRenderer;
        this.userUtil = userUtil;
        this.userManagementService = userManagementService;
    }

    public void init(FilterConfig filterConfig) {
        this.directMode = "direct".equals(filterConfig.getInitParameter("mode"));
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!ConditionEvaluatorImpl.isLicenseValid()) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (httpRequest.getMethod().equalsIgnoreCase("POST")) {
            String[] unames = request.getParameterValues("os_username");
            if (unames.length == 0) {
                chain.doFilter(request, response);
            }
            ApplicationUser user = userManagerJira.getUserByName(unames[0]);
            if (UserManagementServiceImpl.isUserInGroups(user, DAO.getIUMGroups())) {
                chain.doFilter(request, response);
                return;
            }
            if (!UserManagementServiceImpl.isUserInGroups(user, DAO.getIUMGroupsDisabled())) {
                chain.doFilter(request, response);
                return;
            }
            if (unames != null && unames.length > 0 && userManager.authenticate(request.getParameterValues("os_username")[0], request.getParameterValues("os_password")[0])) {
                CurrentUser currentUser = UserManagementServiceImpl.enableUserFromGroup(unames[0], httpRequest);
                if (currentUser != null) {
                    ApplicationUser theUser = currentUser.getUser();
                    if (theUser != null) {
                        httpRequest.getSession().setAttribute("IUMUSER", (Object)theUser.getUsername());
                        if (this.directMode) {
                            this.renderLoginVM(httpRequest, (HttpServletResponse)response);
                        } else {
                            this.renderLoginVM(httpRequest, (HttpServletResponse)response);
                        }
                        return;
                    }
                    this.renderQueueVM(currentUser.getNoOfUsers(), httpRequest, (HttpServletResponse)response);
                    return;
                }
            }
        }
        chain.doFilter(request, response);
    }

    private void renderLoginVM(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String user = request.getParameter("os_username");
        String pass = request.getParameter("os_password");
        String dest = request.getParameter("os_destination");
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("user", user);
        context.put("pass", pass);
        context.put("dest", dest);
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("templates/login_IUM.vm", context, (Writer)response.getWriter());
    }

    private void renderQueueVM(int noOfUsers, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String user = request.getParameter("os_username");
        String pass = request.getParameter("os_password");
        String dest = request.getParameter("os_destination");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("user", user);
        context.put("pass", pass);
        context.put("dest", dest);
        context.put("duration", DAO.getDuration());
        context.put("queueSize", noOfUsers);
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("templates/queue_IUM.vm", context, (Writer)response.getWriter());
    }
}

